/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class EclipseLog
implements FrameworkLog {
    private static final String PASSWORD = "-password";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String SUBENTRY = "!SUBENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    public static final int DEFAULT_LOG_SIZE = 1000;
    public static final int DEFAULT_LOG_FILES = 10;
    public static final int LOG_SIZE_MIN = 10;
    public static final String PROP_LOG_SIZE_MAX = "eclipse.log.size.max";
    public static final String PROP_LOG_FILE_MAX = "eclipse.log.backup.max";
    public static final String LOG_EXT = ".log";
    public static final String BACKUP_MARK = ".bak_";
    private static final SecureAction secureAction;
    protected boolean consoleLog = false;
    protected boolean newSession = true;
    protected File outFile;
    protected Writer writer;
    int maxLogSize = 1000;
    int maxLogFiles = 10;
    int backupIdx = 0;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        secureAction = new SecureAction();
    }

    public EclipseLog(File file) {
        this.outFile = file;
        this.writer = null;
        this.readLogProperties();
    }

    public EclipseLog(Writer writer) {
        this.writer = writer == null ? this.logForStream(System.err) : writer;
    }

    public EclipseLog() {
        this((Writer)null);
    }

    private Throwable getRoot(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = null;
        if (throwable instanceof BundleException) {
            throwable3 = ((BundleException)throwable).getNestedException();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable3 = ((InvocationTargetException)throwable).getTargetException();
        }
        if ((throwable3 instanceof InvocationTargetException || throwable3 instanceof BundleException) && (throwable2 = this.getRoot(throwable3)) != null) {
            throwable3 = throwable2;
        }
        return throwable3;
    }

    protected void writeArgs(String string, String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.write(string);
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0 && PASSWORD.equals(stringArray[n - 1])) {
                this.write(" (omitted)");
            } else {
                this.write(" " + stringArray[n]);
            }
            ++n;
        }
        this.writeln();
    }

    protected String getSessionTimestamp() {
        String string = FrameworkProperties.getProperty("eclipse.startTime");
        if (string != null) {
            try {
                return this.getDate(new Date(Long.parseLong(string)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.getDate(new Date());
    }

    protected void writeSession() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String string = this.getSessionTimestamp();
        this.write(string);
        this.writeSpace();
        int n = SESSION.length() + string.length();
        while (n < 78) {
            this.write("-");
            ++n;
        }
        this.writeln();
        try {
            String string2 = "eclipse.buildId";
            String string3 = FrameworkProperties.getProperty(string2, "unknown");
            this.writeln(String.valueOf(string2) + "=" + string3);
            string2 = "java.fullversion";
            string3 = System.getProperty(string2);
            if (string3 == null) {
                string2 = "java.version";
                string3 = System.getProperty(string2);
                this.writeln(String.valueOf(string2) + "=" + string3);
                string2 = "java.vendor";
                string3 = System.getProperty(string2);
                this.writeln(String.valueOf(string2) + "=" + string3);
            } else {
                this.writeln(String.valueOf(string2) + "=" + string3);
            }
        }
        catch (Exception exception) {}
        this.write("BootLoader constants: OS=" + EclipseEnvironmentInfo.getDefault().getOS());
        this.write(", ARCH=" + EclipseEnvironmentInfo.getDefault().getOSArch());
        this.write(", WS=" + EclipseEnvironmentInfo.getDefault().getWS());
        this.writeln(", NL=" + EclipseEnvironmentInfo.getDefault().getNL());
        this.writeArgs("Framework arguments: ", EclipseEnvironmentInfo.getDefault().getNonFrameworkArgs());
        this.writeArgs("Command-line arguments: ", EclipseEnvironmentInfo.getDefault().getCommandLineArgs());
    }

    public void close() {
        try {
            if (this.writer != null) {
                Writer writer = this.writer;
                this.writer = null;
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void openFile() {
        if (this.writer == null) {
            if (this.outFile != null) {
                try {
                    this.writer = this.logForStream(secureAction.getFileOutputStream(this.outFile, true));
                }
                catch (IOException iOException) {
                    this.writer = this.logForStream(System.err);
                }
            } else {
                this.writer = this.logForStream(System.err);
            }
        }
    }

    protected void closeFile() {
        if (this.outFile != null && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.writer = null;
        }
    }

    public void log(FrameworkEvent frameworkEvent) {
        Bundle bundle = frameworkEvent.getBundle();
        Throwable throwable = frameworkEvent.getThrowable();
        String string = bundle.getSymbolicName() == null ? bundle.getLocation() : bundle.getSymbolicName();
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry(string, 4, 0, "FrameworkEvent.ERROR", 0, throwable, null);
        this.log(frameworkLogEntry);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void log(FrameworkLogEntry frameworkLogEntry) {
        if (frameworkLogEntry == null) {
            return;
        }
        try {
            try {
                this.checkLogFileSize();
                this.openFile();
                if (this.newSession) {
                    this.writeSession();
                    this.newSession = false;
                }
                this.writeLog(0, frameworkLogEntry);
                this.writer.flush();
            }
            catch (Exception exception) {
                System.err.println("An exception occurred while writing to the platform log:");
                exception.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.writer = this.logForStream(System.err);
                    this.writeLog(0, frameworkLogEntry);
                    this.writer.flush();
                }
                catch (Exception exception2) {
                    System.err.println("An exception occurred while logging to the console:");
                    exception2.printStackTrace(System.err);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeFile();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeFile();
            return;
        }
    }

    public synchronized void setWriter(Writer writer, boolean bl) {
        this.setOutput(null, writer, bl);
    }

    public synchronized void setFile(File file, boolean bl) throws IOException {
        if (file != null && !file.equals(this.outFile)) {
            this.readLogProperties();
            this.backupIdx = 0;
        }
        this.setOutput(file, null, bl);
        FrameworkProperties.setProperty("osgi.logfile", file.getAbsolutePath());
    }

    public synchronized File getFile() {
        return this.outFile;
    }

    public void setConsoleLog(boolean bl) {
        this.consoleLog = bl;
    }

    /*
     * Exception decompiling
     */
    private void setOutput(File var1_1, Writer var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 180->184)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyReader(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            writer.write(cArray, 0, n);
        }
    }

    protected String getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPaddedInt(calendar.get(1), 4, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(2) + 1, 2, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(5), 2, stringBuffer).append(' ');
        this.appendPaddedInt(calendar.get(11), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(12), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(13), 2, stringBuffer).append('.');
        this.appendPaddedInt(calendar.get(14), 3, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer appendPaddedInt(int var1_1, int var2_2, StringBuffer var3_3) {
        if (--var2_2 == 0) {
            return var3_3.append(Integer.toString(var1_1));
        }
        var4_4 = (int)Math.pow(10.0, var2_2);
        if (var1_1 < var4_4) ** GOTO lbl9
        return var3_3.append(Integer.toString(var1_1));
lbl-1000:
        // 1 sources

        {
            var3_3.append('0');
            var4_4 /= 10;
lbl9:
            // 2 sources

            ** while (var4_4 > var1_1 && var4_4 > 1)
        }
lbl10:
        // 1 sources

        var3_3.append(var1_1);
        return var3_3;
    }

    protected String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        Throwable throwable2 = this.getRoot(throwable);
        if (throwable2 != null) {
            printWriter.println("Root exception:");
            throwable2.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    protected Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    protected void writeLog(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        this.writeEntry(n, frameworkLogEntry);
        this.writeMessage(frameworkLogEntry);
        this.writeStack(frameworkLogEntry);
        FrameworkLogEntry[] frameworkLogEntryArray = frameworkLogEntry.getChildren();
        if (frameworkLogEntryArray != null) {
            int n2 = 0;
            while (n2 < frameworkLogEntryArray.length) {
                this.writeLog(n + 1, frameworkLogEntryArray[n2]);
                ++n2;
            }
        }
    }

    protected void writeEntry(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        if (n == 0) {
            this.writeln();
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(n));
        }
        this.writeSpace();
        this.write(frameworkLogEntry.getEntry());
        if (frameworkLogEntry.getSeverity() != 0 || frameworkLogEntry.getBundleCode() != 0) {
            this.writeSpace();
            this.write(Integer.toString(frameworkLogEntry.getSeverity()));
            this.writeSpace();
            this.write(Integer.toString(frameworkLogEntry.getBundleCode()));
        }
        this.writeSpace();
        this.write(this.getDate(new Date()));
        this.writeln();
    }

    protected void writeMessage(FrameworkLogEntry frameworkLogEntry) throws IOException {
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(frameworkLogEntry.getMessage());
    }

    protected void writeStack(FrameworkLogEntry frameworkLogEntry) throws IOException {
        Throwable throwable = frameworkLogEntry.getThrowable();
        if (throwable != null) {
            String string = this.getStackTrace(throwable);
            this.write(STACK);
            this.writeSpace();
            this.write(Integer.toString(frameworkLogEntry.getStackCode()));
            this.writeln();
            this.write(string);
        }
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            this.writer.write(string);
            if (this.consoleLog) {
                System.out.print(string);
            }
        }
    }

    protected void writeln(String string) throws IOException {
        this.write(string);
        this.writeln();
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }

    protected boolean checkLogFileSize() {
        if (this.maxLogSize == 0) {
            return true;
        }
        boolean bl = true;
        if (this.outFile != null && this.outFile.length() >> 10 > (long)this.maxLogSize) {
            boolean bl2;
            String string = this.outFile.getAbsolutePath();
            String string2 = "";
            string2 = string.toLowerCase().endsWith(LOG_EXT) ? String.valueOf(string.substring(0, string.length() - LOG_EXT.length())) + BACKUP_MARK + this.backupIdx + LOG_EXT : String.valueOf(string) + BACKUP_MARK + this.backupIdx;
            File file = new File(string2);
            if (file.exists() && !file.delete()) {
                System.err.println("Error when trying to delete old log file: " + file.getName());
                if (file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + file.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    bl = false;
                }
            }
            if (!(bl2 = this.outFile.renameTo(file))) {
                System.err.println("Error when trying to rename log file to backup one.");
                bl = false;
            }
            File file2 = new File(string);
            this.setOutput(file2, null, false);
            this.openFile();
            try {
                this.writeSession();
                this.writeln();
                this.writeln("This is a continuation of log file " + file.getAbsolutePath());
                this.writeln("Created Time: " + this.getDate(new Date(System.currentTimeMillis())));
                this.writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            this.closeFile();
            ++this.backupIdx;
            this.backupIdx %= this.maxLogFiles;
        }
        return bl;
    }

    protected void readLogProperties() {
        String string;
        String string2 = secureAction.getProperty(PROP_LOG_SIZE_MAX);
        if (string2 != null) {
            this.maxLogSize = Integer.parseInt(string2);
            if (this.maxLogSize != 0 && this.maxLogSize < 10) {
                this.maxLogSize = 10;
            }
        }
        if ((string = secureAction.getProperty(PROP_LOG_FILE_MAX)) != null) {
            this.maxLogFiles = Integer.parseInt(string);
            if (this.maxLogFiles < 1) {
                this.maxLogFiles = 10;
            }
        }
    }
}

