/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;

public class DefaultClassLoader
extends ClassLoader
implements BaseClassLoader {
    protected static final PermissionCollection ALLPERMISSIONS;
    protected ClassLoaderDelegate delegate;
    protected ProtectionDomain domain;
    protected ClasspathManager manager;

    static {
        AllPermission allPermission = new AllPermission();
        ALLPERMISSIONS = allPermission.newPermissionCollection();
        if (ALLPERMISSIONS != null) {
            ALLPERMISSIONS.add(allPermission);
        }
    }

    public DefaultClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, ProtectionDomain protectionDomain, BaseData baseData, String[] stringArray) {
        super(classLoader);
        this.delegate = classLoaderDelegate;
        this.domain = protectionDomain;
        this.manager = new ClasspathManager(baseData, stringArray, this);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + string + ")");
        }
        try {
            Class clazz = this.delegate.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Error error) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + string + ") failed.");
                Debug.printStackTrace(error);
            }
            throw error;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("BundleClassLoader[" + this.delegate + "].loadClass(" + string + ") failed.");
                Debug.printStackTrace(classNotFoundException);
            }
            throw classNotFoundException;
        }
    }

    public URL getResource(String string) {
        URL uRL;
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + string + ")");
        }
        if ((uRL = this.delegate.findResource(string)) != null) {
            return uRL;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.delegate + "].getResource(" + string + ") failed.");
        }
        return null;
    }

    protected Enumeration findResources(String string) throws IOException {
        return this.delegate.findResources(string);
    }

    protected String findLibrary(String string) {
        return this.manager.findLibrary(string);
    }

    public ProtectionDomain getDomain() {
        return this.domain;
    }

    public ClasspathEntry createClassPathEntry(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        return new ClasspathEntry(bundleFile, DefaultClassLoader.createProtectionDomain(bundleFile, protectionDomain));
    }

    public Class defineClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry) {
        return this.defineClass(string, byArray, 0, byArray.length, classpathEntry.getDomain());
    }

    public Class publicFindLoaded(String string) {
        return this.findLoadedClass(string);
    }

    public Object publicGetPackage(String string) {
        return this.getPackage(string);
    }

    public Object publicDefinePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        return this.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
    }

    public void initialize() {
        this.manager.initialize();
    }

    public URL findLocalResource(String string) {
        return this.manager.findLocalResource(string);
    }

    public Enumeration findLocalResources(String string) {
        return this.manager.findLocalResources(string);
    }

    public Class findLocalClass(String string) throws ClassNotFoundException {
        return this.manager.findLocalClass(string);
    }

    public void close() {
        this.manager.close();
    }

    public void attachFragment(BundleData bundleData, ProtectionDomain protectionDomain, String[] stringArray) {
        this.manager.attachFragment(bundleData, protectionDomain, stringArray);
    }

    public ClassLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public static ProtectionDomain createProtectionDomain(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        try {
            PermissionCollection permissionCollection = protectionDomain != null ? protectionDomain.getPermissions() : ALLPERMISSIONS;
            Certificate[] certificateArray = null;
            if (bundleFile instanceof CertificateVerifier) {
                CertificateChain[] certificateChainArray = ((CertificateVerifier)((Object)bundleFile)).getChains();
                certificateArray = certificateChainArray == null || certificateChainArray.length == 0 ? null : certificateChainArray[0].getCertificates();
            }
            return new ProtectionDomain(new CodeSource(bundleFile.getBaseFile().toURL(), certificateArray), permissionCollection);
        }
        catch (MalformedURLException malformedURLException) {
            return protectionDomain;
        }
    }

    public ClasspathManager getClasspathManager() {
        return this.manager;
    }
}

