/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class BundleConstraint
extends ResolverConstraint {
    private ArrayList matchingBundles;

    BundleConstraint(ResolverBundle resolverBundle, VersionConstraint versionConstraint) {
        super(resolverBundle, versionConstraint);
    }

    boolean isOptional() {
        if (this.constraint instanceof HostSpecification) {
            return false;
        }
        return ((BundleSpecification)this.constraint).isOptional();
    }

    ResolverBundle getMatchingBundle() {
        return this.matchingBundles != null && this.matchingBundles.size() > 0 ? this.matchingBundles.get(0) : null;
    }

    ResolverBundle[] getMatchingBundles() {
        if (this.matchingBundles == null || this.matchingBundles.size() == 0) {
            return null;
        }
        return this.matchingBundles.toArray(new ResolverBundle[this.matchingBundles.size()]);
    }

    void addMatchingBundle(ResolverBundle resolverBundle) {
        if (this.matchingBundles == null) {
            this.matchingBundles = new ArrayList(1);
        }
        if (!this.matchingBundles.contains(resolverBundle)) {
            this.matchingBundles.add(resolverBundle);
        }
    }

    void removeMatchingBundle(ResolverBundle resolverBundle) {
        if (this.matchingBundles == null) {
            return;
        }
        this.matchingBundles.remove(resolverBundle);
    }

    void removeAllMatchingBundles() {
        this.matchingBundles = null;
    }

    void setMatchingBundle(ResolverBundle resolverBundle) {
        this.removeAllMatchingBundles();
        if (resolverBundle != null) {
            this.addMatchingBundle(resolverBundle);
        }
    }

    boolean foundMatchingBundles() {
        return this.matchingBundles == null ? false : this.matchingBundles.size() > 0;
    }
}

