/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public Version(int n, int n2, int n3, String string) {
        if (string == null) {
            string = "";
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string;
        this.validate();
    }

    public Version(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR, true);
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("invalid format");
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string2;
        this.validate();
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro");
        }
        int n = this.qualifier.length();
        int n2 = 0;
        while (n2 < n) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".indexOf(this.qualifier.charAt(n2)) == -1) {
                throw new IllegalArgumentException("invalid qualifier");
            }
            ++n2;
        }
    }

    public static Version parseVersion(String string) {
        if (string == null) {
            return emptyVersion;
        }
        if ((string = string.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(string);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        String string = String.valueOf(this.major) + SEPARATOR + this.minor + SEPARATOR + this.micro;
        if (this.qualifier.length() == 0) {
            return string;
        }
        return String.valueOf(string) + SEPARATOR + this.qualifier;
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.qualifier.equals(version.qualifier);
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Version version = (Version)object;
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.micro - version.micro;
        if (n != 0) {
            return n;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

