/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class ConstrainedText
extends Control {
    private static final int LIMIT = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetDefaultTextLimit();
    private int orientation = 0x2000000;
    boolean editable;
    private int textLimit = LIMIT;
    private static Object fLock = new Object();
    private static boolean isInit = false;
    private int ConstrainedStyle_global = 0;
    public static final int NUMERIC = 1;
    public static final int DECIMAL = 2;
    public static final int PHONENUMBER = 4;

    public ConstrainedText(Composite parent, int style, int constrainedStyle) {
        super(parent, ConstrainedText.checkStyle(style));
        this.init();
        this.CheckConstrainedStyle(constrainedStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = fLock;
        synchronized (object) {
            if (!isInit) {
                com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 31, "org/eclipse/ercp/swt/mobile/ConstrainedText", "ConstrainedTextCallback");
                isInit = true;
            }
        }
    }

    private boolean check_numeric(char keyin_char, int position) {
        switch (position) {
            case 0: {
                if (keyin_char != '-' && !this.check_NumericString(keyin_char)) break;
                return true;
            }
            default: {
                if (!this.check_NumericString(keyin_char)) break;
                return true;
            }
        }
        return false;
    }

    private boolean check_decimal(char keyin_char, int position, String content) {
        boolean dot_number = false;
        int unselectedtext_number = 0;
        char[] chars = null;
        chars = new char[content.length()];
        content.getChars(0, chars.length, chars, 0);
        switch (position) {
            case 0: {
                unselectedtext_number = content.length() - this.getSelectionText().length();
                if (!(unselectedtext_number >= 1 ? keyin_char == '-' || keyin_char == '.' || this.check_NumericString(keyin_char) : keyin_char == '-' || this.check_DecimalString(keyin_char, chars))) break;
                return true;
            }
            case 1: {
                if (chars[0] == '0') {
                    if (keyin_char != '.') break;
                    return true;
                }
                return this.check_DecimalString(keyin_char, chars);
            }
            case 2: {
                if (chars[0] == '-') {
                    if (chars[1] == '0') {
                        if (keyin_char != '.') break;
                        return true;
                    }
                    return this.check_DecimalString(keyin_char, chars);
                }
                return this.check_DecimalString(keyin_char, chars);
            }
            default: {
                return this.check_DecimalString(keyin_char, chars);
            }
        }
        return false;
    }

    private boolean check_phonenumber(char keyin_char) {
        if (keyin_char == ' ' || keyin_char == '*' || keyin_char == '#' || keyin_char == '+' || this.check_NumericString(keyin_char)) {
            return true;
        }
        if (keyin_char == 'A' || keyin_char == 'B' || keyin_char == 'C' || keyin_char == 'D') {
            return true;
        }
        if (keyin_char == ',' || keyin_char == 'T' || keyin_char == 'P' || keyin_char == '!' || keyin_char == 'W' || keyin_char == '@') {
            return true;
        }
        return keyin_char == ';' || keyin_char == '>' || keyin_char == 'I' || keyin_char == 'i' || keyin_char == 'G' || keyin_char == 'g';
    }

    private boolean check_keydown(int keycode) {
        if (keycode == 8 || keycode == 0x1000004 || keycode == 0x1000003) {
            return true;
        }
        if (keycode == 13) {
            this.internal_sendEvent(14);
        }
        return false;
    }

    private boolean check_NumericString(char keyin_char) {
        return '0' <= keyin_char && keyin_char <= '9';
    }

    private boolean check_DecimalString(char keyin_char, char[] chars) {
        int dot_number = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            ++dot_number;
        }
        return dot_number < 1 ? keyin_char == '.' || this.check_NumericString(keyin_char) : (dot_number - this.check_selected_dotnumber(this.getSelectionText()) < 1 ? keyin_char == '.' || this.check_NumericString(keyin_char) : this.check_NumericString(keyin_char));
    }

    private int check_selected_dotnumber(String selected_content) {
        int Selected_dot_number = 0;
        if (selected_content == null) {
            return 0;
        }
        char[] chars = null;
        chars = new char[selected_content.length()];
        selected_content.getChars(0, chars.length, chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            ++Selected_dot_number;
        }
        return Selected_dot_number;
    }

    private void CheckConstrainedStyle(int constrainedStyle) {
        if ((constrainedStyle & 0xFFFFFFF8) != 0) {
            SWT.error(5);
        }
        if ((constrainedStyle & 1) == 1 && (constrainedStyle | 1) != 1) {
            SWT.error(5);
        }
        if ((constrainedStyle & 2) == 2 && (constrainedStyle | 2) != 2) {
            SWT.error(5);
        }
        if ((constrainedStyle & 4) == 4 && (constrainedStyle | 4) != 4) {
            SWT.error(5);
        }
        if ((constrainedStyle & 1) != 0) {
            this.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    char keyin_char = event.character;
                    if (!ConstrainedText.this.check_numeric(keyin_char, ConstrainedText.this.getCaretPosition()) && !ConstrainedText.this.check_keydown(event.keyCode)) {
                        event.doit = false;
                        return;
                    }
                }
            });
        } else if ((constrainedStyle & 2) != 0) {
            this.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    char keyin_char = event.character;
                    String content = ConstrainedText.this.getText();
                    if (!ConstrainedText.this.check_decimal(keyin_char, ConstrainedText.this.getCaretPosition(), content) && !ConstrainedText.this.check_keydown(event.keyCode)) {
                        event.doit = false;
                        return;
                    }
                }
            });
        } else if ((constrainedStyle & 4) != 0) {
            this.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    char keyin_char = event.character;
                    if (!ConstrainedText.this.check_phonenumber(keyin_char) && !ConstrainedText.this.check_keydown(event.keyCode)) {
                        event.doit = false;
                        return;
                    }
                }
            });
        }
        this.ConstrainedStyle_global = constrainedStyle;
    }

    private boolean checkType(String string) {
        int count;
        boolean match = false;
        if (this.ConstrainedStyle_global == 1) {
            for (count = 0; count < string.length(); ++count) {
                match = this.check_numeric(string.charAt(count), count);
                if (match) continue;
                SWT.error(5);
                break;
            }
            return match;
        }
        if (this.ConstrainedStyle_global == 2) {
            while (count < string.length()) {
                match = this.check_decimal(string.charAt(count), count, string.substring(0, count));
                if (!match) {
                    SWT.error(5);
                    break;
                }
                ++count;
            }
            return match;
        }
        if (this.ConstrainedStyle_global == 4) {
            while (count < string.length()) {
                match = this.check_phonenumber(string.charAt(count));
                if (!match) {
                    SWT.error(5);
                    break;
                }
                ++count;
            }
            return match;
        }
        return false;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(14, typedListener);
    }

    public void append(String string) {
        String str;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (this.checkType(str = string)) {
            int length = this.getCharCount();
            if (this.isListening(25) && (str = this.VerifyText(string, length, length, null)) == null) {
                return;
            }
            if (string.length() > this.textLimit - this.getCharCount()) {
                str = string.substring(0, this.textLimit - this.getCharCount());
            }
            OS.ConstrainedText_Replace(this.internal_handle, str, length, length);
            int newLength = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetText(this.internal_handle).length();
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, newLength);
            this.internal_sendEvent(24);
        }
    }

    static int checkStyle(int style) {
        if (((style = ConstrainedText.checkBITs(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 0x400342) != 0) {
            style &= 0xFFBFFCBD;
        }
        return style | 4;
    }

    static int checkBITs(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    protected void internal_createHandle(int index) {
        int parentHandle = this.internal_parent.internal_handle;
        int nativeStyle = this.internal_getNativeStyle();
        System.err.flush();
        this.internal_handle = OS.ConstrainedText_New(parentHandle, nativeStyle);
        System.out.flush();
        if (this.internal_handle == 0) {
            SWT.error(2);
        }
        this.setEditable((this.internal_style & 8) == 0);
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        return nativeStyle;
    }

    boolean TextVerifyCallback(String originalText, int start, int end, String[] returnedText) {
        String modifiedText = this.VerifyText(originalText, start, end, null);
        if (modifiedText == null) {
            return true;
        }
        if (returnedText == null || returnedText.length == 0) {
            SWT.error(5);
        }
        returnedText[0] = modifiedText == originalText ? null : modifiedText;
        return false;
    }

    String VerifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.internal_sendEvent(25);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1) {
            this.checkWidget();
            int[] pointArray = OS.ConstrainedText_GetMinimumSize(this.internal_handle, wHint);
            return new Point(pointArray[0], pointArray[1]);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    private void ConstrainedTextCallback(int index, int type) {
        switch (type) {
            case 4: {
                if (Device.internal_vkstatus == 2) {
                    OS.MobileDevice_SetVKStatus(true, this.internal_handle);
                    break;
                }
                if (Device.internal_vkstatus == 3) {
                    OS.MobileDevice_SetVKStatus(false, this.internal_handle);
                    break;
                }
                if (!this.editable) {
                    OS.MobileDevice_SetVKStatus(false, this.internal_handle);
                    break;
                }
                OS.MobileDevice_SetVKStatus(true, this.internal_handle);
                break;
            }
            case 5: {
                if (Device.internal_vkstatus == 2) {
                    OS.MobileDevice_SetVKStatus(true, this.internal_handle);
                    break;
                }
                if (Device.internal_vkstatus == 3) {
                    OS.MobileDevice_SetVKStatus(false, this.internal_handle);
                    break;
                }
                if (!this.editable) {
                    OS.MobileDevice_SetVKStatus(false, this.internal_handle);
                    break;
                }
                OS.MobileDevice_SetVKStatus(false, this.internal_handle);
                break;
            }
            case 3: {
                this.internal_sendEvent(24);
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        Point sel = this.getSelection();
        OS.ConstrainedText_Replace(this.internal_handle, "", sel.x, sel.y);
    }

    private Point getSelection() {
        this.checkWidget();
        int[] selection = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetSelection(this.internal_handle);
        return new Point(selection[0], selection[1]);
    }

    public void copy() {
        this.checkWidget();
        String text = this.getSelectionText();
        if (text != null) {
            com.ibm.ugl.eswt.OS.Clipboard_SetText(text);
        }
    }

    private String getSelectionText() {
        this.checkWidget();
        return com.ibm.ugl.eswt.OS.AbstractTextComponent_GetSelectionText(this.internal_handle);
    }

    public void cut() {
        this.checkWidget();
        String text = this.getSelectionText();
        com.ibm.ugl.eswt.OS.Clipboard_SetText(text);
        int[] sel = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetSelection(this.internal_handle);
        OS.ConstrainedText_Replace(this.internal_handle, "", sel[0], sel[1]);
        OS.ConstrainedText_SetSelection(this.internal_handle, sel[0], sel[0]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] selection = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetSelection(this.internal_handle);
        return selection[0];
    }

    public int getCharCount() {
        this.checkWidget();
        return com.ibm.ugl.eswt.OS.AbstractTextComponent_GetCharCount(this.internal_handle);
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public String getText() {
        this.checkWidget();
        return com.ibm.ugl.eswt.OS.AbstractTextComponent_GetText(this.internal_handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public void insert(String string) {
        String str;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (this.checkType(str = string)) {
            int[] selection = com.ibm.ugl.eswt.OS.AbstractTextComponent_GetSelection(this.internal_handle);
            if (this.isListening(25) && (str = this.VerifyText(string, selection[0], selection[1], null)) == null) {
                return;
            }
            if (string.length() > this.textLimit - this.getCharCount()) {
                str = string.substring(0, this.textLimit - this.getCharCount());
            }
            OS.ConstrainedText_Replace(this.internal_handle, str, selection[0], selection[1]);
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, selection[0] + str.length());
            this.internal_sendEvent(24);
        }
    }

    public void paste() {
        String text;
        this.checkWidget();
        String str = text = com.ibm.ugl.eswt.OS.Clipboard_GetText();
        if (this.checkType(str)) {
            this.clearSelection();
            this.insert(text);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void selectAll() {
        this.checkWidget();
        com.ibm.ugl.eswt.OS.AbstractTextComponent_SelectAll(this.internal_handle);
    }

    public void setEditable(boolean Editable) {
        this.checkWidget();
        this.editable = Editable;
        com.ibm.ugl.eswt.OS.AbstractTextComponent_SetEditable(this.internal_handle, this.editable);
    }

    public void setSelection(int start) {
        this.checkWidget();
        int text_number = this.getCharCount();
        if (0 > start) {
            SWT.error(5);
        }
        if (start > text_number) {
            SWT.error(6);
        }
        com.ibm.ugl.eswt.OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int text_number = this.getCharCount();
        if (0 > start || 0 > end) {
            SWT.error(5);
        }
        if (end > text_number) {
            SWT.error(6);
        }
        if (start > end) {
            SWT.error(6);
        }
        int nStart = Math.min(start, end);
        int nEnd = Math.min(Math.max(start, end), text_number);
        OS.ConstrainedText_SetSelection(this.internal_handle, nStart, nEnd);
    }

    public void setText(String text) {
        String str;
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((str = text) == "") {
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetText(this.internal_handle, str);
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, 0);
            this.internal_sendEvent(24);
        } else if (this.checkType(str)) {
            int length;
            if (this.isListening(25) && (str = this.VerifyText(text, 0, length = this.getCharCount(), null)) == null) {
                return;
            }
            if (text.length() > this.textLimit) {
                str = text.substring(0, this.textLimit);
            }
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetText(this.internal_handle, str);
            com.ibm.ugl.eswt.OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, 0);
            this.internal_sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit <= 0 || limit > LIMIT) {
            SWT.error(5);
        }
        this.textLimit = limit;
        com.ibm.ugl.eswt.OS.AbstractTextComponent_SetTextLimit(this.internal_handle, limit);
    }

    public void showSelection() {
        this.checkWidget();
        Point sel = this.getSelection();
        this.setSelection(sel.x, sel.y);
    }
}

