/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.internal.search.QueryUpdateSiteAdapter;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class UpdatesSearchCategory
extends BaseSearchCategory {
    private static final String CATEGORY_ID = "org.eclipse.update.core.new-updates";
    private IFeature[] features;
    private ArrayList candidates;

    public UpdatesSearchCategory() {
        super(CATEGORY_ID);
    }

    private void collectValidHits(ArrayList arrayList, IUpdateSearchFilter iUpdateSearchFilter, IUpdateSearchResultCollector iUpdateSearchResultCollector) {
        IFeature iFeature = null;
        int n = 0;
        while (n < arrayList.size()) {
            Hit hit = (Hit)arrayList.get(n);
            IInstallFeatureOperation iInstallFeatureOperation = hit.getJob();
            if (iInstallFeatureOperation != null) {
                if (!UpdateUtils.hasLicense(iInstallFeatureOperation.getFeature())) {
                    UpdateCore.log(iInstallFeatureOperation.getFeature().getVersionedIdentifier() + ": " + Messages.DefaultFeatureParser_NoLicenseText, null);
                } else {
                    IStatus iStatus = hit.getPatchedJob() == null ? OperationsManager.getValidator().validatePendingInstall(iInstallFeatureOperation.getOldFeature(), iInstallFeatureOperation.getFeature()) : OperationsManager.getValidator().validatePendingChanges(new IInstallFeatureOperation[]{hit.getPatchedJob(), iInstallFeatureOperation});
                    if (iStatus == null || iStatus.getCode() == 2) {
                        if (hit.isPatch()) {
                            IFeature iFeature2 = iInstallFeatureOperation.getFeature();
                            IFeature[] iFeatureArray = UpdateUtils.getInstalledFeatures(iFeature2, false);
                            if (iFeatureArray.length == 0 && iUpdateSearchFilter.accept(iFeature2)) {
                                iUpdateSearchResultCollector.accept(iFeature2);
                            }
                        } else {
                            iFeature = iInstallFeatureOperation.getFeature();
                            if (iUpdateSearchFilter.accept(iFeature)) {
                                iUpdateSearchResultCollector.accept(iFeature);
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    private void initialize() {
        this.candidates = new ArrayList();
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
            IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
            int n = 0;
            while (n < iConfiguredSiteArray.length) {
                this.contributeCandidates(iConfiguredSiteArray[n]);
                ++n;
            }
        }
        catch (CoreException coreException) {
            UpdateCore.log(Messages.UpdatesSearchCategory_errorSearchingForUpdates, coreException);
        }
    }

    private void contributeCandidates(IConfiguredSite iConfiguredSite) throws CoreException {
        IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
        ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            block4: {
                IFeatureReference iFeatureReference = iFeatureReferenceArray[n];
                try {
                    if (UpdateUtils.isPatch(iFeatureReference.getFeature(null))) {
                    }
                }
                catch (CoreException coreException) {}
                break block4;
                Candidate candidate = new Candidate(iFeatureReference);
                arrayList.add(candidate);
            }
            ++n;
        }
        this.buildHierarchy(arrayList);
        this.candidates.addAll(arrayList);
    }

    private void buildHierarchy(ArrayList arrayList) throws CoreException {
        Candidate[] candidateArray = arrayList.toArray(new Candidate[arrayList.size()]);
        int n = 0;
        while (n < candidateArray.length) {
            Candidate candidate = candidateArray[n];
            IFeature iFeature = candidate.getFeature(null);
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
            int n2 = 0;
            while (n2 < iIncludedFeatureReferenceArray.length) {
                IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n2];
                Candidate candidate2 = this.findCandidate(arrayList, iIncludedFeatureReference);
                if (candidate2 != null) {
                    candidate.add(candidate2);
                    candidate2.setReference(iIncludedFeatureReference);
                    arrayList.remove(candidate2);
                }
                ++n2;
            }
            ++n;
        }
    }

    private Candidate findCandidate(ArrayList arrayList, IFeatureReference iFeatureReference) {
        int n = 0;
        while (n < arrayList.size()) {
            Candidate candidate = (Candidate)arrayList.get(n);
            if (candidate.ref.equals(iFeatureReference)) {
                return candidate;
            }
            ++n;
        }
        return null;
    }

    public IUpdateSearchQuery[] getQueries() {
        this.initialize();
        ArrayList arrayList = this.getAllCandidates();
        IUpdateSearchQuery[] iUpdateSearchQueryArray = new IUpdateSearchQuery[arrayList.size()];
        int n = 0;
        while (n < iUpdateSearchQueryArray.length) {
            Candidate candidate = (Candidate)arrayList.get(n);
            IFeature iFeature = candidate.getFeature(null);
            IURLEntry iURLEntry = candidate.getUpdateEntry();
            iUpdateSearchQueryArray[n] = iFeature == null ? null : new UpdateQuery(iFeature, iURLEntry);
            ++n;
        }
        return iUpdateSearchQueryArray;
    }

    public void setFeatures(IFeature[] iFeatureArray) {
        this.features = iFeatureArray;
    }

    public IFeature[] getFeatures() {
        return this.features;
    }

    private boolean isNewerVersion(VersionedIdentifier versionedIdentifier, VersionedIdentifier versionedIdentifier2) {
        if (!versionedIdentifier.getIdentifier().equals(versionedIdentifier2.getIdentifier())) {
            return false;
        }
        PluginVersionIdentifier pluginVersionIdentifier = versionedIdentifier.getVersion();
        PluginVersionIdentifier pluginVersionIdentifier2 = versionedIdentifier2.getVersion();
        String string = this.getUpdateVersionsMode();
        boolean bl = pluginVersionIdentifier2.isGreaterThan(pluginVersionIdentifier);
        if (!bl) {
            return false;
        }
        if (string.equals("greaterOrEqual")) {
            return true;
        }
        if (string.equals("equivalent")) {
            return pluginVersionIdentifier2.isEquivalentTo(pluginVersionIdentifier);
        }
        if (string.equals("compatible")) {
            return pluginVersionIdentifier2.isCompatibleWith(pluginVersionIdentifier);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean isPatch(IFeature var1_1, ISiteFeatureReference var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getUpdateVersionsMode() {
        Preferences preferences = UpdateCore.getPlugin().getPluginPreferences();
        return preferences.getString("org.eclipse.update.core.updateVersions");
    }

    private ArrayList getAllCandidates() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.candidates.size()) {
            Candidate candidate = (Candidate)this.candidates.get(n);
            if (this.isOnTheList(candidate)) {
                candidate.addToFlatList(arrayList, true);
            }
            ++n;
        }
        return arrayList;
    }

    private boolean isOnTheList(Candidate candidate) {
        VersionedIdentifier versionedIdentifier;
        if (this.features == null) {
            return true;
        }
        try {
            versionedIdentifier = candidate.getReference().getVersionedIdentifier();
        }
        catch (CoreException coreException) {
            return false;
        }
        int n = 0;
        while (n < this.features.length) {
            IFeature iFeature = this.features[n];
            VersionedIdentifier versionedIdentifier2 = iFeature.getVersionedIdentifier();
            if (versionedIdentifier2.equals(versionedIdentifier)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    class Candidate {
        ArrayList children;
        Candidate parent;
        IFeatureReference ref;

        public Candidate(IFeatureReference iFeatureReference) {
            this.ref = iFeatureReference;
        }

        public Candidate(IFeatureReference iFeatureReference, Candidate candidate) {
            this(iFeatureReference);
            this.parent = candidate;
        }

        public void add(Candidate candidate) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            candidate.setParent(this);
            this.children.add(candidate);
        }

        void setParent(Candidate candidate) {
            this.parent = candidate;
        }

        public IFeatureReference getReference() {
            return this.ref;
        }

        void setReference(IFeatureReference iFeatureReference) {
            this.ref = iFeatureReference;
        }

        public IFeature getFeature(IProgressMonitor iProgressMonitor) {
            try {
                return this.ref.getFeature(iProgressMonitor);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public Candidate getParent() {
            return this.parent;
        }

        public Candidate getRoot() {
            Candidate candidate = this;
            while (candidate.getParent() != null) {
                candidate = candidate.getParent();
            }
            return candidate;
        }

        public IURLEntry getUpdateEntry() {
            int n = 2;
            if (this.ref instanceof IIncludedFeatureReference) {
                n = ((IIncludedFeatureReference)this.ref).getSearchLocation();
            }
            if (this.parent == null || n == 4) {
                return this.getFeature(null).getUpdateSiteEntry();
            }
            return this.getRoot().getUpdateEntry();
        }

        public String toString() {
            return this.ref.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof Candidate) {
                return this.ref.equals(((Candidate)object).getReference());
            }
            if (object instanceof IFeatureReference) {
                return this.ref.equals(object);
            }
            return false;
        }

        public void addToFlatList(ArrayList arrayList, boolean bl) {
            if (!bl || this.isUpdatable()) {
                arrayList.add(this);
            }
            if (this.children != null) {
                int n = 0;
                while (n < this.children.size()) {
                    Candidate candidate = (Candidate)this.children.get(n);
                    candidate.addToFlatList(arrayList, bl);
                    ++n;
                }
            }
        }

        public boolean isUpdatable() {
            return this.parent == null;
        }
    }

    private static class Hit {
        IFeature candidate;
        IFeatureReference ref;
        IInstallFeatureOperation patchFor;
        boolean patch;
        IInstallFeatureOperation job;

        public Hit(IFeature iFeature, IFeatureReference iFeatureReference) {
            this.candidate = iFeature;
            this.ref = iFeatureReference;
        }

        public Hit(IFeature iFeature, IFeatureReference iFeatureReference, boolean bl) {
            this(iFeature, iFeatureReference);
            this.patch = bl;
        }

        public Hit(IFeature iFeature, IFeatureReference iFeatureReference, IInstallFeatureOperation iInstallFeatureOperation) {
            this(iFeature, iFeatureReference, true);
            this.patchFor = iInstallFeatureOperation;
        }

        public IInstallFeatureOperation getJob() {
            if (this.job == null) {
                try {
                    IFeature iFeature = this.ref.getFeature(null);
                    this.job = OperationsManager.getOperationFactory().createInstallOperation(null, iFeature, null, null, null);
                }
                catch (CoreException coreException) {
                    UpdateCore.log(coreException);
                }
            }
            return this.job;
        }

        public boolean isPatch() {
            return this.patch;
        }

        public IInstallFeatureOperation getPatchedJob() {
            return this.patchFor;
        }
    }

    class UpdateQuery
    implements IUpdateSearchQuery {
        IFeature candidate;
        IQueryUpdateSiteAdapter adapter;

        public UpdateQuery(IFeature iFeature, IURLEntry iURLEntry) {
            this.candidate = iFeature;
            if (iURLEntry != null && iURLEntry.getURL() != null) {
                this.adapter = new QueryUpdateSiteAdapter(this.getLabelForEntry(iURLEntry), iURLEntry.getURL(), iFeature.getVersionedIdentifier().getIdentifier());
            }
        }

        private String getLabelForEntry(IURLEntry iURLEntry) {
            String string = iURLEntry.getAnnotation();
            if (string == null || string.length() == 0) {
                string = iURLEntry.getURL().toString();
            }
            return string;
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return this.adapter;
        }

        private boolean isBroken() {
            try {
                IStatus iStatus = SiteManager.getLocalSite().getFeatureStatus(this.candidate);
                return iStatus.getSeverity() == 4;
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isMissingOptionalChildren(IFeature iFeature) {
            try {
                IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
                int n = 0;
                while (true) {
                    block7: {
                        if (n >= iIncludedFeatureReferenceArray.length) {
                            return false;
                        }
                        IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
                        try {
                            IFeature iFeature2 = iIncludedFeatureReference.getFeature(null);
                            if (this.isMissingOptionalChildren(iFeature2)) {
                                return true;
                            }
                        }
                        catch (CoreException coreException) {
                            if (!iIncludedFeatureReference.isOptional()) break block7;
                            return FeatureHierarchyElement.hasOlderVersion(iIncludedFeatureReference);
                        }
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }

        public void run(ISite iSite, String[] stringArray, IUpdateSearchFilter iUpdateSearchFilter, IUpdateSearchResultCollector iUpdateSearchResultCollector, IProgressMonitor iProgressMonitor) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = this.isBroken();
            boolean bl2 = false;
            if (!bl) {
                bl2 = this.isMissingOptionalChildren(this.candidate);
            }
            ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
            iProgressMonitor.beginTask("", iSiteFeatureReferenceArray.length + 1);
            ArrayList<IInstallFeatureOperation> arrayList2 = new ArrayList<IInstallFeatureOperation>();
            int n = 0;
            while (n < iSiteFeatureReferenceArray.length) {
                block15: {
                    block14: {
                        object2 = iSiteFeatureReferenceArray[n];
                        try {
                            if (UpdatesSearchCategory.this.isNewerVersion(this.candidate.getVersionedIdentifier(), object2.getVersionedIdentifier())) {
                                object = new Hit(this.candidate, (IFeatureReference)object2);
                                arrayList.add(object);
                                IInstallFeatureOperation iInstallFeatureOperation = ((Hit)object).getJob();
                                if (iInstallFeatureOperation != null) {
                                    arrayList2.add(iInstallFeatureOperation);
                                }
                                break block14;
                            }
                            if ((bl || bl2) && this.candidate.getVersionedIdentifier().equals(object2.getVersionedIdentifier())) {
                                arrayList.add(new Hit(this.candidate, (IFeatureReference)object2));
                                break block15;
                            }
                            if (!UpdatesSearchCategory.this.isPatch(this.candidate, (ISiteFeatureReference)object2)) break block14;
                            arrayList.add(new Hit(this.candidate, (IFeatureReference)object2, true));
                            break block15;
                        }
                        catch (CoreException coreException) {}
                    }
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < arrayList2.size()) {
                object2 = (IInstallFeatureOperation)arrayList2.get(n);
                object = object2.getFeature();
                int n2 = 0;
                while (n2 < iSiteFeatureReferenceArray.length) {
                    ISiteFeatureReference iSiteFeatureReference = iSiteFeatureReferenceArray[n2];
                    if (UpdatesSearchCategory.this.isPatch((IFeature)object, iSiteFeatureReference)) {
                        Hit hit = new Hit((IFeature)object, (IFeatureReference)iSiteFeatureReference, (IInstallFeatureOperation)object2);
                        arrayList.add(hit);
                    } else if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                UpdatesSearchCategory.this.collectValidHits(arrayList, iUpdateSearchFilter, iUpdateSearchResultCollector);
            }
            iProgressMonitor.worked(1);
            iProgressMonitor.done();
        }
    }
}

