/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.runtime.ListenerList;

public class ListenerRegistry {
    static final Object[] EMPTY_LIST = new Object[0];
    ListenerMap registry = new ListenerMap(25);

    public synchronized Object[] getListeners(String string) {
        ListenerList listenerList = this.registry.get(string);
        return listenerList == null ? EMPTY_LIST : listenerList.getListeners();
    }

    public synchronized void add(String string, Object object) {
        ListenerList listenerList = this.registry.get(string);
        if (listenerList == null) {
            listenerList = new ListenerList(1);
        }
        listenerList.add(object);
        this.registry.put(string, listenerList);
    }

    public synchronized void remove(String string, Object object) {
        ListenerList listenerList = this.registry.get(string);
        if (listenerList == null) {
            return;
        }
        listenerList.remove(object);
        if (listenerList.isEmpty()) {
            this.registry.remove(string);
        }
    }

    public synchronized void clear(String string) {
        this.registry.remove(string);
    }

    private static class ListenerMap {
        private static final int GROW_SIZE = 10;
        String[] keys;
        ListenerList[] values;

        ListenerMap(int n) {
            this.keys = new String[n];
            this.values = new ListenerList[n];
        }

        ListenerList get(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            int n = 0;
            while (n < this.keys.length) {
                if (string.equals(this.keys[n])) {
                    return this.values[n];
                }
                ++n;
            }
            return null;
        }

        void put(String string, ListenerList listenerList) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (listenerList == null) {
                this.remove(string);
                return;
            }
            int n = -1;
            int n2 = 0;
            while (n2 < this.keys.length) {
                String string2 = this.keys[n2];
                if (string2 == null) {
                    n = n2;
                } else if (string2.equals(string)) {
                    this.values[n2] = listenerList;
                    return;
                }
                ++n2;
            }
            if (n == -1) {
                n = this.grow();
            }
            this.keys[n] = string;
            this.values[n] = listenerList;
        }

        private int grow() {
            int n = this.keys.length;
            String[] stringArray = new String[n + 10];
            System.arraycopy(this.keys, 0, stringArray, 0, n);
            this.keys = stringArray;
            ListenerList[] listenerListArray = new ListenerList[n + 10];
            System.arraycopy(this.values, 0, listenerListArray, 0, n);
            this.values = listenerListArray;
            return n;
        }

        void remove(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            int n = 0;
            while (n < this.keys.length) {
                if (string.equals(this.keys[n])) {
                    this.keys[n] = null;
                    this.values[n] = null;
                    return;
                }
                ++n;
            }
        }
    }
}

