/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.jaxp.implForCore;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    private Node currentNode = null;
    private Document document = null;
    private Locator locator = null;
    private ErrorHandler errorHandler = null;
    private boolean fNamespaces = false;
    private boolean cdataStarted = false;

    public Document getDocument() {
        return this.document;
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    public void setNamespacePrefixes(boolean bl) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.document = new DocumentImpl();
        this.currentNode = this.document;
    }

    public void endDocument() throws SAXException {
        if (this.currentNode == this.document) {
            this.currentNode = null;
        } else {
            this.warning(EXmlMsg.getDefault().getString(56));
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = this.fNamespaces ? this.document.createElementNS(string, string3) : this.document.createElement(string3);
        this.currentNode.appendChild(element);
        this.currentNode = element;
        int n = attributes.getLength();
        if (this.fNamespaces) {
            int n2 = 0;
            while (n2 < n) {
                element.setAttributeNS(attributes.getURI(n2), attributes.getQName(n2), attributes.getValue(n2));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                element.setAttribute(attributes.getQName(n3), attributes.getValue(n3));
                ++n3;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.fNamespaces) {
            this.endElementNS(string, string2);
        } else {
            this.endElement(string3);
        }
    }

    protected void endElement(String string) throws SAXException {
        if (this.currentNode.getNodeName().equals(string)) {
            this.currentNode = this.currentNode.getParentNode();
        } else {
            Node node = this.retreiveSuperNode(string, this.currentNode);
            if (node == this.document) {
                this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
                this.currentNode = this.document;
            } else if (node == null) {
                this.warning(EXmlMsg.getDefault().getString(55, string));
                this.currentNode = this.document;
            } else {
                this.currentNode = node.getParentNode();
            }
        }
    }

    protected Node retreiveSuperNode(String string, Node node) throws SAXException {
        while (node != null && node != this.document) {
            if (node.getNodeName().equals(string)) {
                return node;
            }
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            node = node.getParentNode();
        }
        return null;
    }

    protected void endElementNS(String string, String string2) throws SAXException {
        if (this.currentNode.getNamespaceURI().equals(string) && this.currentNode.getLocalName().equals(string2)) {
            this.currentNode = this.currentNode.getParentNode();
        } else {
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            Node node = this.retreiveSuperNodeNS(string, string2, this.currentNode.getParentNode());
            if (node != null) {
                this.currentNode = node.getParentNode();
            }
        }
    }

    protected Node retreiveSuperNodeNS(String string, String string2, Node node) throws SAXException {
        while (node != null) {
            if (node.getNamespaceURI().equals(string) && node.getLocalName().equals(string2)) {
                return node;
            }
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            node = node.getParentNode();
        }
        return null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentNode != this.document) {
            Text text = !this.cdataStarted ? this.document.createTextNode(new String(cArray, n, n2)) : this.document.createCDATASection(new String(cArray, n, n2));
            this.currentNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.currentNode != this.document) {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            this.currentNode.appendChild(processingInstruction);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void warning(String string) throws SAXException {
        if (this.errorHandler == null) {
            throw new SAXParseException(string, this.locator);
        }
        this.errorHandler.warning(new SAXParseException(string, this.locator));
    }

    protected void fatalError(String string) throws SAXException {
        if (this.errorHandler == null) {
            throw new SAXParseException(string, this.locator);
        }
        this.errorHandler.fatalError(new SAXParseException(string, this.locator));
    }

    protected String getQNameOf(Node node) {
        return node.getPrefix().equals("") ? node.getLocalName() : String.valueOf(node.getPrefix()) + ":" + node.getLocalName();
    }

    public void startCDATA() throws SAXException {
        this.cdataStarted = true;
    }

    public void endCDATA() throws SAXException {
        this.cdataStarted = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }
}

