/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Hashtable;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleStopper {
    private Hashtable stoppedBundles;
    private BundleDescription[] allToStop = null;
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private boolean stopping;

    public BundleStopper(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        this.context = bundleContext;
        this.adaptor = frameworkAdaptor;
    }

    private void logCycles(Object[][] objectArray) {
        if (!Debug.DEBUG_ENABLED) {
            return;
        }
        if (objectArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                int n2 = 0;
                while (n2 < objectArray[n].length) {
                    stringBuffer.append(((BundleDescription)objectArray[n][n2]).getSymbolicName());
                    stringBuffer.append(',');
                    ++n2;
                }
                stringBuffer.insert(stringBuffer.length() - 1, ']');
                ++n;
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
            String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND, stringBuffer);
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, string, 0, null, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
        }
    }

    public void stopBundles() {
        this.allToStop = this.adaptor.getState().getResolvedBundles();
        StateHelper stateHelper = this.adaptor.getPlatformAdmin().getStateHelper();
        Object[][] objectArray = stateHelper.sortBundles(this.allToStop);
        this.logCycles(objectArray);
        this.stoppedBundles = new Hashtable(this.allToStop.length);
        this.basicStopBundles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void basicStopBundles() {
        this.stopping = true;
        int n = this.allToStop.length - 1;
        while (true) {
            block9: {
                Object var8_8;
                if (n < 0) {
                    this.stopping = false;
                    return;
                }
                AbstractBundle abstractBundle = (AbstractBundle)this.context.getBundle(this.allToStop[n].getBundleId());
                BaseData baseData = (BaseData)abstractBundle.getBundleData();
                EclipseStorageHook eclipseStorageHook = (EclipseStorageHook)baseData.getStorageHook(EclipseStorageHook.KEY);
                if (abstractBundle.getBundleId() == 0L || eclipseStorageHook == null || !eclipseStorageHook.isAutoStartable()) break block9;
                try {
                    try {
                        if (abstractBundle.getState() == 32 && abstractBundle instanceof BundleHost) {
                            abstractBundle.stop();
                            if (!eclipseStorageHook.isActivatedOnClassLoad()) {
                                baseData.setStatus(1);
                            }
                        }
                    }
                    catch (Exception exception) {
                        String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_ERROR_STOPPING_BUNDLE, this.allToStop[n].toString());
                        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, exception, null);
                        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    this.stoppedBundles.put(abstractBundle, abstractBundle);
                    throw throwable;
                }
                {
                    var8_8 = null;
                    this.stoppedBundles.put(abstractBundle, abstractBundle);
                }
            }
            --n;
        }
    }

    public boolean isStopped(Bundle bundle) {
        if (this.stoppedBundles == null) {
            return false;
        }
        return this.stoppedBundles.get(bundle) != null;
    }

    public boolean isStopping() {
        return this.stopping;
    }
}

