/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ResolverBundle
extends VersionSupplier {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] capabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private HashMap fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private ResolverImpl resolver;
    private boolean newFragmentExports;
    private ArrayList refs;

    ResolverBundle(BundleDescription bundleDescription, ResolverImpl resolverImpl) {
        super(bundleDescription);
        this.bundleID = new Long(bundleDescription.getBundleId());
        this.resolver = resolverImpl;
        this.initialize(bundleDescription.isResolved());
    }

    void initialize(boolean bl) {
        if (this.getBundle().isSingleton()) {
            this.refs = new ArrayList();
        }
        GenericDescription[] genericDescriptionArray = this.getBundle().getGenericCapabilities();
        this.capabilities = new GenericCapability[genericDescriptionArray.length];
        int n = 0;
        while (n < this.capabilities.length) {
            this.capabilities[n] = new GenericCapability(this, genericDescriptionArray[n]);
            ++n;
        }
        if (this.getBundle().getHost() != null) {
            this.host = new BundleConstraint(this, this.getBundle().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            this.genericReqiures = new GenericConstraint[0];
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = this.getBundle().getImportPackages();
        ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(importPackageSpecificationArray.length);
        int n2 = importPackageSpecificationArray.length - 1;
        while (n2 >= 0) {
            if ("optional".equals(importPackageSpecificationArray[n2].getDirective("resolution"))) {
                arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n2]));
            } else {
                arrayList.add(0, new ResolverImport(this, importPackageSpecificationArray[n2]));
            }
            --n2;
        }
        this.imports = arrayList.toArray(new ResolverImport[arrayList.size()]);
        ExportPackageDescription[] exportPackageDescriptionArray = bl ? this.getBundle().getSelectedExports() : this.getBundle().getExportPackages();
        this.exports = new ResolverExport[exportPackageDescriptionArray.length];
        int n3 = 0;
        while (n3 < exportPackageDescriptionArray.length) {
            this.exports[n3] = new ResolverExport(this, exportPackageDescriptionArray[n3]);
            ++n3;
        }
        BundleSpecification[] bundleSpecificationArray = this.getBundle().getRequiredBundles();
        this.requires = new BundleConstraint[bundleSpecificationArray.length];
        int n4 = 0;
        while (n4 < this.requires.length) {
            this.requires[n4] = new BundleConstraint(this, bundleSpecificationArray[n4]);
            ++n4;
        }
        GenericSpecification[] genericSpecificationArray = this.getBundle().getGenericRequires();
        this.genericReqiures = new GenericConstraint[genericSpecificationArray.length];
        int n5 = 0;
        while (n5 < this.genericReqiures.length) {
            this.genericReqiures[n5] = new GenericConstraint(this, genericSpecificationArray[n5]);
            ++n5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String string) {
        ResolverExport[] resolverExportArray = this.getExports(string);
        return resolverExportArray.length == 0 ? null : resolverExportArray[0];
    }

    ResolverExport[] getExports(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        Object[] objectArray = this.resolver.getResolverExports().get(string);
        int n = 0;
        while (n < objectArray.length) {
            if (((ResolverExport)objectArray[n]).getExporter() == this) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    void clearWires(boolean bl) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            resolverImportArray[n].setMatchingExport(null);
            if (bl) {
                resolverImportArray[n].clearUnresolvableWirings();
            }
            ++n;
        }
        if (this.host != null) {
            this.host.removeAllMatchingBundles();
        }
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            bundleConstraintArray[n2].setMatchingBundle(null);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = this.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            genericConstraintArray[n3].setMatchingCapability(null);
            ++n3;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int n) {
        this.state = n;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(this.imports.length);
        int n = 0;
        while (n < this.imports.length) {
            arrayList.add(this.imports[n]);
            ++n;
        }
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentImports.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new ResolverImport[arrayList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> arrayList = new ArrayList<ResolverExport>(this.exports.length);
        int n = 0;
        while (n < this.exports.length) {
            arrayList.add(this.exports[n]);
            ++n;
        }
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentExports.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        ResolverExport[] resolverExportArray = this.getExportPackages();
        int n = 0;
        int n2 = 0;
        while (n2 < resolverExportArray.length) {
            if (resolverExportArray[n2].isDropped()) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return resolverExportArray;
        }
        ResolverExport[] resolverExportArray2 = new ResolverExport[resolverExportArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < resolverExportArray.length) {
            if (!resolverExportArray[n4].isDropped()) {
                resolverExportArray2[n3] = resolverExportArray[n4];
                ++n3;
            }
            ++n4;
        }
        return resolverExportArray2;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        return this.capabilities;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> arrayList = new ArrayList<BundleConstraint>(this.requires.length);
        int n = 0;
        while (n < this.requires.length) {
            arrayList.add(this.requires[n]);
            ++n;
        }
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentRequires.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new BundleConstraint[arrayList.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        ArrayList<GenericConstraint> arrayList = new ArrayList<GenericConstraint>(this.genericReqiures.length);
        int n = 0;
        while (n < this.genericReqiures.length) {
            arrayList.add(this.genericReqiures[n]);
            ++n;
        }
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            ArrayList arrayList2 = (ArrayList)this.fragmentGenericRequires.get(resolverBundle.bundleID);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList.toArray(new GenericConstraint[arrayList.size()]);
    }

    BundleConstraint getRequire(String string) {
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (bundleConstraintArray[n].getVersionConstraint().getName().equals(string)) {
                return bundleConstraintArray[n];
            }
            ++n;
        }
        return null;
    }

    public BundleDescription getBundle() {
        return (BundleDescription)this.getBaseDescription();
    }

    ResolverImport getImport(String string) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].getName().equals(string)) {
                return resolverImportArray[n];
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        return "[" + this.getBundle() + "]";
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isImported(String string) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (string.equals(resolverImportArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isExported(String string) {
        ResolverExport resolverExport = this.getExport(string);
        if (resolverExport == null) {
            return false;
        }
        return (Integer)resolverExport.getExportPackageDescription().getDirective("x-equinox-ee") < 0;
    }

    private boolean isRequired(String string) {
        return this.getRequire(string) != null;
    }

    ResolverExport[] attachFragment(ResolverBundle resolverBundle, boolean bl) {
        int n;
        ArrayList<Object> arrayList;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.getBundle().attachFragments() || this.isResolved() && !this.getBundle().dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (resolverBundle.getHost().getMatchingBundles() != null && !((HostSpecification)resolverBundle.getHost().getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundle().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundle().getRequiredBundles();
        ExportPackageDescription[] exportPackageDescriptionArray = resolverBundle.getBundle().getExportPackages();
        GenericSpecification[] genericSpecificationArray = resolverBundle.getBundle().getGenericRequires();
        if (bl && this.constraintsConflict(resolverBundle.getBundle(), importPackageSpecificationArray, bundleSpecificationArray, genericSpecificationArray)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && exportPackageDescriptionArray.length > 0) {
            resolverBundle.setNewFragmentExports(true);
        }
        this.initFragments();
        if (this.fragments.contains(resolverBundle)) {
            return new ResolverExport[0];
        }
        this.fragments.add(resolverBundle);
        resolverBundle.getHost().addMatchingBundle(this);
        if (importPackageSpecificationArray.length > 0) {
            arrayList = new ArrayList<Object>(importPackageSpecificationArray.length);
            n = 0;
            while (n < importPackageSpecificationArray.length) {
                if (!this.isImported(importPackageSpecificationArray[n].getName())) {
                    arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n]));
                }
                ++n;
            }
            this.fragmentImports.put(resolverBundle.bundleID, arrayList);
        }
        if (bundleSpecificationArray.length > 0) {
            arrayList = new ArrayList(bundleSpecificationArray.length);
            n = 0;
            while (n < bundleSpecificationArray.length) {
                if (!this.isRequired(bundleSpecificationArray[n].getName())) {
                    arrayList.add(new BundleConstraint(this, bundleSpecificationArray[n]));
                }
                ++n;
            }
            this.fragmentRequires.put(resolverBundle.bundleID, arrayList);
        }
        if (genericSpecificationArray.length > 0) {
            arrayList = new ArrayList(genericSpecificationArray.length);
            n = 0;
            while (n < genericSpecificationArray.length) {
                arrayList.add(new GenericConstraint(this, genericSpecificationArray[n]));
                ++n;
            }
            this.fragmentGenericRequires.put(resolverBundle.bundleID, arrayList);
        }
        arrayList = new ArrayList(exportPackageDescriptionArray.length);
        if (exportPackageDescriptionArray.length > 0 && bl) {
            StateObjectFactory stateObjectFactory = this.resolver.getState().getFactory();
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                if (!this.isExported(exportPackageDescriptionArray[n2].getName())) {
                    ExportPackageDescription exportPackageDescription = stateObjectFactory.createExportPackageDescription(exportPackageDescriptionArray[n2].getName(), exportPackageDescriptionArray[n2].getVersion(), exportPackageDescriptionArray[n2].getDirectives(), exportPackageDescriptionArray[n2].getAttributes(), exportPackageDescriptionArray[n2].isRoot(), this.getBundle());
                    arrayList.add(new ResolverExport(this, exportPackageDescription));
                }
                ++n2;
            }
            this.fragmentExports.put(resolverBundle.bundleID, arrayList);
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    private boolean constraintsConflict(BundleDescription bundleDescription, ImportPackageSpecification[] importPackageSpecificationArray, BundleSpecification[] bundleSpecificationArray, GenericSpecification[] genericSpecificationArray) {
        ResolverConstraint resolverConstraint;
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            resolverConstraint = this.getImport(importPackageSpecificationArray[n].getName());
            if (resolverConstraint == null && this.isResolved() || resolverConstraint != null && !ResolverBundle.isIncluded(importPackageSpecificationArray[n].getVersionRange(), resolverConstraint.getVersionConstraint().getVersionRange())) {
                this.resolver.getState().addResolverError(bundleDescription, 16, importPackageSpecificationArray[n].toString(), importPackageSpecificationArray[n]);
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < bundleSpecificationArray.length) {
            resolverConstraint = this.getRequire(bundleSpecificationArray[n].getName());
            if (resolverConstraint == null && this.isResolved() || resolverConstraint != null && !ResolverBundle.isIncluded(bundleSpecificationArray[n].getVersionRange(), resolverConstraint.getVersionConstraint().getVersionRange())) {
                this.resolver.getState().addResolverError(bundleDescription, 16, bundleSpecificationArray[n].toString(), bundleSpecificationArray[n]);
                return true;
            }
            ++n;
        }
        return !this.isResolved() ? false : genericSpecificationArray != null && genericSpecificationArray.length > 0;
    }

    private static boolean isIncluded(VersionRange versionRange, VersionRange versionRange2) {
        if (!(versionRange.isIncluded(versionRange2.getMinimum()) || versionRange2.getMinimum().equals(versionRange.getMinimum()) && versionRange2.getIncludeMinimum() == versionRange.getIncludeMinimum())) {
            return false;
        }
        return versionRange.isIncluded(versionRange2.getMaximum()) || versionRange2.getMaximum().equals(versionRange.getMaximum()) && versionRange2.getIncludeMaximum() == versionRange.getIncludeMaximum();
    }

    private void setNewFragmentExports(boolean bl) {
        this.newFragmentExports = bl;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    ResolverExport[] detachFragment(ResolverBundle resolverBundle, ResolverConstraint resolverConstraint) {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        if (!this.fragments.remove(resolverBundle)) {
            return new ResolverExport[0];
        }
        resolverBundle.getHost().removeMatchingBundle(this);
        ArrayList arrayList = (ArrayList)this.fragmentImports.remove(resolverBundle.bundleID);
        ArrayList arrayList2 = (ArrayList)this.fragmentRequires.remove(resolverBundle.bundleID);
        ArrayList arrayList3 = (ArrayList)this.fragmentExports.remove(resolverBundle.bundleID);
        this.fragmentGenericRequires.remove(resolverBundle.bundleID);
        if (resolverConstraint != null) {
            ResolverBundle[] resolverBundleArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            int n = 0;
            while (n < resolverBundleArray.length) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                this.resolver.getResolverExports().remove(this.detachFragment(resolverBundleArray[n], null));
                VersionConstraint[] versionConstraintArray = resolverConstraint instanceof ResolverImport ? resolverBundleArray[n].getBundle().getImportPackages() : resolverBundleArray[n].getBundle().getRequiredBundles();
                int n2 = 0;
                while (n2 < versionConstraintArray.length) {
                    if (resolverConstraint.getName().equals(versionConstraintArray[n2].getName())) {
                        // empty if block
                    }
                    ++n2;
                }
                this.resolver.getResolverExports().put(this.attachFragment(resolverBundleArray[n], true));
                ArrayList arrayList4 = (ArrayList)this.fragmentImports.get(resolverBundleArray[n].bundleID);
                if (arrayList4 != null && arrayList != null) {
                    object4 = arrayList4.iterator();
                    while (object4.hasNext()) {
                        object3 = (ResolverImport)object4.next();
                        object2 = arrayList.iterator();
                        while (object2.hasNext()) {
                            object = (ResolverImport)object2.next();
                            if (!((ResolverImport)object3).getName().equals(((ResolverImport)object).getName())) continue;
                            ((ResolverImport)object3).setMatchingExport(((ResolverImport)object).getMatchingExport());
                        }
                    }
                }
                if ((object4 = (ArrayList)this.fragmentRequires.get(resolverBundleArray[n].bundleID)) != null && arrayList2 != null) {
                    object3 = ((ArrayList)object4).iterator();
                    while (object3.hasNext()) {
                        object2 = (BundleConstraint)object3.next();
                        object = arrayList2.iterator();
                        while (object.hasNext()) {
                            BundleConstraint bundleConstraint = (BundleConstraint)object.next();
                            if (!((ResolverConstraint)object2).getName().equals(bundleConstraint.getName())) continue;
                            ((BundleConstraint)object2).setMatchingBundle(bundleConstraint.getMatchingBundle());
                        }
                    }
                }
                ++n;
            }
        }
        return arrayList3 == null ? new ResolverExport[]{} : arrayList3.toArray(new ResolverExport[arrayList3.size()]);
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] resolverBundleArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.detachFragment(resolverBundleArray[n], null);
            ++n;
        }
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean bl) {
        this.resolvable = bl;
    }

    void addExport(ResolverExport resolverExport) {
        ResolverExport[] resolverExportArray = new ResolverExport[this.exports.length + 1];
        int n = 0;
        while (n < this.exports.length) {
            resolverExportArray[n] = this.exports[n];
            ++n;
        }
        resolverExportArray[this.exports.length] = resolverExport;
        this.exports = resolverExportArray;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    void clearRefs() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    void addRef(ResolverBundle resolverBundle) {
        if (this.refs != null && !this.refs.contains(resolverBundle)) {
            this.refs.add(resolverBundle);
        }
    }

    int getRefs() {
        return this.refs == null ? 0 : this.refs.size();
    }
}

