/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class PartPane
extends LayoutPart
implements Listener {
    protected PresentablePart presentableAdapter = new PresentablePart(this);
    public static final String PROP_ZOOMED = "zoomed";
    private boolean isZoomed = false;
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected Composite control;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            LayoutPart layoutPart;
            Control control;
            ILayoutContainer iLayoutContainer;
            if ((traverseEvent.detail == 512 || traverseEvent.detail == 256) && (iLayoutContainer = PartPane.this.getContainer()) != null && iLayoutContainer instanceof LayoutPart && (control = (layoutPart = (LayoutPart)((Object)iLayoutContainer)).getControl()) != null && !control.isDisposed()) {
                control.traverse(traverseEvent.detail);
                traverseEvent.doit = false;
            }
        }
    };

    public PartPane(IWorkbenchPartReference iWorkbenchPartReference, WorkbenchPage workbenchPage) {
        super(iWorkbenchPartReference.getId());
        this.partReference = iWorkbenchPartReference;
        this.page = workbenchPage;
    }

    public void createControl(Composite composite) {
        if (this.getControl() != null) {
            return;
        }
        this.control = new Composite(composite, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setVisible(false);
        this.createTitleBar();
        this.control.addListener(26, (Listener)this);
        this.control.addTraverseListener(this.traverseListener);
    }

    protected abstract void createTitleBar();

    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control.removeTraverseListener(this.traverseListener);
            this.control.dispose();
            this.control = null;
        }
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.isDocked()) {
            this.page.toggleZoom(this.partReference);
        }
    }

    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    public Control getControl() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void moveAbove(Control control) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(control);
        }
    }

    protected void requestActivation() {
        IWorkbenchPart iWorkbenchPart = this.partReference.getPart(true);
        this.page.requestActivation(iWorkbenchPart);
    }

    public void setContainer(ILayoutContainer iLayoutContainer) {
        super.setContainer(iLayoutContainer);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.partReference.getPart(true);
        }
        super.setVisible(bl);
    }

    public void setFocus() {
        this.requestActivation();
        IWorkbenchPart iWorkbenchPart = this.partReference.getPart(true);
        if (iWorkbenchPart != null) {
            iWorkbenchPart.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    public void setZoomed(boolean bl) {
        if (this.isZoomed == bl) {
            return;
        }
        super.setZoomed(bl);
        this.isZoomed = bl;
        Object[] objectArray = this.getPropertyListeners().getListeners();
        if (objectArray.length > 0) {
            Boolean bl2 = bl ? Boolean.FALSE : Boolean.TRUE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, PROP_ZOOMED, (Object)bl2, (Object)bl3);
            int n = 0;
            while (n < objectArray.length) {
                ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart layoutPart) {
        return this;
    }

    public PartStack getStack() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer instanceof PartStack) {
            return (PartStack)iLayoutContainer;
        }
        return null;
    }

    public void showPaneMenu() {
        PartStack partStack = this.getStack();
        if (partStack != null) {
            partStack.showSystemMenu();
        }
    }

    public void showViewMenu() {
        PartStack partStack = this.getStack();
        if (partStack != null) {
            partStack.showPaneMenu();
        }
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void doDock() {
    }

    public void setBusy(boolean bl) {
    }

    public void showHighlight() {
    }

    public void reparent(Composite composite) {
        super.reparent(composite);
    }

    public abstract Control getToolBar();

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point point) {
    }

    public boolean isBusy() {
        return false;
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }

    public abstract boolean isCloseable();

    public static class Sashes {
        public Composite left;
        public Composite right;
        public Composite top;
        public Composite bottom;
    }
}

