/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class BundleUtility {
    public static boolean isActive(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return bundle.getState() == 32;
    }

    public static boolean isActivated(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        switch (bundle.getState()) {
            case 8: 
            case 16: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReady(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        switch (bundle.getState()) {
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isActive(String string) {
        return BundleUtility.isActive(Platform.getBundle((String)string));
    }

    public static boolean isActivated(String string) {
        return BundleUtility.isActivated(Platform.getBundle((String)string));
    }

    public static boolean isReady(String string) {
        return BundleUtility.isReady(Platform.getBundle((String)string));
    }

    public static URL find(Bundle bundle, String string) {
        if (bundle == null) {
            return null;
        }
        return Platform.find((Bundle)bundle, (IPath)new Path(string));
    }

    public static URL find(String string, String string2) {
        return BundleUtility.find(Platform.getBundle((String)string), string2);
    }

    public static void log(String string, Throwable throwable) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return;
        }
        Status status = new Status(4, string, 4, throwable.getMessage() == null ? "" : throwable.getMessage(), throwable);
        Platform.getLog((Bundle)bundle).log((IStatus)status);
    }
}

