/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PlatformURLMetaConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String META = "meta";
    static /* synthetic */ Class class$0;

    public PlatformURLMetaConnection(URL uRL) {
        super(uRL);
    }

    protected URL resolve() throws IOException {
        String string = this.url.getFile().trim();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith(META)) {
            throw new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)this.url.toString()));
        }
        int n = string.indexOf("/", META.length() + 1);
        String string2 = n == -1 ? string.substring(META.length() + 1) : string.substring(META.length() + 1, n);
        String string3 = this.getId(string2);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        this.target = activator.getBundle(string3);
        if (this.target == null) {
            throw new IOException(NLS.bind((String)CommonMessages.url_resolvePlugin, (Object)this.url.toString()));
        }
        IPath iPath = MetaDataKeeper.getMetaArea().getStateLocation(this.target);
        if (n != -1 || n + 1 <= string.length()) {
            iPath = iPath.append(string.substring(n + 1));
        }
        return iPath.toFile().toURL();
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLMetaConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(META, clazz);
        isRegistered = true;
    }

    public OutputStream getOutputStream() throws IOException {
        String string;
        URL uRL = this.getResolvedURL();
        if (uRL != null && (string = uRL.getFile()) != null) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null) {
                new File(string2).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

