/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class Status
implements IStatus {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.core.runtime", 0, CommonMessages.ok, null);
    public static final IStatus CANCEL_STATUS = new Status(8, "org.eclipse.core.runtime", 1, "", null);
    private int severity = 0;
    private String pluginId;
    private int code;
    private String message;
    private Throwable exception = null;
    private static final IStatus[] theEmptyStatusArray = new IStatus[0];

    public Status(int n, String string, int n2, String string2, Throwable throwable) {
        this.setSeverity(n);
        this.setPlugin(string);
        this.setCode(n2);
        this.setMessage(string2);
        this.setException(throwable);
    }

    public IStatus[] getChildren() {
        return theEmptyStatusArray;
    }

    public int getCode() {
        return this.code;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPlugin() {
        return this.pluginId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int n) {
        return (this.severity & n) != 0;
    }

    protected void setCode(int n) {
        this.code = n;
    }

    protected void setException(Throwable throwable) {
        this.exception = throwable;
    }

    protected void setMessage(String string) {
        Assert.isLegal(string != null);
        this.message = string;
    }

    protected void setPlugin(String string) {
        Assert.isLegal(string != null && string.length() > 0);
        this.pluginId = string;
    }

    protected void setSeverity(int n) {
        Assert.isLegal(n == 0 || n == 4 || n == 2 || n == 1 || n == 8);
        this.severity = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Status ");
        if (this.severity == 0) {
            stringBuffer.append("OK");
        } else if (this.severity == 4) {
            stringBuffer.append("ERROR");
        } else if (this.severity == 2) {
            stringBuffer.append("WARNING");
        } else if (this.severity == 1) {
            stringBuffer.append("INFO");
        } else if (this.severity == 8) {
            stringBuffer.append("CANCEL");
        } else {
            stringBuffer.append("severity=");
            stringBuffer.append(this.severity);
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.pluginId);
        stringBuffer.append(" code=");
        stringBuffer.append(this.code);
        stringBuffer.append(' ');
        stringBuffer.append(this.message);
        stringBuffer.append(' ');
        stringBuffer.append(this.exception);
        return stringBuffer.toString();
    }
}

