/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IExecutionListenerWithChecks;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IObjectWithState;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ITypedParameter;
import org.eclipse.core.commands.NamedHandleObjectWithState;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.internal.commands.util.Util;
import org.eclipse.core.runtime.ListenerList;

public final class Command
extends NamedHandleObjectWithState
implements Comparable {
    public static boolean DEBUG_COMMAND_EXECUTION = false;
    public static boolean DEBUG_HANDLERS = false;
    public static String DEBUG_HANDLERS_COMMAND_ID = null;
    private Category category = null;
    private transient ListenerList executionListeners = null;
    private transient IHandler handler = null;
    private String helpContextId;
    private IParameter[] parameters = null;
    private ParameterType returnType = null;

    Command(String string) {
        super(string);
    }

    public final void addCommandListener(ICommandListener iCommandListener) {
        if (iCommandListener == null) {
            throw new NullPointerException("Cannot add a null command listener");
        }
        this.addListenerObject(iCommandListener);
    }

    public final void addExecutionListener(IExecutionListener iExecutionListener) {
        if (iExecutionListener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ListenerList(1);
        }
        this.executionListeners.add((Object)iExecutionListener);
    }

    public void addState(String string, State state) {
        super.addState(string, state);
        state.setId(string);
        if (this.handler instanceof IObjectWithState) {
            ((IObjectWithState)((Object)this.handler)).addState(string, state);
        }
    }

    public final int compareTo(Object object) {
        Command command = (Command)object;
        int n = Util.compare(this.category, command.category);
        if (n == 0 && (n = Util.compare(this.defined, command.defined)) == 0 && (n = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)command.description))) == 0 && (n = Util.compare(this.handler, command.handler)) == 0 && (n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)command.id))) == 0 && (n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)command.name))) == 0) {
            n = Util.compare(this.parameters, command.parameters);
        }
        return n;
    }

    public final void define(String string, String string2, Category category) {
        this.define(string, string2, category, null);
    }

    public final void define(String string, String string2, Category category, IParameter[] iParameterArray) {
        this.define(string, string2, category, iParameterArray, null);
    }

    public final void define(String string, String string2, Category category, IParameter[] iParameterArray, ParameterType parameterType) {
        this.define(string, string2, category, iParameterArray, parameterType, null);
    }

    public final void define(String string, String string2, Category category, IParameter[] iParameterArray, ParameterType parameterType, String string3) {
        if (string == null) {
            throw new NullPointerException("The name of a command cannot be null");
        }
        if (category == null) {
            throw new NullPointerException("The category of a command cannot be null");
        }
        boolean bl = !this.defined;
        this.defined = true;
        boolean bl2 = !Util.equals(this.name, string);
        this.name = string;
        boolean bl3 = !Util.equals(this.description, string2);
        this.description = string2;
        boolean bl4 = !Util.equals(this.category, category);
        this.category = category;
        boolean bl5 = !Util.equals(this.parameters, iParameterArray);
        this.parameters = iParameterArray;
        boolean bl6 = !Util.equals(this.returnType, parameterType);
        this.returnType = parameterType;
        boolean bl7 = !Util.equals(this.helpContextId, string3);
        this.helpContextId = string3;
        this.fireCommandChanged(new CommandEvent(this, bl4, bl, bl3, false, bl2, bl5, bl6, bl7));
    }

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException, NotHandledException {
        this.firePreExecute(executionEvent);
        IHandler iHandler = this.handler;
        if (iHandler != null && iHandler.isHandled()) {
            try {
                Object object = iHandler.execute(executionEvent);
                this.firePostExecuteSuccess(object);
                return object;
            }
            catch (ExecutionException executionException) {
                this.firePostExecuteFailure(executionException);
                throw executionException;
            }
        }
        NotHandledException notHandledException = new NotHandledException("There is no handler to execute.");
        this.fireNotHandled(notHandledException);
        throw notHandledException;
    }

    public final Object executeWithChecks(ExecutionEvent executionEvent) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.firePreExecute(executionEvent);
        IHandler iHandler = this.handler;
        if (!this.isDefined()) {
            NotDefinedException notDefinedException = new NotDefinedException("Trying to execute a command that is not defined. " + this.id);
            this.fireNotDefined(notDefinedException);
            throw notDefinedException;
        }
        if (iHandler != null && iHandler.isHandled()) {
            if (!this.isEnabled()) {
                NotEnabledException notEnabledException = new NotEnabledException("Trying to execute a disabled command");
                this.fireNotEnabled(notEnabledException);
                throw notEnabledException;
            }
            try {
                Object object = iHandler.execute(executionEvent);
                this.firePostExecuteSuccess(object);
                return object;
            }
            catch (ExecutionException executionException) {
                this.firePostExecuteFailure(executionException);
                throw executionException;
            }
        }
        NotHandledException notHandledException = new NotHandledException("There is no handler to execute.");
        this.fireNotHandled(notHandledException);
        throw notHandledException;
    }

    private final void fireCommandChanged(CommandEvent commandEvent) {
        if (commandEvent == null) {
            throw new NullPointerException("Cannot fire a null event");
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICommandListener iCommandListener = (ICommandListener)objectArray[n];
            iCommandListener.commandChanged(commandEvent);
            ++n;
        }
    }

    private final void fireNotDefined(NotDefinedException notDefinedException) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not defined: id=" + this.getId() + "; exception=" + notDefinedException);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IExecutionListenerWithChecks) {
                    IExecutionListenerWithChecks iExecutionListenerWithChecks = (IExecutionListenerWithChecks)object;
                    iExecutionListenerWithChecks.notDefined(this.getId(), notDefinedException);
                }
                ++n;
            }
        }
    }

    private final void fireNotEnabled(NotEnabledException notEnabledException) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not enabled: id=" + this.getId() + "; exception=" + notEnabledException);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IExecutionListenerWithChecks) {
                    IExecutionListenerWithChecks iExecutionListenerWithChecks = (IExecutionListenerWithChecks)object;
                    iExecutionListenerWithChecks.notEnabled(this.getId(), notEnabledException);
                }
                ++n;
            }
        }
    }

    private final void fireNotHandled(NotHandledException notHandledException) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not handled: id=" + this.getId() + "; exception=" + notHandledException);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IExecutionListener iExecutionListener = (IExecutionListener)objectArray[n];
                iExecutionListener.notHandled(this.getId(), notHandledException);
                ++n;
            }
        }
    }

    private final void firePostExecuteFailure(ExecutionException executionException) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> failure: id=" + this.getId() + "; exception=" + executionException);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IExecutionListener iExecutionListener = (IExecutionListener)objectArray[n];
                iExecutionListener.postExecuteFailure(this.getId(), executionException);
                ++n;
            }
        }
    }

    private final void firePostExecuteSuccess(Object object) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> success: id=" + this.getId() + "; returnValue=" + object);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IExecutionListener iExecutionListener = (IExecutionListener)objectArray[n];
                iExecutionListener.postExecuteSuccess(this.getId(), object);
                ++n;
            }
        }
    }

    private final void firePreExecute(ExecutionEvent executionEvent) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> starting: id=" + this.getId() + "; event=" + executionEvent);
        }
        if (this.executionListeners != null) {
            Object[] objectArray = this.executionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IExecutionListener iExecutionListener = (IExecutionListener)objectArray[n];
                iExecutionListener.preExecute(this.getId(), executionEvent);
                ++n;
            }
        }
    }

    public final Category getCategory() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the category from an undefined command. " + this.id);
        }
        return this.category;
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final String getHelpContextId() {
        return this.helpContextId;
    }

    public final IParameter getParameter(String string) throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get a parameter from an undefined command. " + this.id);
        }
        if (this.parameters == null) {
            return null;
        }
        int n = 0;
        while (n < this.parameters.length) {
            IParameter iParameter = this.parameters[n];
            if (iParameter.getId().equals(string)) {
                return iParameter;
            }
            ++n;
        }
        return null;
    }

    public final IParameter[] getParameters() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the parameters from an undefined command. " + this.id);
        }
        if (this.parameters == null || this.parameters.length == 0) {
            return null;
        }
        IParameter[] iParameterArray = new IParameter[this.parameters.length];
        System.arraycopy(this.parameters, 0, iParameterArray, 0, this.parameters.length);
        return iParameterArray;
    }

    public final ParameterType getParameterType(String string) throws NotDefinedException {
        IParameter iParameter = this.getParameter(string);
        if (iParameter instanceof ITypedParameter) {
            ITypedParameter iTypedParameter = (ITypedParameter)((Object)iParameter);
            return iTypedParameter.getParameterType();
        }
        return null;
    }

    public final ParameterType getReturnType() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the return type of an undefined command. " + this.id);
        }
        return this.returnType;
    }

    public final boolean isEnabled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled() && this.handler.isEnabled();
    }

    public final boolean isHandled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled();
    }

    public final void removeCommandListener(ICommandListener iCommandListener) {
        if (iCommandListener == null) {
            throw new NullPointerException("Cannot remove a null command listener");
        }
        this.removeListenerObject(iCommandListener);
    }

    public final void removeExecutionListener(IExecutionListener iExecutionListener) {
        if (iExecutionListener == null) {
            throw new NullPointerException("Cannot remove a null execution listener");
        }
        if (this.executionListeners != null) {
            this.executionListeners.remove((Object)iExecutionListener);
            if (this.executionListeners.isEmpty()) {
                this.executionListeners = null;
            }
        }
    }

    public void removeState(String string) {
        if (this.handler instanceof IObjectWithState) {
            ((IObjectWithState)((Object)this.handler)).removeState(string);
        }
        super.removeState(string);
    }

    public final boolean setHandler(IHandler iHandler) {
        if (Util.equals(iHandler, this.handler)) {
            return false;
        }
        String[] stringArray = this.getStateIds();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (this.handler instanceof IObjectWithState) {
                    ((IObjectWithState)((Object)this.handler)).removeState(string);
                }
                if (iHandler instanceof IObjectWithState) {
                    State state = this.getState(string);
                    ((IObjectWithState)((Object)iHandler)).addState(string, state);
                }
                ++n;
            }
        }
        this.handler = iHandler;
        this.string = null;
        if (DEBUG_HANDLERS && (DEBUG_HANDLERS_COMMAND_ID == null || DEBUG_HANDLERS_COMMAND_ID.equals(this.id))) {
            StringBuffer stringBuffer = new StringBuffer("Command('");
            stringBuffer.append(this.id);
            stringBuffer.append("') has changed to ");
            if (iHandler == null) {
                stringBuffer.append("no handler");
            } else {
                stringBuffer.append('\'');
                stringBuffer.append(iHandler);
                stringBuffer.append("' as its handler");
            }
            Tracing.printTrace("HANDLERS", stringBuffer.toString());
        }
        this.fireCommandChanged(new CommandEvent(this, false, false, false, true, false, false, false));
        return true;
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Command(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.category);
            stringBuffer.append(',');
            stringBuffer.append(this.handler);
            stringBuffer.append(',');
            stringBuffer.append(this.parameters);
            stringBuffer.append(',');
            stringBuffer.append(this.returnType);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean bl = this.defined;
        this.defined = false;
        boolean bl2 = this.name != null;
        this.name = null;
        boolean bl3 = this.description != null;
        this.description = null;
        boolean bl4 = this.category != null;
        this.category = null;
        boolean bl5 = this.parameters != null;
        this.parameters = null;
        boolean bl6 = this.returnType != null;
        this.returnType = null;
        String[] stringArray = this.getStateIds();
        if (stringArray != null) {
            if (this.handler instanceof IObjectWithState) {
                IObjectWithState iObjectWithState = (IObjectWithState)((Object)this.handler);
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    iObjectWithState.removeState(string);
                    State state = this.getState(string);
                    this.removeState(string);
                    state.dispose();
                    ++n;
                }
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    State state = this.getState(string);
                    this.removeState(string);
                    state.dispose();
                    ++n;
                }
            }
        }
        this.fireCommandChanged(new CommandEvent(this, bl4, bl, bl3, false, bl2, bl5, bl6));
    }
}

