/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    public static final int LIMIT = OS.AbstractTextComponent_GetDefaultTextLimit();
    public static final String DELIMITER = OS.AbstractTextComponent_GetDelimiter();
    private static final int NORMAL = 1;
    private static final int ALWAYS_ON = 2;
    private static final int ALWAYS_OFF = 3;
    char echoChar = '\u0000';
    int orientation = 0x2000000;
    boolean editable;
    boolean doubleClick = true;
    private int textLimit = LIMIT;

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        } else if (string.equals("")) {
            return;
        }
        String str = string;
        int length = this.getCharCount();
        if ((this.hooks(25) || this.filters(25)) && (str = this.verifyText(string, length, length, null)) == null) {
            return;
        }
        OS.AbstractTextComponent_Replace(this.internal_handle, str, length, length);
        int newLength = OS.AbstractTextComponent_GetText(this.internal_handle).length();
        OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, newLength);
        this.internal_sendEvent(24);
    }

    static int checkStyle(int style) {
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        Point sel = this.getSelection();
        OS.AbstractTextComponent_SetSelection(this.internal_handle, sel.y, sel.y);
    }

    public void copy() {
        this.checkWidget();
        String text = this.getSelectionText();
        if (text.length() > 0) {
            OS.Clipboard_SetText(text);
        }
    }

    protected void internal_createHandle(int index) {
        int parentHandle = this.internal_parent.internal_handle;
        int nativeStyle = this.internal_getNativeStyle();
        if ((this.internal_style & 4) != 0) {
            this.internal_handle = OS.TextField_New(parentHandle, nativeStyle);
            if ((this.internal_style & 0x400000) != 0) {
                OS.AbstractTextComponent_SetEchoChar(this.internal_handle, '*');
            }
        } else {
            this.internal_handle = OS.TextArea_New(parentHandle, nativeStyle);
        }
        if (this.internal_handle == 0) {
            Text.error(2);
        }
        this.setEditable((this.internal_style & 8) == 0);
    }

    void createWidget(int i) {
        super.createWidget(i);
        if (this.getCaretPosition() == 0) {
            this.setSelection(0);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && (this.internal_style & 0x40) == 64) {
            this.checkWidget();
            int[] pointArray = OS.AbstractTextComponent_GetMinimumSize(this.internal_handle, wHint);
            return new Point(pointArray[0], pointArray[1]);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 0x40) == 64) {
            nativeStyle |= 0x100;
            nativeStyle |= 0x800000;
        }
        return nativeStyle;
    }

    public void cut() {
        this.checkWidget();
        String text = this.getSelectionText();
        if (text.equals("")) {
            return;
        }
        String newText = "";
        int[] sel = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText("", sel[0], sel[1], null)) == null) {
            return;
        }
        OS.Clipboard_SetText(text);
        OS.AbstractTextComponent_Replace(this.internal_handle, newText, sel[0], sel[1]);
        OS.AbstractTextComponent_SetSelection(this.internal_handle, sel[0], sel[0]);
        this.internal_sendEvent(24);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.internal_style & 4) == 4) {
            return 0;
        }
        return OS.TextArea_GetCaretLineNumber(this.internal_handle);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        int[] pos = OS.AbstractTextComponent_GetCaretPosition(this.internal_handle);
        return new Point(pos[0], pos[1]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] selection = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        return selection[0];
    }

    public int getCharCount() {
        this.checkWidget();
        return OS.AbstractTextComponent_GetCharCount(this.internal_handle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoChar;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.internal_style & 4) == 4) {
            return 1;
        }
        return OS.TextArea_GetLineCount(this.internal_handle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        return OS.AbstractTextComponent_GetLineHeight(this.internal_handle);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.orientation;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] selection = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        return new Point(selection[0], selection[1]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] selection = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        return selection[1] - selection[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        return OS.AbstractTextComponent_GetSelectionText(this.internal_handle);
    }

    public String getText() {
        this.checkWidget();
        return OS.AbstractTextComponent_GetText(this.internal_handle);
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || 0 > end) {
            return "";
        }
        String fullText = OS.AbstractTextComponent_GetText(this.internal_handle);
        int length = fullText.length();
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        if (start >= length) {
            return "";
        }
        return fullText.substring(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.internal_style & 4) != 0) {
            return 0;
        }
        return OS.TextArea_GetTopLine(this.internal_handle);
    }

    public int getTopPixel() {
        this.checkWidget();
        int top = this.getTopIndex();
        int lineHeight = this.getLineHeight();
        return top * lineHeight;
    }

    boolean handleDoubleClick(int event) {
        return this.doubleClick;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        } else if (string.equals("")) {
            return;
        }
        String str = string;
        int[] selection = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        if ((this.hooks(25) || this.filters(25)) && (str = this.verifyText(string, selection[0], selection[1], null)) == null) {
            return;
        }
        OS.AbstractTextComponent_Replace(this.internal_handle, str, selection[0], selection[1]);
        OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, selection[0] + str.length());
        this.internal_sendEvent(24);
    }

    public void paste() {
        this.checkWidget();
        String text = OS.Clipboard_GetText();
        int[] selection = OS.AbstractTextComponent_GetSelection(this.internal_handle);
        if ((this.hooks(25) || this.filters(25)) && (text = this.verifyText(text, selection[0], selection[1], null)) == null) {
            return;
        }
        OS.AbstractTextComponent_Replace(this.internal_handle, text, selection[0], selection[1]);
        OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, selection[0] + text.length());
        this.internal_sendEvent(24);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Text.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        OS.AbstractTextComponent_SelectAll(this.internal_handle);
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
        OS.AbstractTextComponent_SetDoubleClickEnabled(this.internal_handle, doubleClick);
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        this.echoChar = echo;
        OS.AbstractTextComponent_SetEchoChar(this.internal_handle, echo);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.editable = editable;
        OS.AbstractTextComponent_SetEditable(this.internal_handle, editable);
    }

    public void setOrientation(int orientation) {
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        this.orientation = orientation;
    }

    public void setSelection(int start) {
        this.checkWidget();
        int nStart = Math.max(start, 0);
        OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, nStart);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int nStart = Math.max(Math.min(start, end), 0);
        int nEnd = Math.min(Math.max(start, end), this.getCharCount());
        OS.AbstractTextComponent_SetSelection(this.internal_handle, nStart, nEnd);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            Text.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        int length;
        this.checkWidget();
        if (string == null) {
            Text.error(4);
        } else if (string.equals("") && string.equals(this.getText())) {
            return;
        }
        String str = string;
        if ((this.hooks(25) || this.filters(25)) && (str = this.verifyText(string, 0, length = this.getCharCount(), null)) == null) {
            return;
        }
        OS.AbstractTextComponent_SetText(this.internal_handle, str);
        OS.AbstractTextComponent_SetCaretPosition(this.internal_handle, 0);
        this.internal_sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit < 0) {
            return;
        }
        if (limit == 0) {
            Text.error(7);
        }
        this.textLimit = limit;
        OS.AbstractTextComponent_SetTextLimit(this.internal_handle, limit);
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.internal_style & 4) != 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        OS.TextArea_SetTopLine(this.internal_handle, index);
    }

    public void showSelection() {
        this.checkWidget();
        Point sel = this.getSelection();
        this.setSelection(sel.x, sel.y);
    }

    boolean keyCallback(int type, char character, int keycode, int modifiers) {
        boolean consumed = super.keyCallback(type, character, keycode, modifiers);
        if (!consumed && type == 1 && keycode == 1002 && (this.internal_style & 4) != 0) {
            this.internal_sendEvent(14);
        }
        return consumed;
    }

    void textModifyCallback() {
        this.internal_sendEvent(24);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle r = this.getBounds();
        r.x = 0;
        r.y = 0;
        return r;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    void focusCallback(int event) {
        super.focusCallback(event);
        if (Device.internal_vkstatus == 2) {
            OS.AbstractTextComponent_SetVKStatus(true, this.internal_handle);
        } else if (Device.internal_vkstatus == 3) {
            OS.AbstractTextComponent_SetVKStatus(false, this.internal_handle);
        } else if (!this.editable) {
            OS.AbstractTextComponent_SetVKStatus(false, this.internal_handle);
        } else {
            if (event == 1) {
                OS.AbstractTextComponent_SetVKStatus(true, this.internal_handle);
            }
            if (event == 2) {
                OS.AbstractTextComponent_SetVKStatus(false, this.internal_handle);
            }
        }
    }
}

