/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class CachedManifest
extends Dictionary {
    private Dictionary manifest = null;
    private EclipseStorageHook storageHook;

    public CachedManifest(EclipseStorageHook eclipseStorageHook) {
        this.storageHook = eclipseStorageHook;
    }

    public Dictionary getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = this.storageHook.createCachedManifest(true);
            }
            catch (BundleException bundleException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CACHEDMANIFEST_UNEXPECTED_EXCEPTION, this.storageHook.getBaseData().getLocation());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, bundleException, null);
                this.storageHook.getAdaptor().getFrameworkLog().log(frameworkLogEntry);
                return null;
            }
        }
        return this.manifest;
    }

    public int size() {
        return this.getManifest().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration elements() {
        return this.getManifest().elements();
    }

    public Enumeration keys() {
        return this.getManifest().keys();
    }

    public Object get(Object object) {
        if (this.manifest != null) {
            return this.manifest.get(object);
        }
        String string = (String)object;
        if ("Bundle-Version".equalsIgnoreCase(string)) {
            Version version = this.storageHook.getBaseData().getVersion();
            return version == null ? null : version.toString();
        }
        if ("Plugin-Class".equalsIgnoreCase(string)) {
            return this.storageHook.getPluginClass();
        }
        if ("Bundle-SymbolicName".equalsIgnoreCase(string)) {
            if ((this.storageHook.getBaseData().getType() & 8) == 0) {
                return this.storageHook.getBaseData().getSymbolicName();
            }
            return String.valueOf(this.storageHook.getBaseData().getSymbolicName()) + ';' + "singleton" + ":=true";
        }
        if ("Eclipse-BuddyPolicy".equalsIgnoreCase(string)) {
            return this.storageHook.getBuddyList();
        }
        if ("Eclipse-RegisterBuddy".equalsIgnoreCase(string)) {
            return this.storageHook.getRegisteredBuddyList();
        }
        if ("Bundle-Activator".equalsIgnoreCase(string)) {
            return this.storageHook.getBaseData().getActivator();
        }
        if ("Eclipse-LazyStart".equals(string) || "Eclipse-AutoStart".equals(string)) {
            if (!this.storageHook.isAutoStartable()) {
                return null;
            }
            if (this.storageHook.getAutoStartExceptions() == null) {
                return Boolean.TRUE.toString();
            }
            StringBuffer stringBuffer = new StringBuffer(Boolean.TRUE.toString());
            stringBuffer.append(";").append("exceptions").append("=\"");
            String[] stringArray = this.storageHook.getAutoStartExceptions();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        Dictionary dictionary = this.getManifest();
        return dictionary == null ? null : dictionary.get(object);
    }

    public Object remove(Object object) {
        return this.getManifest().remove(object);
    }

    public Object put(Object object, Object object2) {
        return this.getManifest().put(object, object2);
    }
}

