/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

public class Semaphore {
    protected long notifications;

    public Semaphore(int n) {
        this.notifications = n;
    }

    public synchronized void acquire() {
        while (true) {
            if (this.notifications > 0L) {
                --this.notifications;
                return;
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized boolean acquire(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l;
        while (true) {
            if (this.notifications > 0L) {
                --this.notifications;
                return true;
            }
            if (l3 < 0L) {
                return false;
            }
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {}
            l3 = l2 + l - System.currentTimeMillis();
        }
    }

    public synchronized void release() {
        ++this.notifications;
        this.notifyAll();
    }

    public String toString() {
        return "Semaphore(" + this.notifications + ")";
    }
}

