/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.framework.launcher.Launcher;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.startlevel.StartLevel;

public class FrameworkCommandProvider
implements CommandProvider {
    private OSGi osgi;
    private BundleContext context;
    private StartLevelManager slImpl;
    private ConditionalPermissionAdmin condPermAdmin;
    private PermissionAdmin permAdmin;
    private String tab = "\t";
    private String newline = "\r\n";
    static /* synthetic */ Class class$0;

    public FrameworkCommandProvider(OSGi oSGi) {
        this.osgi = oSGi;
        this.context = oSGi.getBundleContext();
        this.slImpl = oSGi.framework.startLevelManager;
        this.condPermAdmin = oSGi.framework.condPermAdmin;
        this.permAdmin = oSGi.framework.permissionAdmin;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.context.registerService(clazz.getName(), (Object)this, hashtable);
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(this.newline);
        stringBuffer.append(ConsoleMsg.CONSOLE_HELP_VALID_COMMANDS_HEADER);
        stringBuffer.append(this.newline);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_CONTROLLING_FRAMEWORK_HEADER, stringBuffer);
        this.addCommand("launch", ConsoleMsg.CONSOLE_HELP_LAUNCH_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("shutdown", ConsoleMsg.CONSOLE_HELP_SHUTDOWN_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("close", ConsoleMsg.CONSOLE_HELP_CLOSE_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("exit", ConsoleMsg.CONSOLE_HELP_EXIT_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("gc", ConsoleMsg.CONSOLE_HELP_GC_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("init", ConsoleMsg.CONSOLE_HELP_INIT_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("setprop", ConsoleMsg.CONSOLE_HELP_KEYVALUE_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SETPROP_COMMAND_DESCRIPTION, stringBuffer);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_CONTROLLING_BUNDLES_HEADER, stringBuffer);
        this.addCommand("install", ConsoleMsg.CONSOLE_HELP_INSTALL_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("uninstall", ConsoleMsg.CONSOLE_HELP_UNINSTALL_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("start", ConsoleMsg.CONSOLE_HELP_START_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("stop", ConsoleMsg.CONSOLE_HELP_STOP_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("refresh", ConsoleMsg.CONSOLE_HELP_REFRESH_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("update", ConsoleMsg.CONSOLE_HELP_UPDATE_COMMAND_DESCRIPTION, stringBuffer);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_DISPLAYING_STATUS_HEADER, stringBuffer);
        this.addCommand("status", ConsoleMsg.CONSOLE_HELP_STATUS_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("ss", ConsoleMsg.CONSOLE_HELP_SS_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("services", ConsoleMsg.CONSOLE_HELP_FILTER_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_SERVICES_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("packages", ConsoleMsg.CONSOLE_HELP_PACKAGES_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_PACKAGES_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("bundles", ConsoleMsg.CONSOLE_HELP_BUNDLES_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("bundle", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_BUNDLE_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("headers", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_HEADERS_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("log", ConsoleMsg.CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_LOG_COMMAND_DESCRIPTION, stringBuffer);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_EXTRAS_HEADER, stringBuffer);
        this.addCommand("exec", ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_EXEC_COMMAND_DESCRIPTION, stringBuffer);
        this.addCommand("fork", ConsoleMsg.CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION, ConsoleMsg.CONSOLE_HELP_FORK_COMMAND_DESCRIPTION, stringBuffer);
        this.addHeader(ConsoleMsg.STARTLEVEL_HELP_HEADING, stringBuffer);
        this.addCommand("sl", ConsoleMsg.CONSOLE_HELP_OPTIONAL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SL, stringBuffer);
        this.addCommand("setfwsl", ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETFWSL, stringBuffer);
        this.addCommand("setbsl", ConsoleMsg.STARTLEVEL_IDLOCATION_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETBSL, stringBuffer);
        this.addCommand("setibsl", ConsoleMsg.STARTLEVEL_ARGUMENT_DESCRIPTION, ConsoleMsg.STARTLEVEL_HELP_SETIBSL, stringBuffer);
        this.addHeader(ConsoleMsg.CONSOLE_HELP_PROFILE_HEADING, stringBuffer);
        this.addCommand("profilelog", ConsoleMsg.CONSOLE_HELP_PROFILELOG_DESCRIPTION, stringBuffer);
        return stringBuffer.toString();
    }

    private void addHeader(String string, StringBuffer stringBuffer) {
        stringBuffer.append("---");
        stringBuffer.append(string);
        stringBuffer.append("---");
        stringBuffer.append(this.newline);
    }

    private void addCommand(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(this.tab);
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(this.newline);
    }

    private void addCommand(String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(this.tab);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" - ");
        stringBuffer.append(string3);
        stringBuffer.append(this.newline);
    }

    public void _exit(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println();
        System.exit(0);
    }

    public void _launch(CommandInterpreter commandInterpreter) throws Exception {
        this.osgi.launch();
    }

    public void _shutdown(CommandInterpreter commandInterpreter) throws Exception {
        this.osgi.shutdown();
    }

    public void _sta(CommandInterpreter commandInterpreter) throws Exception {
        this._start(commandInterpreter);
    }

    public void _start(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.start();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _sto(CommandInterpreter commandInterpreter) throws Exception {
        this._stop(commandInterpreter);
    }

    public void _stop(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.stop();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _i(CommandInterpreter commandInterpreter) throws Exception {
        this._install(commandInterpreter);
    }

    public void _install(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NOTHING_TO_INSTALL_ERROR);
        } else {
            String string2;
            AbstractBundle abstractBundle = (AbstractBundle)this.context.installBundle(string);
            commandInterpreter.print(ConsoleMsg.CONSOLE_BUNDLE_ID_MESSAGE);
            commandInterpreter.println(new Long(abstractBundle.getBundleId()));
            String string3 = commandInterpreter.nextArgument();
            if (string3 != null && Launcher.matchCommand("start", string2 = string3.toLowerCase(), 1)) {
                abstractBundle.start();
            }
        }
    }

    public void _up(CommandInterpreter commandInterpreter) throws Exception {
        this._update(commandInterpreter);
    }

    public void _update(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            Object object;
            if ("*".equals(string)) {
                object = (AbstractBundle[])this.context.getBundles();
                int n = ((AbstractBundle[])object).length;
                if (n > 0) {
                    int n2 = 0;
                    while (n2 < n) {
                        Object object2 = object[n2];
                        if (((AbstractBundle)object2).getBundleId() != 0L) {
                            try {
                                ((AbstractBundle)object2).update();
                            }
                            catch (BundleException bundleException) {
                                commandInterpreter.printStackTrace(bundleException);
                            }
                        }
                        ++n2;
                    }
                } else {
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
                }
            } else {
                object = this.getBundleFromToken(commandInterpreter, string, true);
                if (object != null) {
                    String string2 = commandInterpreter.nextArgument();
                    try {
                        if (string2 != null) {
                            ((AbstractBundle)object).update(new URL(string2).openStream());
                        }
                        ((AbstractBundle)object).update();
                    }
                    catch (BundleException bundleException) {
                        commandInterpreter.printStackTrace(bundleException);
                    }
                }
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _un(CommandInterpreter commandInterpreter) throws Exception {
        this._uninstall(commandInterpreter);
    }

    public void _uninstall(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                abstractBundle.uninstall();
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _s(CommandInterpreter commandInterpreter) throws Exception {
        this._status(commandInterpreter);
    }

    public void _status(CommandInterpreter commandInterpreter) throws Exception {
        if (this.osgi.isActive()) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        commandInterpreter.println();
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        commandInterpreter.print(ConsoleMsg.CONSOLE_ID);
        commandInterpreter.print(this.tab);
        commandInterpreter.println(ConsoleMsg.CONSOLE_BUNDLE_LOCATION_MESSAGE);
        commandInterpreter.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER);
        int n2 = 0;
        while (n2 < n) {
            AbstractBundle abstractBundle = abstractBundleArray[n2];
            commandInterpreter.print(new Long(abstractBundle.getBundleId()));
            commandInterpreter.print(this.tab);
            commandInterpreter.println(abstractBundle.getLocation());
            commandInterpreter.print("  ");
            commandInterpreter.print(this.getStateName(abstractBundle.getState()));
            commandInterpreter.println(abstractBundle.bundledata);
            ++n2;
        }
        ServiceReference[] serviceReferenceArray = this.context.getServiceReferences(null, null);
        if (serviceReferenceArray != null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
            n = serviceReferenceArray.length;
            int n3 = 0;
            while (n3 < n) {
                commandInterpreter.println(serviceReferenceArray[n3]);
                ++n3;
            }
        }
    }

    public void _se(CommandInterpreter commandInterpreter) throws Exception {
        this._services(commandInterpreter);
    }

    public void _services(CommandInterpreter commandInterpreter) throws Exception {
        int n;
        ServiceReference[] serviceReferenceArray;
        String string = null;
        String string2 = commandInterpreter.nextArgument();
        if (string2 != null) {
            serviceReferenceArray = new StringBuffer();
            while (string2 != null) {
                serviceReferenceArray.append(' ');
                serviceReferenceArray.append(string2);
                string2 = commandInterpreter.nextArgument();
            }
            string = serviceReferenceArray.toString();
        }
        if ((serviceReferenceArray = this.context.getServiceReferences(null, string)) != null && (n = serviceReferenceArray.length) > 0) {
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                commandInterpreter.println(serviceReference);
                commandInterpreter.print("  ");
                commandInterpreter.print(ConsoleMsg.CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE);
                commandInterpreter.print(" ");
                commandInterpreter.println(serviceReference.getBundle());
                AbstractBundle[] abstractBundleArray = (AbstractBundle[])serviceReference.getUsingBundles();
                if (abstractBundleArray != null) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_BUNDLES_USING_SERVICE_MESSAGE);
                    int n3 = 0;
                    while (n3 < abstractBundleArray.length) {
                        commandInterpreter.print("    ");
                        commandInterpreter.println(abstractBundleArray[n3]);
                        ++n3;
                    }
                } else {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE);
                }
                ++n2;
            }
            return;
        }
        commandInterpreter.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
    }

    public void _p(CommandInterpreter commandInterpreter) throws Exception {
        this._packages(commandInterpreter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _packages(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference serviceReference;
        AbstractBundle abstractBundle = null;
        String string = commandInterpreter.nextArgument();
        if (string != null) {
            abstractBundle = this.getBundleFromToken(commandInterpreter, string, false);
        }
        if ((serviceReference = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin")) == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
        if (packageAdmin == null) return;
        try {
            ExportedPackage[] exportedPackageArray = null;
            if (string != null && abstractBundle == null) {
                ExportedPackage exportedPackage = packageAdmin.getExportedPackage(string);
                if (exportedPackage != null) {
                    exportedPackageArray = new ExportedPackage[]{exportedPackage};
                }
            } else {
                exportedPackageArray = packageAdmin.getExportedPackages(abstractBundle);
            }
            if (exportedPackageArray == null) {
                commandInterpreter.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
            } else {
                int n = 0;
                while (n < exportedPackageArray.length) {
                    Bundle bundle;
                    ExportedPackage exportedPackage = exportedPackageArray[n];
                    commandInterpreter.print(exportedPackage);
                    boolean bl = exportedPackage.isRemovalPending();
                    if (bl) {
                        commandInterpreter.print("(");
                        commandInterpreter.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                        commandInterpreter.println(")");
                    }
                    if ((bundle = exportedPackage.getExportingBundle()) != null) {
                        commandInterpreter.print("<");
                        commandInterpreter.print(bundle);
                        commandInterpreter.println(">");
                        Bundle[] bundleArray = exportedPackage.getImportingBundles();
                        int n2 = 0;
                        while (n2 < bundleArray.length) {
                            commandInterpreter.print("  ");
                            commandInterpreter.print(bundleArray[n2]);
                            commandInterpreter.print(" ");
                            commandInterpreter.println(ConsoleMsg.CONSOLE_IMPORTS_MESSAGE);
                            ++n2;
                        }
                    } else {
                        commandInterpreter.print("<");
                        commandInterpreter.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                        commandInterpreter.println(">");
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var13_16 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    public void _bundles(CommandInterpreter commandInterpreter) throws Exception {
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Object object;
            AbstractBundle abstractBundle = abstractBundleArray[n2];
            long l = abstractBundle.getBundleId();
            commandInterpreter.println(abstractBundle);
            commandInterpreter.print("  ");
            commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(l)));
            commandInterpreter.print(", ");
            commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(abstractBundle.getState())));
            if (l != 0L) {
                object = this.osgi.framework.getDataFile(abstractBundle, "");
                String string = object == null ? null : ((File)object).getAbsolutePath();
                commandInterpreter.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, string));
            } else {
                commandInterpreter.println();
            }
            object = abstractBundle.getRegisteredServices();
            if (object != null) {
                commandInterpreter.print("  ");
                commandInterpreter.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    commandInterpreter.print("    ");
                    commandInterpreter.println(object[n3]);
                    ++n3;
                }
            } else {
                commandInterpreter.print("  ");
                commandInterpreter.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
            }
            object = abstractBundle.getServicesInUse();
            if (object != null) {
                commandInterpreter.print("  ");
                commandInterpreter.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                int n4 = 0;
                while (n4 < ((Object)object).length) {
                    commandInterpreter.print("    ");
                    commandInterpreter.println(object[n4]);
                    ++n4;
                }
            } else {
                commandInterpreter.print("  ");
                commandInterpreter.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
            }
            ++n2;
        }
    }

    public void _b(CommandInterpreter commandInterpreter) throws Exception {
        this._bundle(commandInterpreter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _bundle(CommandInterpreter var1_1) throws Exception {
        var2_2 = var1_1.nextArgument();
        if (var2_2 == null) {
            var1_1.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (true) {
            block50: {
                block49: {
                    block51: {
                        if (var2_2 == null) {
                            return;
                        }
                        var3_3 = this.getBundleFromToken(var1_1, var2_2, true);
                        if (var3_3 == null) break block50;
                        var4_4 = var3_3.getBundleId();
                        var1_1.println(var3_3);
                        var1_1.print("  ");
                        var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_ID_MESSAGE, String.valueOf(var4_4)));
                        var1_1.print(", ");
                        var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_STATUS_MESSAGE, this.getStateName(var3_3.getState())));
                        if (var4_4 != 0L) {
                            var6_5 = this.osgi.framework.getDataFile(var3_3, "");
                            var7_6 = var6_5 == null ? null : var6_5.getAbsolutePath();
                            var1_1.print(NLS.bind(ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, var7_6));
                            var1_1.println();
                        } else {
                            var1_1.println();
                        }
                        var6_5 = var3_3.getRegisteredServices();
                        if (var6_5 != null) {
                            var1_1.print("  ");
                            var1_1.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                            var7_7 = 0;
                            while (var7_7 < ((Object)var6_5).length) {
                                var1_1.print("    ");
                                var1_1.println(var6_5[var7_7]);
                                ++var7_7;
                            }
                        } else {
                            var1_1.print("  ");
                            var1_1.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                        }
                        var6_5 = var3_3.getServicesInUse();
                        if (var6_5 != null) {
                            var1_1.print("  ");
                            var1_1.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                            var7_9 = 0;
                            while (var7_9 < ((Object)var6_5).length) {
                                var1_1.print("    ");
                                var1_1.println(var6_5[var7_9]);
                                ++var7_9;
                            }
                        } else {
                            var1_1.print("  ");
                            var1_1.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                        }
                        var7_6 = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                        if (var7_6 == null) break block51;
                        var8_10 = (PackageAdmin)this.context.getService((ServiceReference)var7_6);
                        if (var8_10 == null) break block49;
                        try {
                            block53: {
                                block47: {
                                    block48: {
                                        block52: {
                                            var9_11 /* !! */  = var8_10.getExportedPackages((Bundle)null);
                                            if (var9_11 /* !! */  != null) break block52;
                                            var1_1.print("  ");
                                            var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                                            var1_1.print("  ");
                                            var1_1.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                                            ** GOTO lbl-1000
                                        }
                                        var10_12 = true;
                                        var11_14 = 0;
                                        while (true) {
                                            if (var11_14 >= var9_11 /* !! */ .length) {
                                                if (var10_12) {
                                                    var1_1.print("  ");
                                                    var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                                                }
                                                break;
                                            }
                                            var12_15 = var9_11 /* !! */ [var11_14];
                                            if (var12_15.getExportingBundle() == var3_3) {
                                                if (var10_12) {
                                                    var1_1.print("  ");
                                                    var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_PACKAGES_MESSAGE);
                                                    var10_12 = false;
                                                }
                                                var1_1.print("    ");
                                                var1_1.print(var12_15);
                                                if (var12_15.isRemovalPending()) {
                                                    var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE);
                                                } else {
                                                    var1_1.println(ConsoleMsg.CONSOLE_EXPORTED_MESSAGE);
                                                }
                                            }
                                            ++var11_14;
                                        }
                                        var10_12 = true;
                                        var11_14 = 0;
                                        while (true) {
                                            if (var11_14 >= var9_11 /* !! */ .length) {
                                                if (var10_12) {
                                                    var1_1.print("  ");
                                                    var1_1.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                                                }
                                                var1_1.print("  ");
                                                if ((var8_10.getBundleType(var3_3) & 1) <= 0) break block47;
                                                var11_13 = var8_10.getHosts(var3_3);
                                                if (var11_13 != null) {
                                                    var1_1.println(ConsoleMsg.CONSOLE_HOST_MESSAGE);
                                                    var12_16 = 0;
                                                    break;
                                                }
                                                break block48;
                                            }
                                            var12_15 = var9_11 /* !! */ [var11_14];
                                            var13_20 = var12_15.getImportingBundles();
                                            var14_22 = 0;
                                            while (var14_22 < var13_20.length) {
                                                if (var13_20[var14_22] == var3_3) {
                                                    if (var10_12) {
                                                        var1_1.print("  ");
                                                        var1_1.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                                                        var10_12 = false;
                                                    }
                                                    var1_1.print("    ");
                                                    var1_1.print(var12_15);
                                                    var15_24 = var12_15.getExportingBundle();
                                                    if (var15_24 != null) {
                                                        var1_1.print("<");
                                                        var1_1.print(var15_24);
                                                        var1_1.println(">");
                                                        break;
                                                    }
                                                    var1_1.print("<");
                                                    var1_1.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                                                    var1_1.println(">");
                                                    break;
                                                }
                                                ++var14_22;
                                            }
                                            ++var11_14;
                                        }
                                        while (var12_16 < var11_13.length) {
                                            var1_1.print("    ");
                                            var1_1.println(var11_13[var12_16]);
                                            ++var12_16;
                                        }
                                        break block53;
                                    }
                                    var1_1.println(ConsoleMsg.CONSOLE_NO_HOST_MESSAGE);
                                    break block53;
                                }
                                var11_13 = var8_10.getFragments(var3_3);
                                if (var11_13 != null) {
                                    var1_1.println(ConsoleMsg.CONSOLE_FRAGMENT_MESSAGE);
                                    var12_17 = 0;
                                    while (var12_17 < var11_13.length) {
                                        var1_1.print("    ");
                                        var1_1.println(var11_13[var12_17]);
                                        ++var12_17;
                                    }
                                } else {
                                    var1_1.println(ConsoleMsg.CONSOLE_NO_FRAGMENT_MESSAGE);
                                }
                            }
                            var11_13 = var8_10.getRequiredBundles(null);
                            var12_15 = null;
                            if (var11_13 != null) {
                                var13_21 = 0;
                                while (var13_21 < var11_13.length) {
                                    if (var11_13[var13_21].getBundle() == var3_3) {
                                        var12_15 = var11_13[var13_21];
                                        break;
                                    }
                                    ++var13_21;
                                }
                            }
                            if (var12_15 == null) {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                            } else {
                                var1_1.print("  ");
                                var1_1.println(ConsoleMsg.CONSOLE_NAMED_CLASS_SPACE_MESSAGE);
                                var1_1.print("    ");
                                var1_1.print(var12_15);
                                if (var12_15.isRemovalPending()) {
                                    var1_1.println(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                                } else {
                                    var1_1.println(ConsoleMsg.CONSOLE_PROVIDED_MESSAGE);
                                }
                            }
                            var10_12 = true;
                            var13_19 = 0;
                            while (true) {
                                block54: {
                                    if (var13_19 < var11_13.length) break block54;
                                    if (var10_12) {
                                        var1_1.print("  ");
                                        var1_1.println(ConsoleMsg.CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE);
                                    }
                                    break;
                                }
                                if (var11_13[var13_19] != var12_15 && (var14_23 = var11_13[var13_19].getRequiringBundles()) != null) {
                                    var15_25 = 0;
                                    while (var15_25 < var14_23.length) {
                                        if (var14_23[var15_25] == var3_3) {
                                            if (var10_12) {
                                                var1_1.print("  ");
                                                var1_1.println(ConsoleMsg.CONSOLE_REQUIRED_BUNDLES_MESSAGE);
                                                var10_12 = false;
                                            }
                                            var1_1.print("    ");
                                            var1_1.print(var11_13[var13_19]);
                                            var16_26 = var11_13[var13_19].getBundle();
                                            var1_1.print("<");
                                            var1_1.print(var16_26);
                                            var1_1.println(">");
                                        }
                                        ++var15_25;
                                    }
                                }
                                ++var13_19;
                            }
                        }
                        catch (Throwable var18_28) {
                            var17_27 = null;
                            this.context.ungetService((ServiceReference)var7_6);
                            throw var18_28;
                        }
lbl-1000:
                        // 2 sources

                        {
                            var17_27 = null;
                            this.context.ungetService((ServiceReference)var7_6);
                            break block49;
                        }
                    }
                    var1_1.print("  ");
                    var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
                }
                if ((var8_10 = System.getSecurityManager()) != null) {
                    var9_11 /* !! */  = var3_3.getProtectionDomain();
                    var1_1.println(var9_11 /* !! */ );
                }
            }
            var2_2 = var1_1.nextArgument();
        }
    }

    public void _l(CommandInterpreter commandInterpreter) throws Exception {
        this._log(commandInterpreter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _log(CommandInterpreter commandInterpreter) throws Exception {
        Object object;
        Object object2;
        long l = -1L;
        String string = commandInterpreter.nextArgument();
        if (string != null) {
            object2 = this.getBundleFromToken(commandInterpreter, string, false);
            if (object2 == null) {
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            } else {
                l = ((AbstractBundle)object2).getBundleId();
            }
        }
        if ((object2 = this.context.getServiceReference("org.osgi.service.log.LogReaderService")) != null && (object = this.context.getService((ServiceReference)object2)) != null) {
            try {
                Object[] objectArray;
                Enumeration enumeration = (Enumeration)object.getClass().getMethod("getLog", null).invoke(object, null);
                ArrayList arrayList = new ArrayList();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        objectArray = arrayList.toArray();
                        if (objectArray.length != 0) break;
                        Object var22_9 = null;
                        this.context.ungetService((ServiceReference)object2);
                        return;
                    }
                    arrayList.add(0, enumeration.nextElement());
                }
                Class<?> clazz = objectArray[0].getClass();
                Method method = clazz.getMethod("getBundle", null);
                Method method2 = clazz.getMethod("getLevel", null);
                Method method3 = clazz.getMethod("getMessage", null);
                Method method4 = clazz.getMethod("getServiceReference", null);
                Method method5 = clazz.getMethod("getException", null);
                int n = 0;
                while (n < objectArray.length) {
                    Object object3 = objectArray[n];
                    AbstractBundle abstractBundle = (AbstractBundle)method.invoke(object3, null);
                    if (l == -1L || abstractBundle != null && l == abstractBundle.getBundleId()) {
                        Integer n2 = (Integer)method2.invoke(object3, null);
                        switch (n2) {
                            case 4: {
                                commandInterpreter.print(">");
                                commandInterpreter.print(ConsoleMsg.CONSOLE_DEBUG_MESSAGE);
                                commandInterpreter.print(" ");
                                break;
                            }
                            case 3: {
                                commandInterpreter.print(">");
                                commandInterpreter.print(ConsoleMsg.CONSOLE_INFO_MESSAGE);
                                commandInterpreter.print(" ");
                                break;
                            }
                            case 2: {
                                commandInterpreter.print(">");
                                commandInterpreter.print(ConsoleMsg.CONSOLE_WARNING_MESSAGE);
                                commandInterpreter.print(" ");
                                break;
                            }
                            case 1: {
                                commandInterpreter.print(">");
                                commandInterpreter.print(ConsoleMsg.CONSOLE_ERROR_MESSAGE);
                                commandInterpreter.print(" ");
                                break;
                            }
                            default: {
                                commandInterpreter.print(">");
                                commandInterpreter.print(n2);
                                commandInterpreter.print(" ");
                            }
                        }
                        if (abstractBundle != null) {
                            commandInterpreter.print("[");
                            commandInterpreter.print(new Long(abstractBundle.getBundleId()));
                            commandInterpreter.print("] ");
                        }
                        commandInterpreter.print(method3.invoke(object3, null));
                        commandInterpreter.print(" ");
                        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)method4.invoke(object3, null);
                        if (serviceReferenceImpl != null) {
                            commandInterpreter.print("{");
                            commandInterpreter.print("service.id");
                            commandInterpreter.print("=");
                            commandInterpreter.print(serviceReferenceImpl.getProperty("service.id").toString());
                            commandInterpreter.println("}");
                        } else if (abstractBundle != null) {
                            commandInterpreter.println(abstractBundle.getLocation());
                        } else {
                            commandInterpreter.println();
                        }
                        Throwable throwable = (Throwable)method5.invoke(object3, null);
                        if (throwable != null) {
                            commandInterpreter.printStackTrace(throwable);
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var22_10 = null;
                this.context.ungetService((ServiceReference)object2);
                throw throwable;
            }
            Object var22_11 = null;
            this.context.ungetService((ServiceReference)object2);
            return;
        }
        commandInterpreter.println(ConsoleMsg.CONSOLE_LOGSERVICE_NOT_REGISTERED_MESSAGE);
    }

    public void _gc(CommandInterpreter commandInterpreter) throws Exception {
        long l = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long l2 = Runtime.getRuntime().freeMemory();
        commandInterpreter.print(ConsoleMsg.CONSOLE_TOTAL_MEMORY_MESSAGE);
        commandInterpreter.println(String.valueOf(Runtime.getRuntime().totalMemory()));
        commandInterpreter.print(ConsoleMsg.CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l));
        commandInterpreter.print(ConsoleMsg.CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l2));
        commandInterpreter.print(ConsoleMsg.CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE);
        commandInterpreter.println(String.valueOf(l2 - l));
    }

    public void _init(CommandInterpreter commandInterpreter) throws Exception {
        if (this.osgi.isActive()) {
            commandInterpreter.print(this.newline);
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE);
            return;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        int n = abstractBundleArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = abstractBundleArray[n2];
                if (abstractBundle.getBundleId() != 0L) {
                    try {
                        abstractBundle.uninstall();
                    }
                    catch (BundleException bundleException) {
                        commandInterpreter.printStackTrace(bundleException);
                    }
                }
                ++n2;
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        }
        if (this.permAdmin != null) {
            this.permAdmin.setDefaultPermissions(null);
            String[] stringArray = this.permAdmin.getLocations();
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    this.permAdmin.setPermissions(stringArray[n3], null);
                    ++n3;
                }
            }
        }
        if (this.condPermAdmin != null) {
            Enumeration enumeration = this.condPermAdmin.getConditionalPermissionInfos();
            while (enumeration.hasMoreElements()) {
                ((ConditionalPermissionInfo)enumeration.nextElement()).delete();
            }
        }
    }

    public void _close(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println();
        this.osgi.close();
        System.exit(0);
    }

    public void _r(CommandInterpreter commandInterpreter) throws Exception {
        this._refresh(commandInterpreter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _refresh(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference serviceReference = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (serviceReference == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_CAN_NOT_REFRESH_NO_PACKAGE_ADMIN_ERROR);
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
        if (packageAdmin == null) return;
        try {
            Object[] objectArray = null;
            String string = commandInterpreter.nextArgument();
            if (string != null) {
                int n;
                Vector<AbstractBundle> vector = new Vector<AbstractBundle>();
                while (true) {
                    if (string == null) {
                        n = vector.size();
                        if (n != 0) break;
                        commandInterpreter.println(ConsoleMsg.CONSOLE_INVALID_BUNDLE_SPECIFICATION_ERROR);
                        Object var8_9 = null;
                        this.context.ungetService(serviceReference);
                        return;
                    }
                    AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
                    if (abstractBundle != null) {
                        vector.addElement(abstractBundle);
                    }
                    string = commandInterpreter.nextArgument();
                }
                objectArray = new AbstractBundle[n];
                vector.copyInto(objectArray);
            }
            packageAdmin.refreshPackages((Bundle[])objectArray);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        Object var8_11 = null;
        this.context.ungetService(serviceReference);
    }

    public void _exec(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process process = Runtime.getRuntime().exec(string);
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, string, String.valueOf(process)));
        int n = process.waitFor();
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_EXECUTED_RESULT_CODE_MESSAGE, string, String.valueOf(n)));
    }

    public void _fork(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process process = Runtime.getRuntime().exec(string);
        commandInterpreter.println(NLS.bind(ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, string, String.valueOf(process)));
    }

    public void _h(CommandInterpreter commandInterpreter) throws Exception {
        this._headers(commandInterpreter);
    }

    public void _headers(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
        }
        while (string != null) {
            AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
            if (abstractBundle != null) {
                commandInterpreter.printDictionary(abstractBundle.getHeaders(), ConsoleMsg.CONSOLE_BUNDLE_HEADERS_TITLE);
            }
            string = commandInterpreter.nextArgument();
        }
    }

    public void _pr(CommandInterpreter commandInterpreter) throws Exception {
        this._props(commandInterpreter);
    }

    public void _props(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.printDictionary(FrameworkProperties.getProperties(), ConsoleMsg.CONSOLE_SYSTEM_PROPERTIES_TITLE);
    }

    public void _setp(CommandInterpreter commandInterpreter) throws Exception {
        this._setprop(commandInterpreter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _setprop(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE);
            this._props(commandInterpreter);
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            try {
                Properties properties = FrameworkProperties.getProperties();
                Properties properties2 = new Properties();
                properties2.load(byteArrayInputStream);
                commandInterpreter.println(ConsoleMsg.CONSOLE_SETTING_PROPERTIES_TITLE);
                Enumeration<?> enumeration = properties2.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)properties2.get(string2);
                    properties.put(string2, string3);
                    commandInterpreter.println(String.valueOf(this.tab) + string2 + " = " + string3);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                ((InputStream)byteArrayInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((InputStream)byteArrayInputStream).close();
    }

    public void _ss(CommandInterpreter commandInterpreter) throws Exception {
        if (this.osgi.isActive()) {
            commandInterpreter.println();
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            commandInterpreter.println();
            commandInterpreter.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.context.getBundles();
        if (abstractBundleArray.length == 0) {
            commandInterpreter.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        } else {
            commandInterpreter.print(this.newline);
            commandInterpreter.print(ConsoleMsg.CONSOLE_ID);
            commandInterpreter.print(this.tab);
            commandInterpreter.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_TITLE);
            int n = 0;
            while (n < abstractBundleArray.length) {
                int n2;
                Object[] objectArray;
                AbstractBundle abstractBundle = abstractBundleArray[n];
                String string = abstractBundle.getSymbolicName();
                string = string == null || string.length() == 0 ? abstractBundle.toString() : String.valueOf(string) + "_" + abstractBundle.getVersion();
                commandInterpreter.println(String.valueOf(abstractBundle.getBundleId()) + "\t" + this.getStateName(abstractBundle.getState()) + string);
                if (abstractBundle.isFragment()) {
                    objectArray = abstractBundle.getHosts();
                    if (objectArray != null) {
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            commandInterpreter.println("\t            Master=" + ((BundleLoaderProxy)objectArray[n2]).getBundleHost().getBundleId());
                            ++n2;
                        }
                    }
                } else {
                    objectArray = abstractBundle.getFragments();
                    if (objectArray != null) {
                        commandInterpreter.print("\t            Fragments=");
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            AbstractBundle abstractBundle2 = (AbstractBundle)objectArray[n2];
                            commandInterpreter.print(String.valueOf(n2 > 0 ? ", " : "") + abstractBundle2.getBundleId());
                            ++n2;
                        }
                        commandInterpreter.println();
                    }
                }
                ++n;
            }
        }
    }

    public void _t(CommandInterpreter commandInterpreter) throws Exception {
        this._threads(commandInterpreter);
    }

    public void _threads(CommandInterpreter commandInterpreter) throws Exception {
        Object[] objectArray = this.getThreadGroups();
        Util.sort(objectArray);
        Object object = this.getTopThreadGroup();
        Object[] objectArray2 = new Thread[((ThreadGroup)object).activeCount()];
        int n = ((ThreadGroup)object).enumerate((Thread[])objectArray2, true);
        Util.sort(objectArray2);
        StringBuffer stringBuffer = new StringBuffer(120);
        commandInterpreter.println();
        commandInterpreter.println(ConsoleMsg.CONSOLE_THREADGROUP_TITLE);
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2];
            int n3 = ((ThreadGroup)object).activeCount();
            int n4 = ((ThreadGroup)object).enumerate(new Thread[n3], false);
            ThreadGroup threadGroup = ((ThreadGroup)object).getParent();
            String string = threadGroup == null ? "-none-" : threadGroup.getName();
            stringBuffer.setLength(0);
            stringBuffer.append(Util.toString(this.simpleClassName(object), 18)).append(" ").append(Util.toString(((ThreadGroup)object).getName(), 21)).append(" ").append(Util.toString(string, 16)).append(Util.toString(new Integer(((ThreadGroup)object).getMaxPriority()), 3)).append(Util.toString(new Integer(n4), 4)).append("/").append(Util.toString(String.valueOf(n3), 6));
            commandInterpreter.println(stringBuffer.toString());
            ++n2;
        }
        commandInterpreter.print(this.newline);
        commandInterpreter.println(ConsoleMsg.CONSOLE_THREADTYPE_TITLE);
        n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray2[n2];
            if (object2 != null) {
                stringBuffer.setLength(0);
                stringBuffer.append(Util.toString(this.simpleClassName(object2), 18)).append(" ").append(Util.toString(((Thread)object2).getName(), 21)).append(" ").append(Util.toString(((Thread)object2).getThreadGroup().getName(), 16)).append(Util.toString(new Integer(((Thread)object2).getPriority()), 3));
                if (((Thread)object2).isDaemon()) {
                    stringBuffer.append(" [daemon]");
                }
                commandInterpreter.println(stringBuffer.toString());
            }
            ++n2;
        }
    }

    public void _sl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            AbstractBundle abstractBundle = null;
            String string = commandInterpreter.nextArgument();
            int n = 0;
            if (string != null && (abstractBundle = this.getBundleFromToken(commandInterpreter, string, true)) == null) {
                return;
            }
            if (abstractBundle == null) {
                n = this.slImpl.getStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.slImpl.getBundleStartLevel(abstractBundle);
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(abstractBundle.getBundleId()), new Integer(n)));
            }
        }
    }

    public void _setfwsl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            int n = 0;
            String string = commandInterpreter.nextArgument();
            if (string == null) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                n = this.slImpl.getStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.getStartLevelFromToken(commandInterpreter, string);
                if (n > 0) {
                    try {
                        this.slImpl.setStartLevel(n);
                        commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, String.valueOf(n)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        commandInterpreter.println(illegalArgumentException.getMessage());
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _setbsl(CommandInterpreter var1_1) throws Exception {
        block5: {
            if (!this.isStartLevelSvcPresent(var1_1)) break block5;
            var3_2 = null;
            var2_3 = var1_1.nextArgument();
            if (var2_3 == null) {
                var1_1.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
                return;
            }
            var4_4 = this.getStartLevelFromToken(var1_1, var2_3);
            var2_3 = var1_1.nextArgument();
            if (var2_3 != null) ** GOTO lbl21
            var1_1.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
            return;
lbl-1000:
            // 1 sources

            {
                var3_2 = this.getBundleFromToken(var1_1, var2_3, true);
                if (var3_2 != null) {
                    try {
                        this.slImpl.setBundleStartLevel(var3_2, var4_4);
                        var1_1.println(NLS.bind(ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, new Long(var3_2.getBundleId()), new Integer(var4_4)));
                    }
                    catch (IllegalArgumentException var5_5) {
                        var1_1.println(var5_5.getMessage());
                    }
                }
                var2_3 = var1_1.nextArgument();
lbl21:
                // 2 sources

                ** while (var2_3 != null)
            }
        }
    }

    public void _setibsl(CommandInterpreter commandInterpreter) throws Exception {
        if (this.isStartLevelSvcPresent(commandInterpreter)) {
            int n = 0;
            String string = commandInterpreter.nextArgument();
            if (string == null) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_GIVEN);
                n = this.slImpl.getInitialBundleStartLevel();
                commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(n)));
            } else {
                n = this.getStartLevelFromToken(commandInterpreter, string);
                if (n > 0) {
                    try {
                        this.slImpl.setInitialBundleStartLevel(n);
                        commandInterpreter.println(NLS.bind(ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, String.valueOf(n)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        commandInterpreter.println(illegalArgumentException.getMessage());
                    }
                }
            }
        }
    }

    public void _requiredBundles(CommandInterpreter commandInterpreter) {
        this._classSpaces(commandInterpreter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _classSpaces(CommandInterpreter var1_1) {
        var2_2 = var1_1.nextArgument();
        var3_3 = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (var3_3 == null) {
            var1_1.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            return;
        }
        var4_4 = (PackageAdmin)this.context.getService(var3_3);
        if (var4_4 == null) return;
        try {
            block10: {
                var5_5 = null;
                var5_5 = var4_4.getRequiredBundles(var2_2);
                if (var5_5 != null) break block10;
                var1_1.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                ** GOTO lbl-1000
            }
            var6_6 = 0;
            while (var6_6 < var5_5.length) {
                var7_7 = var5_5[var6_6];
                var1_1.print(var7_7);
                var8_8 = var7_7.isRemovalPending();
                if (var8_8) {
                    var1_1.print("(");
                    var1_1.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                    var1_1.println(")");
                }
                if ((var9_9 = var7_7.getBundle()) != null) {
                    var1_1.print("<");
                    var1_1.print(var9_9);
                    var1_1.println(">");
                    var10_10 = var7_7.getRequiringBundles();
                    if (var10_10 != null) {
                        var11_11 = 0;
                        while (var11_11 < var10_10.length) {
                            var1_1.print("  ");
                            var1_1.print(var10_10[var11_11]);
                            var1_1.print(" ");
                            var1_1.println(ConsoleMsg.CONSOLE_REQUIRES_MESSAGE);
                            ++var11_11;
                        }
                    }
                } else {
                    var1_1.print("<");
                    var1_1.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                    var1_1.println(">");
                }
                ++var6_6;
            }
        }
        catch (Throwable var13_12) {
            var12_13 = null;
            this.context.ungetService(var3_3);
            throw var13_12;
        }
lbl-1000:
        // 2 sources

        {
            var12_14 = null;
            this.context.ungetService(var3_3);
            return;
        }
    }

    public void _profilelog(CommandInterpreter commandInterpreter) throws Exception {
        commandInterpreter.println(Profile.getProfileLog());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _getPackages(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            return;
        }
        AbstractBundle abstractBundle = this.getBundleFromToken(commandInterpreter, string, true);
        ServiceReference serviceReference = this.context.getServiceReference("org.eclipse.osgi.service.resolver.PlatformAdmin");
        if (serviceReference == null) {
            return;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
        try {
            ExportPackageDescription[] exportPackageDescriptionArray = platformAdmin.getStateHelper().getVisiblePackages(abstractBundle.getBundleDescription());
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                commandInterpreter.println(exportPackageDescriptionArray[n] + ": " + platformAdmin.getStateHelper().getAccessCode(abstractBundle.getBundleDescription(), exportPackageDescriptionArray[n]));
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.context.ungetService(serviceReference);
        }
    }

    protected boolean isStartLevelSvcPresent(CommandInterpreter commandInterpreter) {
        boolean bl = false;
        ServiceReference serviceReference = this.context.getServiceReference("org.osgi.service.startlevel.StartLevel");
        if (serviceReference != null) {
            StartLevel startLevel = (StartLevel)this.context.getService(serviceReference);
            if (startLevel != null) {
                bl = true;
            }
        } else {
            commandInterpreter.println(ConsoleMsg.CONSOLE_CAN_NOT_USE_STARTLEVEL_NO_STARTLEVEL_SVC_ERROR);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractBundle getBundleFromToken(CommandInterpreter var1_1, String var2_2, boolean var3_3) {
        block8: {
            var4_4 = null;
            try {
                var5_5 = Long.parseLong(var2_2);
                var4_4 = (AbstractBundle)this.context.getBundle(var5_5);
                break block8;
            }
            catch (NumberFormatException v0) {
                var5_6 = var2_2;
                var6_7 = null;
                var7_8 = var2_2.indexOf("@");
                if (var7_8 != -1 && var7_8 + 1 != var2_2.length()) {
                    try {
                        var6_7 = Version.parseVersion(var2_2.substring(var7_8 + 1, var2_2.length()));
                        var5_6 = var2_2.substring(0, var7_8);
                    }
                    catch (IllegalArgumentException v1) {}
                }
                var8_9 = this.context.getBundles();
                var9_10 = 0;
                var10_11 = var8_9.length;
                ** while (var9_10 < var10_11)
            }
lbl-1000:
            // 1 sources

            {
                var11_12 = (AbstractBundle)var8_9[var9_10];
                if (var5_6.equals(var11_12.getSymbolicName()) && (var6_7 == null || var6_7.equals(var11_12.getVersion())) || var2_2.equals(var11_12.getLocation())) {
                    var4_4 = var11_12;
                    break;
                }
                ++var9_10;
                continue;
            }
        }
        if (var4_4 == null && var3_3) {
            var1_1.println(NLS.bind(ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, var2_2));
        }
        return var4_4;
    }

    protected int getStartLevelFromToken(CommandInterpreter commandInterpreter, String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
            if (Integer.parseInt(string) <= 0) {
                commandInterpreter.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            commandInterpreter.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
        }
        return n;
    }

    protected String getStateName(int n) {
        switch (n) {
            case 1: {
                return ConsoleMsg.CONSOLE_UNINSTALLED_MESSAGE;
            }
            case 2: {
                return ConsoleMsg.CONSOLE_INSTALLED_MESSAGE;
            }
            case 4: {
                return ConsoleMsg.CONSOLE_RESOLVED_MESSAGE;
            }
            case 8: {
                return ConsoleMsg.CONSOLE_STARTING_MESSAGE;
            }
            case 16: {
                return ConsoleMsg.CONSOLE_STOPPING_MESSAGE;
            }
            case 32: {
                return ConsoleMsg.CONSOLE_ACTIVE_MESSAGE;
            }
        }
        return Integer.toHexString(n);
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] threadGroupArray;
        ThreadGroup threadGroup = this.getTopThreadGroup();
        int n = threadGroup.enumerate(threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount()], true);
        if (n == threadGroupArray.length) {
            return threadGroupArray;
        }
        ThreadGroup[] threadGroupArray2 = new ThreadGroup[n];
        System.arraycopy(threadGroupArray, 0, threadGroupArray2, 0, n);
        return threadGroupArray2;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
        }
        return threadGroup;
    }

    public String simpleClassName(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.getClass().getName(), ".");
        int n = stringTokenizer.countTokens();
        int n2 = 1;
        while (n2 < n) {
            stringTokenizer.nextToken();
            ++n2;
        }
        return stringTokenizer.nextToken();
    }
}

