/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;

public class ServiceUse {
    protected ServiceFactory factory;
    protected Object service;
    protected BundleContextImpl context;
    protected ServiceRegistrationImpl registration;
    protected int useCount;

    protected ServiceUse(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl serviceRegistrationImpl) {
        this.context = bundleContextImpl;
        this.registration = serviceRegistrationImpl;
        this.useCount = 0;
        Object object = serviceRegistrationImpl.service;
        if (object instanceof ServiceFactory) {
            this.factory = (ServiceFactory)object;
            this.service = null;
        } else {
            this.factory = null;
            this.service = object;
        }
    }

    protected Object getService() {
        if (this.useCount == 0 && this.factory != null) {
            Object t;
            BundleHost bundleHost = this.registration.context.bundle;
            try {
                t = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ServiceUse.this.factory.getService(ServiceUse.this.context.bundle, ServiceUse.this.registration);
                    }
                });
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() exception: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.context.framework.adaptor.handleRuntimeError(throwable);
                BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), throwable);
                this.context.framework.publishFrameworkEvent(2, bundleHost, bundleException);
                return null;
            }
            if (t == null) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() returned null.");
                }
                BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()));
                this.context.framework.publishFrameworkEvent(2, bundleHost, bundleException);
                return null;
            }
            String[] stringArray = this.registration.clazzes;
            String string = BundleContextImpl.checkServiceClass(stringArray, t);
            if (string != null) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("Service object is not an instanceof " + string);
                }
                throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, string));
            }
            this.service = t;
        }
        ++this.useCount;
        return this.service;
    }

    protected boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount == 0) {
            if (this.factory != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ServiceUse.this.factory.ungetService(ServiceUse.this.context.bundle, ServiceUse.this.registration, ServiceUse.this.service);
                            return null;
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(this.factory + ".ungetService() exception");
                        Debug.printStackTrace(throwable);
                    }
                    BundleHost bundleHost = this.registration.context.bundle;
                    BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), throwable);
                    this.context.framework.publishFrameworkEvent(2, bundleHost, bundleException);
                }
                this.service = null;
            }
            return true;
        }
        return false;
    }

    protected void releaseService() {
        if (this.useCount > 0 && this.factory != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ServiceUse.this.factory.ungetService(ServiceUse.this.context.bundle, ServiceUse.this.registration, ServiceUse.this.service);
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".ungetService() exception");
                    Debug.printStackTrace(throwable);
                }
                BundleHost bundleHost = this.registration.context.bundle;
                BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), throwable);
                this.context.framework.publishFrameworkEvent(2, bundleHost, bundleException);
            }
            this.service = null;
        }
        this.useCount = 0;
    }
}

