/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.BundleException;

public class SystemBundleLoader
extends BundleLoader {
    public static final String EQUINOX_EE = "x-equinox-ee";
    ClassLoader classLoader;
    private HashSet eePackages;

    protected SystemBundleLoader(BundleHost bundleHost, BundleLoaderProxy bundleLoaderProxy) throws BundleException {
        super(bundleHost, bundleLoaderProxy);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleLoaderProxy.getBundleDescription().getSelectedExports();
        if (exportPackageDescriptionArray != null && exportPackageDescriptionArray.length > 0) {
            this.eePackages = new HashSet(exportPackageDescriptionArray.length);
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                if ((Integer)exportPackageDescriptionArray[n].getDirective(EQUINOX_EE) >= 0) {
                    this.eePackages.add(exportPackageDescriptionArray[n].getName());
                }
                ++n;
            }
        }
        this.classLoader = this.getClass().getClassLoader();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.classLoader.loadClass(string);
    }

    public String findLibrary(String string) {
        return null;
    }

    Class findLocalClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return clazz;
    }

    URL findLocalResource(String string) {
        return this.classLoader.getResource(string);
    }

    Enumeration findLocalResources(String string) {
        try {
            return this.classLoader.getResources(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL findResource(String string) {
        return this.classLoader.getResource(string);
    }

    public Enumeration findResources(String string) throws IOException {
        return this.classLoader.getResources(string);
    }

    protected void close() {
    }

    public boolean isEEPackage(String string) {
        return this.eePackages.contains(string);
    }
}

