/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public abstract class ResolverConstraint {
    ResolverBundle bundle;
    VersionConstraint constraint;

    ResolverConstraint(ResolverBundle resolverBundle, VersionConstraint versionConstraint) {
        this.bundle = resolverBundle;
        this.constraint = versionConstraint;
    }

    ResolverBundle getBundle() {
        return this.bundle;
    }

    BundleDescription getBundleDescription() {
        return this.bundle.getBundle();
    }

    boolean isFromFragment() {
        return this.constraint.getBundle().getHost() != null;
    }

    boolean isSatisfiedBy(VersionSupplier versionSupplier) {
        if (!this.bundle.getResolver().getPermissionChecker().checkPermission(this.constraint, versionSupplier.getBaseDescription())) {
            return false;
        }
        return this.constraint.isSatisfiedBy(versionSupplier.getBaseDescription());
    }

    VersionConstraint getVersionConstraint() {
        return this.constraint;
    }

    public String getName() {
        return this.constraint.getName();
    }

    public String toString() {
        return this.constraint.toString();
    }

    abstract boolean isOptional();
}

