/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map attributes;

    public Map getDirectives() {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        if (this.resolution != null) {
            hashMap.put("resolution", this.resolution);
        }
        return hashMap;
    }

    public Object getDirective(String string) {
        if (string.equals("resolution")) {
            return this.resolution;
        }
        return null;
    }

    public Object setDirective(String string, Object object) {
        if (string.equals("resolution")) {
            this.resolution = (String)object;
            return this.resolution;
        }
        return null;
    }

    public void setDirectives(Map map) {
        if (map == null) {
            return;
        }
        this.resolution = (String)map.get("resolution");
    }

    public String getBundleSymbolicName() {
        return this.symbolicName;
    }

    public VersionRange getBundleVersionRange() {
        if (this.bundleVersionRange == null) {
            return VersionRange.emptyRange;
        }
        return this.bundleVersionRange;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        String[] stringArray;
        String string;
        boolean bl;
        if (!(baseDescription instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = (ExportPackageDescriptionImpl)baseDescription;
        String[] stringArray2 = (String[])exportPackageDescriptionImpl.getDirective("x-friends");
        Boolean bl2 = (Boolean)exportPackageDescriptionImpl.getDirective("x-internal");
        if ((bl2.booleanValue() || stringArray2 != null) && (bl = ((StateImpl)this.getBundle().getContainingState()).inStrictMode())) {
            if (bl2.booleanValue()) {
                return false;
            }
            boolean bl3 = false;
            if (stringArray2 != null && this.getBundle().getSymbolicName() != null) {
                int n = 0;
                while (n < stringArray2.length) {
                    if (this.getBundle().getSymbolicName().equals(stringArray2[n])) {
                        bl3 = true;
                    }
                    ++n;
                }
            }
            if (!bl3) {
                return false;
            }
        }
        if (this.symbolicName != null) {
            BundleDescription bundleDescription = exportPackageDescriptionImpl.getExporter();
            if (!this.symbolicName.equals(bundleDescription.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(bundleDescription.getVersion())) {
                return false;
            }
        }
        if (!("*".equals(string = this.getName()) || string.endsWith(".*") && exportPackageDescriptionImpl.getName().startsWith(string.substring(0, string.length() - 1)) || exportPackageDescriptionImpl.getName().equals(string))) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(exportPackageDescriptionImpl.getVersion())) {
            return false;
        }
        Map map = this.getAttributes();
        if (map != null) {
            Map map2 = exportPackageDescriptionImpl.getAttributes();
            if (map2 == null) {
                return false;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object v = map.get(string2);
                Object v2 = map2.get(string2);
                if (v2 != null && v.equals(v2)) continue;
                return false;
            }
        }
        if ((stringArray = (String[])exportPackageDescriptionImpl.getDirective("mandatory")) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if ("bundle-symbolic-name".equals(stringArray[n])) {
                    if (this.symbolicName == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(stringArray[n])) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(stringArray[n]) || "version".equals(stringArray[n])) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (map == null) {
                        return false;
                    }
                    if (map.get(stringArray[n]) == null) {
                        return false;
                    }
                }
                ++n;
            }
        }
        if (((BundleDescriptionImpl)this.getBundle()).getEquinoxEE() < 0) {
            return true;
        }
        int n = (Integer)exportPackageDescriptionImpl.getDirective("x-equinox-ee");
        return n < 0 || n == ((BundleDescriptionImpl)this.getBundle()).getEquinoxEE();
    }

    protected void setBundleSymbolicName(String string) {
        this.symbolicName = string;
    }

    protected void setBundleVersionRange(VersionRange versionRange) {
        this.bundleVersionRange = versionRange;
    }

    protected void setAttributes(Map map) {
        this.attributes = map;
    }

    public String toString() {
        return "Import-Package: " + this.getName() + "; version=\"" + this.getVersionRange() + "\"";
    }
}

