/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class VersionedIdentifier {
    private String identifier = "";
    private int major = 0;
    private int minor = 0;
    private int service = 0;
    private String qualifier = "";
    private String version;
    private static final String VER_SEPARATOR = ".";
    public static final int LESS_THAN = -1;
    public static final int EQUAL = 0;
    public static final int EQUIVALENT = 1;
    public static final int COMPATIBLE = 2;
    public static final int GREATER_THAN = 3;

    public VersionedIdentifier(String string, String string2) {
        this.identifier = string;
        this.version = string2;
        this.parseVersion(string2);
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equalIdentifiers(VersionedIdentifier versionedIdentifier) {
        if (versionedIdentifier == null) {
            return this.identifier == null;
        }
        return versionedIdentifier.identifier.equals(this.identifier);
    }

    public int compareVersion(VersionedIdentifier versionedIdentifier) {
        if (versionedIdentifier == null) {
            if (this.major == 0 && this.minor == 0 && this.service == 0) {
                return -1;
            }
            return 1;
        }
        if (this.major > versionedIdentifier.major) {
            return 3;
        }
        if (this.major < versionedIdentifier.major) {
            return -1;
        }
        if (this.minor > versionedIdentifier.minor) {
            return 2;
        }
        if (this.minor < versionedIdentifier.minor) {
            return -1;
        }
        if (this.service > versionedIdentifier.service) {
            return 1;
        }
        if (this.service < versionedIdentifier.service) {
            return -1;
        }
        return this.compareQualifiers(this.qualifier, versionedIdentifier.qualifier);
    }

    private int compareQualifiers(String string, String string2) {
        int n = string.compareTo(string2);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    private void parseVersion(String string) {
        if (string == null || (string = string.trim()).equals("")) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, VER_SEPARATOR);
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() >= 1) {
                this.major = new Integer((String)arrayList.get(0));
            }
            if (arrayList.size() >= 2) {
                this.minor = new Integer((String)arrayList.get(1));
            }
            if (arrayList.size() >= 3) {
                this.service = new Integer((String)arrayList.get(2));
            }
            if (arrayList.size() >= 4) {
                this.qualifier = this.removeWhiteSpace((String)arrayList.get(3));
            }
        }
        catch (Exception exception) {}
    }

    private String removeWhiteSpace(String string) {
        char[] cArray = string.trim().toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (Character.isWhitespace(cArray[n])) {
                cArray[n] = 95;
                bl = true;
            }
            ++n;
        }
        return bl ? new String(cArray) : string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VersionedIdentifier)) {
            return false;
        }
        VersionedIdentifier versionedIdentifier = (VersionedIdentifier)object;
        return this.equalIdentifiers(versionedIdentifier) && this.major == versionedIdentifier.major && this.minor == versionedIdentifier.minor && this.service == versionedIdentifier.service && this.version.equals(versionedIdentifier.version) && this.compareQualifiers(this.qualifier, versionedIdentifier.qualifier) == 0;
    }

    public int hashCode() {
        return (String.valueOf(this.identifier) + "_" + this.version).hashCode();
    }

    public String toString() {
        return String.valueOf(this.identifier) + "_" + this.version;
    }
}

