/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BufferedRandomInputStream
extends InputStream {
    private RandomAccessFile inputFile;
    private String filePath;
    private int buffer_size;
    private int buffer_pos;
    private long buffer_start = 0L;
    private long file_pointer;
    private byte[] buffer;

    public BufferedRandomInputStream(File file) throws IOException {
        this(file, 2048);
    }

    public BufferedRandomInputStream(File file, int n) throws IOException {
        this.filePath = file.getCanonicalPath();
        this.inputFile = new RandomAccessFile(file, "r");
        this.buffer = new byte[n];
        this.file_pointer = 0L;
        this.resetBuffer();
    }

    private void resetBuffer() {
        this.buffer_pos = 0;
        this.buffer_size = 0;
        this.buffer_start = 0L;
    }

    private int fillBuffer() throws IOException {
        this.buffer_pos = 0;
        this.buffer_start = this.file_pointer;
        this.buffer_size = this.inputFile.read(this.buffer, 0, this.buffer.length);
        this.file_pointer += (long)this.buffer_size;
        return this.buffer_size;
    }

    public int read() throws IOException {
        if (this.buffer_pos >= this.buffer_size && this.fillBuffer() <= 0) {
            return -1;
        }
        return this.buffer[this.buffer_pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buffer_size - this.buffer_pos;
        if (n3 < 0) {
            return -1;
        }
        if (n2 <= n3) {
            System.arraycopy(this.buffer, this.buffer_pos, byArray, n, n2);
            this.buffer_pos += n2;
            return n2;
        }
        System.arraycopy(this.buffer, this.buffer_pos, byArray, n, n3);
        if (this.fillBuffer() <= 0) {
            return n3;
        }
        return n3 + this.read(byArray, n + n3, n2 - n3);
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.buffer_size - this.buffer_pos;
        if (l <= (long)n) {
            this.buffer_pos = (int)((long)this.buffer_pos + l);
            return l;
        }
        this.resetBuffer();
        int n2 = this.inputFile.skipBytes((int)(l - (long)n));
        this.file_pointer += (long)n2;
        return n + n2;
    }

    public int available() throws IOException {
        return this.buffer_size - this.buffer_pos;
    }

    public void close() throws IOException {
        this.inputFile.close();
        this.inputFile = null;
        this.buffer = null;
    }

    public String toString() {
        return this.filePath;
    }

    public void seek(long l) throws IOException {
        if (l >= this.buffer_start && l < this.buffer_start + (long)this.buffer_size) {
            this.buffer_pos = (int)(l - this.buffer_start);
        } else {
            this.inputFile.seek(l);
            this.file_pointer = l;
            this.resetBuffer();
        }
    }

    public long length() throws IOException {
        return this.inputFile.length();
    }
}

