/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.JobActivator;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class JobOSGiUtils {
    private ServiceTracker debugTracker = null;
    private ServiceTracker bundleTracker = null;
    private static final JobOSGiUtils singleton = new JobOSGiUtils();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static JobOSGiUtils getDefault() {
        return singleton;
    }

    private JobOSGiUtils() {
    }

    void openServices() {
        BundleContext bundleContext = JobActivator.getContext();
        if (bundleContext == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("JobsOSGiUtils called before plugin started");
            }
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.debugTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundleTracker = new ServiceTracker(bundleContext, clazz2.getName(), null);
        this.bundleTracker.open();
    }

    void closeServices() {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }

    public boolean getBooleanDebugOption(String string, boolean bl) {
        String string2;
        if (this.debugTracker == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("Debug tracker is not set");
            }
            return bl;
        }
        DebugOptions debugOptions = (DebugOptions)this.debugTracker.getService();
        if (debugOptions != null && (string2 = debugOptions.getOption(string)) != null) {
            return string2.equalsIgnoreCase("true");
        }
        return bl;
    }

    public String getBundleId(Object object) {
        if (this.bundleTracker == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("Bundle tracker is not set");
            }
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (object == null) {
            return null;
        }
        if (packageAdmin == null) {
            return null;
        }
        Bundle bundle = packageAdmin.getBundle(object.getClass());
        if (bundle != null && bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName();
        }
        return null;
    }
}

