/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Util {
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static final void assertInstance(Object object, Class clazz) {
        Util.assertInstance(object, clazz, false);
    }

    private static final void assertInstance(Object object, Class clazz, boolean bl) {
        if (object == null && bl) {
            return;
        }
        if (object == null || clazz == null) {
            throw new NullPointerException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean bl, boolean bl2) {
        return !bl ? (bl2 ? -1 : 0) : 1;
    }

    public static final int compare(int n, int n2) {
        return n - n2;
    }

    public static final int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return -1;
        }
        if (comparable2 == null) {
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static final int compare(Comparable[] comparableArray, Comparable[] comparableArray2) {
        if (comparableArray == null && comparableArray2 == null) {
            return 0;
        }
        if (comparableArray == null) {
            return -1;
        }
        if (comparableArray2 == null) {
            return 1;
        }
        int n = comparableArray.length;
        int n2 = comparableArray2.length;
        if (n != n2) {
            return n - n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = Util.compare(comparableArray[n3], comparableArray2[n3]);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static final int compare(List list, List list2) {
        int n;
        if (list == null && list2 == null) {
            return 0;
        }
        if (list == null) {
            return -1;
        }
        if (list2 == null) {
            return 1;
        }
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return n2 - n;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Util.compare((Comparable)list.get(n3), (Comparable)list2.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static final boolean endsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n2 - n3 - 1], objectArray2[n - n3 - 1])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.equals(object2);
    }

    public static final boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            boolean bl;
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            boolean bl2 = object == null ? object2 == null : (bl = object.equals(object2));
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final int hashCode(int n) {
        return n;
    }

    public static final int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static final int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 89;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object != null) {
                n = n * 31 + object.hashCode();
            }
            ++n2;
        }
        return n;
    }

    public static final boolean startsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n3], objectArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final String translateString(ResourceBundle resourceBundle, String string, String string2) {
        if (resourceBundle != null && string != null) {
            try {
                String string3 = resourceBundle.getString(string);
                if (string3 != null) {
                    return string3;
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    private Util() {
    }
}

