/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.StringPool;

public abstract class ImmutableMap
implements Cloneable {
    public static final ImmutableMap EMPTY = new EmptyMap();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    public abstract String get(String var1);

    protected static ImmutableMap createMap(int n) {
        if (n <= 0) {
            return EMPTY;
        }
        return new ArrayMap(n);
    }

    protected abstract void internalPut(String var1, String var2);

    public abstract String[] keys();

    public abstract ImmutableMap put(String var1, String var2);

    public abstract ImmutableMap removeKey(String var1);

    public void shareStrings(StringPool stringPool) {
    }

    public abstract int size();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.keys();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringBuffer.append(stringArray[n]).append(" -> ").append(this.get(stringArray[n])).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    static class ArrayMap
    extends ImmutableMap {
        private static final float LOAD_FACTOR = 0.45f;
        private int elementSize = 0;
        private String[] keyTable;
        private int threshold;
        private String[] valueTable;

        private ArrayMap() {
            this(16);
        }

        ArrayMap(int n) {
            int n2 = 1;
            while (n2 < n) {
                n2 *= 2;
            }
            this.keyTable = new String[n2];
            this.valueTable = new String[n2];
            this.threshold = (int)((float)n2 * 0.45f);
        }

        public String get(String string) {
            String string2;
            int n = this.keyTable.length - 1;
            int n2 = string.hashCode() & n;
            while ((string2 = this.keyTable[n2]) != null) {
                if (string2.equals(string)) {
                    return this.valueTable[n2];
                }
                n2 = n2 + 1 & n;
            }
            return null;
        }

        protected void internalPut(String string, String string2) {
            String string3;
            int n = this.keyTable.length - 1;
            int n2 = string.hashCode() & n;
            while ((string3 = this.keyTable[n2]) != null) {
                if (string3.equals(string)) {
                    this.valueTable[n2] = string2;
                    return;
                }
                n2 = n2 + 1 & n;
            }
            this.keyTable[n2] = string;
            this.valueTable[n2] = string2;
            ++this.elementSize;
        }

        public String[] keys() {
            if (this.elementSize == 0) {
                return EMPTY_STRING_ARRAY;
            }
            String[] stringArray = new String[this.elementSize];
            int n = 0;
            int n2 = 0;
            while (n2 < this.keyTable.length) {
                if (this.keyTable[n2] != null) {
                    stringArray[n++] = this.keyTable[n2];
                }
                ++n2;
            }
            return stringArray;
        }

        public ImmutableMap put(String string, String string2) {
            ArrayMap arrayMap;
            int n = this.keyTable.length;
            if (this.elementSize + 1 > this.threshold) {
                arrayMap = new ArrayMap(n * 2);
                int n2 = n;
                while (--n2 >= 0) {
                    String string3 = this.keyTable[n2];
                    if (string3 == null) continue;
                    arrayMap.internalPut(string3, this.valueTable[n2]);
                }
            } else {
                arrayMap = new ArrayMap(n);
                System.arraycopy(this.keyTable, 0, arrayMap.keyTable, 0, this.keyTable.length);
                System.arraycopy(this.valueTable, 0, arrayMap.valueTable, 0, this.valueTable.length);
                arrayMap.elementSize = this.elementSize;
            }
            arrayMap.internalPut(string, string2);
            return arrayMap;
        }

        public ImmutableMap removeKey(String string) {
            String string2;
            int n = this.keyTable.length - 1;
            int n2 = string.hashCode() & n;
            while ((string2 = this.keyTable[n2]) != null) {
                if (string2.equals(string)) {
                    if (this.elementSize <= 1) {
                        return EMPTY;
                    }
                    ImmutableMap immutableMap = ArrayMap.createMap((int)((float)this.elementSize / 0.45f));
                    int n3 = 0;
                    while (n3 < n2) {
                        string2 = this.keyTable[n3];
                        if (string2 != null) {
                            immutableMap.internalPut(string2, this.valueTable[n3]);
                        }
                        ++n3;
                    }
                    n3 = n2 + 1;
                    while (n3 <= n) {
                        string2 = this.keyTable[n3];
                        if (string2 != null) {
                            immutableMap.internalPut(string2, this.valueTable[n3]);
                        }
                        ++n3;
                    }
                    return immutableMap;
                }
                n2 = n2 + 1 & n;
            }
            return this;
        }

        public void shareStrings(StringPool stringPool) {
            String string;
            String[] stringArray = this.keyTable;
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string != null) {
                    stringArray[n] = stringPool.add(string);
                }
                ++n;
            }
            stringArray = this.valueTable;
            if (stringArray == null) {
                return;
            }
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string != null) {
                    stringArray[n] = stringPool.add(string);
                }
                ++n;
            }
        }

        public int size() {
            return this.elementSize;
        }
    }

    static class EmptyMap
    extends ImmutableMap {
        EmptyMap() {
        }

        public String get(String string) {
            return null;
        }

        public ImmutableMap removeKey(String string) {
            return this;
        }

        protected void internalPut(String string, String string2) {
            throw new IllegalStateException();
        }

        public String[] keys() {
            return EMPTY_STRING_ARRAY;
        }

        public ImmutableMap put(String string, String string2) {
            ImmutableMap immutableMap = EmptyMap.createMap(4);
            immutableMap.internalPut(string, string2);
            return immutableMap;
        }

        public int size() {
            return 0;
        }
    }
}

