/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.StartLevelImpl;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class EclipseLazyStarter
implements ClassLoadingStatsHook,
AdaptorHook,
HookConfigurator {
    private static final boolean throwErrorOnFailedStart = "true".equals(FrameworkProperties.getProperty("osgi.compatibility.errorOnFailedStart", "true"));
    private static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private StartLevelImpl startLevelService;
    private ServiceReference slRef;
    private BaseAdaptor adaptor;
    private ThreadLocal activationStack = new ThreadLocal();
    private final Map errors = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$0;

    public void preFindLocalClass(String string, ClasspathManager classpathManager) throws ClassNotFoundException {
        int n;
        AbstractBundle abstractBundle = (AbstractBundle)classpathManager.getBaseData().getBundle();
        if ((abstractBundle.getState() & 0x31) != 0) {
            return;
        }
        EclipseStorageHook eclipseStorageHook = (EclipseStorageHook)classpathManager.getBaseData().getStorageHook(EclipseStorageHook.KEY);
        if (!this.shouldActivateFor(string, classpathManager.getBaseData(), eclipseStorageHook, classpathManager)) {
            return;
        }
        ArrayList<Object> arrayList = (ArrayList<Object>)this.activationStack.get();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(6);
            this.activationStack.set(arrayList);
        }
        if ((n = arrayList.size()) > 1) {
            int n2 = n - 1;
            while (n2 >= 1) {
                if (classpathManager == arrayList.get(n2)) {
                    return;
                }
                --n2;
            }
        }
        Thread thread = abstractBundle.getStateChanging();
        if (abstractBundle.getState() == 8 && thread == Thread.currentThread()) {
            return;
        }
        if (n == 0) {
            arrayList.add(string);
        }
        arrayList.add(classpathManager);
    }

    public void postFindLocalClass(String string, Class clazz, ClasspathManager classpathManager) throws ClassNotFoundException {
        ArrayList arrayList = (ArrayList)this.activationStack.get();
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        if (n <= 1 || arrayList.get(0) != string) {
            return;
        }
        ClasspathManager[] classpathManagerArray = null;
        classpathManagerArray = new ClasspathManager[n - 1];
        int n2 = 1;
        while (n2 < n) {
            classpathManagerArray[n2 - 1] = (ClasspathManager)arrayList.get(n2);
            ++n2;
        }
        arrayList.clear();
        if (clazz == null) {
            return;
        }
        n2 = classpathManagerArray.length - 1;
        while (n2 >= 0) {
            if (this.errors.get(classpathManagerArray[n2]) != null) {
                if (throwErrorOnFailedStart) {
                    throw (TerminatingClassNotFoundException)this.errors.get(classpathManagerArray[n2]);
                }
            } else {
                AbstractBundle abstractBundle = (AbstractBundle)classpathManagerArray[n2].getBaseData().getBundle();
                try {
                    secureAction.start(abstractBundle, 1);
                }
                catch (BundleException bundleException) {
                    Object object;
                    Object object2;
                    Throwable throwable = bundleException.getCause();
                    if (throwable != null && throwable instanceof StatusException && ((object2 = (StatusException)((Object)throwable)).getStatusCode() & 8) == 0) {
                        if (object2.getStatus() instanceof Thread) {
                            object = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread(), string, object2.getStatus(), abstractBundle, new Integer(5000)});
                            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, (String)object, 0, bundleException, null));
                        }
                    }
                    object2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ACTIVATION, abstractBundle.getSymbolicName(), Long.toString(abstractBundle.getBundleId()));
                    object = new TerminatingClassNotFoundException((String)object2, bundleException);
                    this.errors.put(classpathManagerArray[n2], object);
                    if (throwErrorOnFailedStart) {
                        this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, (String)object2, 0, bundleException, null));
                        throw object;
                    }
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, abstractBundle, new BundleException((String)object2, bundleException));
                }
            }
            --n2;
        }
    }

    public void preFindLocalResource(String string, ClasspathManager classpathManager) {
    }

    public void postFindLocalResource(String string, URL uRL, ClasspathManager classpathManager) {
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    private boolean shouldActivateFor(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook, ClasspathManager classpathManager) throws ClassNotFoundException {
        if (!this.isLazyStartable(string, baseData, eclipseStorageHook)) {
            return false;
        }
        if (baseData.getBundle().getState() == 4) {
            Object object;
            if (throwErrorOnFailedStart && (object = (TerminatingClassNotFoundException)this.errors.get(classpathManager)) != null) {
                throw object;
            }
            object = this.startLevelService;
            return object != null && ((StartLevelImpl)object).getStartLevel() == baseData.getStartLevel() && ((StartLevelImpl)object).isSettingStartLevel();
        }
        return true;
    }

    private boolean isLazyStartable(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook) {
        if (eclipseStorageHook == null) {
            return false;
        }
        boolean bl = eclipseStorageHook.isLazyStart();
        String[] stringArray = eclipseStorageHook.getLazyStartExcludes();
        String[] stringArray2 = eclipseStorageHook.getLazyStartIncludes();
        if (stringArray == null && stringArray2 == null) {
            return bl;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return bl;
        }
        String string2 = string.substring(0, n);
        if (bl) {
            return !(stringArray2 != null && !this.contains(stringArray2, string2) || stringArray != null && this.contains(stringArray, string2));
        }
        return stringArray != null && this.contains(stringArray, string2);
    }

    private boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingStatsHook(this);
        hookRegistry.addAdaptorHook(this);
    }

    public void addProperties(Properties properties) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.slRef = bundleContext.getServiceReference(clazz.getName());
        if (this.slRef != null) {
            this.startLevelService = (StartLevelImpl)bundleContext.getService(this.slRef);
        }
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.slRef != null) {
            bundleContext.ungetService(this.slRef);
            this.startLevelService = null;
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
        if (!Debug.DEBUG_ENABLED) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = this.adaptor.getState().getResolvedBundles();
        StateHelper stateHelper = this.adaptor.getPlatformAdmin().getStateHelper();
        Object[][] objectArray = stateHelper.sortBundles(bundleDescriptionArray);
        this.logCycles(objectArray);
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public boolean matchDNChain(String string, String[] stringArray) {
        return false;
    }

    private void logCycles(Object[][] objectArray) {
        if (objectArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                int n2 = 0;
                while (n2 < objectArray[n].length) {
                    stringBuffer.append(((BundleDescription)objectArray[n][n2]).getSymbolicName());
                    stringBuffer.append(',');
                    ++n2;
                }
                stringBuffer.insert(stringBuffer.length() - 1, ']');
                ++n;
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
            String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND, stringBuffer);
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, string, 0, null, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
        }
    }

    private static class TerminatingClassNotFoundException
    extends ClassNotFoundException
    implements StatusException {
        private static final long serialVersionUID = -6730732895632169173L;
        private Object cause;

        public TerminatingClassNotFoundException(String string, Throwable throwable) {
            super(string, throwable);
            this.cause = throwable;
        }

        public Object getStatus() {
            return this.cause;
        }

        public int getStatusCode() {
            return 8;
        }
    }
}

