/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.PackageAdminImpl$GetBundleAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> arrayList = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] exportPackageDescriptionArray = this.framework.adaptor.getState().getExportedPackages();
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ExportedPackageImpl exportedPackageImpl;
                if (exportPackageDescriptionArray[n].isRoot() && (exportedPackageImpl = this.createExportedPackage(exportPackageDescriptionArray[n])) != null && (bundle == null || exportedPackageImpl.supplier.getBundle() == bundle)) {
                    arrayList.add(exportedPackageImpl);
                }
                ++n;
            }
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription exportPackageDescription) {
        BundleDescription bundleDescription = exportPackageDescription.getExporter();
        if (bundleDescription == null || bundleDescription.getHost() != null) {
            return null;
        }
        BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
        if (bundleLoaderProxy == null) {
            BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescription.getBundleId());
            if (bundleHost == null) {
                return null;
            }
            bundleLoaderProxy = bundleHost.getLoaderProxy();
        }
        return new ExportedPackageImpl(exportPackageDescription, bundleLoaderProxy);
    }

    public ExportedPackage getExportedPackage(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ExportedPackage exportedPackage = null;
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                if (exportedPackage == null) {
                    exportedPackage = exportedPackageArray[n];
                } else {
                    Version version = Version.parseVersion(exportedPackage.getSpecificationVersion());
                    Version version2 = Version.parseVersion(exportedPackageArray[n].getSpecificationVersion());
                    if (version2.compareTo(version) >= 0) {
                        exportedPackage = exportedPackageArray[n];
                    }
                }
            }
            ++n;
        }
        return exportedPackage;
    }

    public ExportedPackage[] getExportedPackages(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ArrayList<ExportedPackage> arrayList = new ArrayList<ExportedPackage>(1);
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                arrayList.add(exportedPackageArray[n]);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] bundleArray) {
        Bundle[] bundleArray2;
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] abstractBundleArray = null;
        if (bundleArray != null) {
            bundleArray2 = bundleArray;
            // MONITORENTER : bundleArray
            abstractBundleArray = new AbstractBundle[bundleArray.length];
            System.arraycopy(bundleArray, 0, abstractBundleArray, 0, bundleArray.length);
            // MONITOREXIT : bundleArray2
        }
        bundleArray2 = abstractBundleArray;
        Thread thread = this.framework.secureAction.createThread(new Runnable((AbstractBundle[])bundleArray2){
            private final /* synthetic */ AbstractBundle[] val$bundles;
            {
                this.val$bundles = abstractBundleArray;
            }

            public void run() {
                PackageAdminImpl.this.doResolveBundles(this.val$bundles, true);
            }
        }, "Refresh Packages");
        thread.start();
    }

    public boolean resolveBundles(Bundle[] bundleArray) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundleArray == null) {
            bundleArray = this.framework.getAllBundles();
        }
        int n = 0;
        while (n < bundleArray.length) {
            if (!((AbstractBundle)bundleArray[n]).isResolved()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void doResolveBundles(AbstractBundle[] abstractBundleArray, boolean bl) {
        block26: {
            block23: {
                block24: {
                    try {
                        try {
                            AbstractBundle[] abstractBundleArray2;
                            block25: {
                                int n;
                                AbstractBundle[] abstractBundleArray3;
                                Object object;
                                BundleDescription[] bundleDescriptionArray;
                                block28: {
                                    if (Profile.STARTUP) {
                                        Profile.logEnter("resolve bundles");
                                    }
                                    this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                                    abstractBundleArray2 = null;
                                    bundleDescriptionArray = null;
                                    object = this.framework.bundles;
                                    synchronized (object) {
                                        int n2;
                                        block27: {
                                            int n3 = n2 = abstractBundleArray == null ? 0 : abstractBundleArray.length;
                                            if (bl) break block27;
                                            bundleDescriptionArray = new BundleDescription[]{};
                                            break block28;
                                        }
                                        if (n2 <= 0) break block28;
                                        abstractBundleArray3 = new ArrayList(n2);
                                        n = 0;
                                        while (true) {
                                            AbstractBundle[] abstractBundleArray4;
                                            block29: {
                                                if (n < n2) break block29;
                                            }
                                            BundleDescription bundleDescription = abstractBundleArray[n].getBundleDescription();
                                            if (bundleDescription != null && bundleDescription.getBundleId() != 0L && !abstractBundleArray3.contains(bundleDescription)) {
                                                abstractBundleArray3.add(bundleDescription);
                                            }
                                            if ((abstractBundleArray4 = this.framework.bundles.getBundles(abstractBundleArray[n].getSymbolicName())) != null && abstractBundleArray4.length > 1) {
                                                int n4 = 0;
                                                while (n4 < abstractBundleArray4.length) {
                                                    BundleDescription bundleDescription2;
                                                    if (abstractBundleArray4[n4] != abstractBundleArray[n] && (bundleDescription2 = abstractBundleArray4[n4].getBundleDescription()) != null && bundleDescription2.getBundleId() != 0L && !abstractBundleArray3.contains(bundleDescription2)) {
                                                        abstractBundleArray3.add(bundleDescription2);
                                                    }
                                                    ++n4;
                                                }
                                            }
                                            ++n;
                                        }
                                        bundleDescriptionArray = abstractBundleArray3.size() == 0 ? null : abstractBundleArray3.toArray(new BundleDescription[abstractBundleArray3.size()]);
                                    }
                                }
                                object = this.framework.adaptor.getState();
                                BundleDelta[] bundleDeltaArray = object.resolve(bundleDescriptionArray).getChanges();
                                abstractBundleArray2 = this.processDelta(bundleDeltaArray, bl);
                                if (!this.framework.isActive()) {
                                    Object var13_15 = null;
                                    if (!Profile.STARTUP) break block23;
                                    break block24;
                                }
                                if (bl) {
                                    abstractBundleArray3 = this.framework.getAllBundles();
                                    n = 0;
                                    while (true) {
                                        if (n >= abstractBundleArray3.length) {
                                            if (bundleDeltaArray.length <= 0) break block25;
                                        }
                                        abstractBundleArray3[n].unresolvePermissions();
                                        ++n;
                                    }
                                    object.setTimeStamp(object.getTimeStamp() == Long.MAX_VALUE ? 0L : object.getTimeStamp() + 1L);
                                }
                            }
                            this.resumeBundles(abstractBundleArray2, bl);
                            break block26;
                        }
                        catch (Throwable throwable) {
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                                Debug.printStackTrace(throwable);
                            }
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            if (throwable instanceof Error) {
                                throw (Error)throwable;
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        if (Profile.STARTUP) {
                            Profile.logExit("resolve bundles");
                        }
                        if (!this.framework.isActive()) throw throwable;
                        this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                        if (!bl) throw throwable;
                        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                        throw throwable;
                    }
                }
                Profile.logExit("resolve bundles");
            }
            if (!this.framework.isActive()) return;
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (!bl) return;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            return;
        }
        Object var13_17 = null;
        if (Profile.STARTUP) {
            Profile.logExit("resolve bundles");
        }
        if (!this.framework.isActive()) return;
        this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
        if (!bl) return;
        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (abstractBundleArray == null) {
            return;
        }
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (abstractBundleArray[n].isResolved() && (bl || (abstractBundleArray[n].getBundleData().getStatus() & 2) != 0 && !abstractBundleArray[n].testStateChanging(Thread.currentThread()))) {
                this.framework.resumeBundle(abstractBundleArray[n]);
            }
            ++n;
        }
    }

    private void suspendBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive() && !abstractBundle.isFragment()) {
            this.framework.suspendBundle(abstractBundle, true);
        } else if (abstractBundle.getStateChanging() != Thread.currentThread()) {
            try {
                abstractBundle.beginStateChange();
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
            }
        }
        if (Debug.DEBUG_PACKAGEADMIN && abstractBundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + abstractBundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundleDescription = bundleDelta.getBundle();
            if (bundleDescription.getDependents() != null && bundleDescription.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundleDescription);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
            if (bundleLoaderProxy != null) {
                BundleHost.closeBundleLoader(bundleLoaderProxy);
                try {
                    bundleLoaderProxy.getBundleHost().getBundleData().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle abstractBundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (abstractBundle == null) {
            BundleException bundleException = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            return null;
        }
        boolean bl = true;
        if (abstractBundle.isFragment()) {
            BundleDescription[] bundleDescriptionArray = bundleDescription.getHost().getHosts();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescriptionArray[n].getBundleId());
                bl = ((BundleFragment)abstractBundle).addHost(bundleHost.getLoaderProxy());
                ++n;
            }
        }
        if (bl) {
            abstractBundle.resolve();
        }
        return abstractBundle;
    }

    private AbstractBundle[] applyDeltas(BundleDelta[] bundleDeltaArray) throws BundleException {
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(bundleDeltaArray.length);
        int n = 0;
        while (n < bundleDeltaArray.length) {
            AbstractBundle abstractBundle;
            int n2 = bundleDeltaArray[n].getType();
            if ((n2 & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltaArray[n]);
            }
            if ((n2 & 8) != 0 && (abstractBundle = this.setResolved(bundleDeltaArray[n].getBundle())) != null && abstractBundle.isResolved()) {
                arrayList.add(abstractBundle);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractBundle[] processDelta(BundleDelta[] var1_1, boolean var2_2) {
        var3_3 = new ArrayList<boolean[]>(var1_1.length);
        var4_4 = 0;
        while (true) {
            if (var4_4 >= var1_1.length) {
                var4_5 = var3_3.toArray(new AbstractBundle[var3_3.size()]);
                Util.sort(var4_5);
                StartLevelManager.sortByDependency((AbstractBundle[])var4_5);
                var5_6 /* !! */  = new boolean[var4_5.length];
                var6_7 = null;
                ** try [egrp 0[TRYBLOCK] [8 : 142->638)] { 
lbl11:
                // 1 sources

                break;
            }
            if (!((var1_1[var4_4].getType() & 256) != 0 && (var1_1[var4_4].getType() & 2) == 0 || (var5_6 /* !! */  = (boolean[])this.framework.getBundle(var1_1[var4_4].getBundle().getBundleId())) == null || var3_3.contains(var5_6 /* !! */ ))) {
                var3_3.add(var5_6 /* !! */ );
            }
            ++var4_4;
        }
        {
            block51: {
                block49: {
                    block50: {
                        block46: {
                            block47: {
                                try {
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                                    }
                                    var7_8 = false;
                                    var8_12 = var4_5.length - 1;
                                    while (true) {
                                        if (var8_12 < 0) {
                                            if (!var7_8) break;
                                            FrameworkProperties.setProperty("osgi.forcedRestart", "true");
                                            if (var2_2) {
                                                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                                            }
                                            this.framework.shutdown();
                                            var10_16 = null;
                                            if (!Debug.DEBUG_PACKAGEADMIN) break block46;
                                            break block47;
                                        }
                                        var5_6 /* !! */ [var8_12] = var4_5[var8_12].isResolved();
                                        if (var4_5[var8_12] == this.framework.systemBundle) {
                                            var7_8 = true;
                                        } else if ((var4_5[var8_12].bundledata.getType() & 2) != 0 && var5_6 /* !! */ [var8_12]) {
                                            var7_8 = true;
                                        } else if ((var4_5[var8_12].bundledata.getType() & 4) != 0) {
                                            var7_8 = true;
                                        }
                                        --var8_12;
                                    }
                                    if (var2_2) {
                                        var8_12 = var4_5.length - 1;
                                        while (var8_12 >= 0) {
                                            this.suspendBundle((AbstractBundle)var4_5[var8_12]);
                                            --var8_12;
                                        }
                                    }
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: refresh the bundles");
                                    }
                                    var8_13 = this.framework.bundles;
                                    synchronized (var8_13) {
                                        var9_25 = 0;
                                        while (true) {
                                            if (var9_25 >= var4_5.length) {
                                                break;
                                            }
                                            var4_5[var9_25].refresh();
                                            ++var9_25;
                                        }
                                    }
                                    var8_14 = 0;
                                    while (true) {
                                        block52: {
                                            if (var8_14 < var4_5.length) break block52;
                                            if (Debug.DEBUG_PACKAGEADMIN) {
                                                Debug.println("refreshPackages: applying deltas to bundles");
                                            }
                                            var8_15 = this.framework.bundles;
                                            synchronized (var8_15) {
                                                var6_7 = this.applyDeltas(var1_1);
                                                ** GOTO lbl-1000
                                            }
                                        }
                                        if (var5_6 /* !! */ [var8_14]) {
                                            this.framework.publishBundleEvent(64, (Bundle)var4_5[var8_14]);
                                        }
                                        ++var8_14;
                                    }
                                }
                                catch (Throwable var11_26) {
                                    var10_17 = null;
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: release the state change locks");
                                    }
                                    if (!var2_2) break block49;
                                    var12_20 = 0;
                                    break block50;
                                }
                            }
                            Debug.println("refreshPackages: release the state change locks");
                        }
                        if (var2_2) {
                            var12_19 = 0;
                            while (var12_19 < var4_5.length) {
                                var13_22 = var4_5[var12_19];
                                var13_22.completeStateChange();
                                ++var12_19;
                            }
                        }
                        return null;
                    }
                    while (var12_20 < var4_5.length) {
                        var13_23 = var4_5[var12_20];
                        var13_23.completeStateChange();
                        ++var12_20;
                    }
                }
                throw var11_26;
lbl-1000:
                // 1 sources

                {
                    var10_18 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block51;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            if (var2_2) {
                var12_21 = 0;
                while (var12_21 < var4_5.length) {
                    var13_24 = var4_5[var12_21];
                    var13_24.completeStateChange();
                    ++var12_21;
                }
            }
            if (var2_2) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException var7_9) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + var7_9.getMessage());
                        Debug.printStackTrace(var7_9);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var7_9));
                }
            }
        }
lbl133:
        // 1 sources

        catch (BundleException var7_10) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + var7_10.getMessage());
                Debug.printStackTrace(var7_10.getNestedException() == null ? var7_10 : var7_10.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var7_10));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        if (var6_7 != null) {
            var7_11 = 0;
            while (var7_11 < var6_7.length) {
                this.framework.publishBundleEvent(32, var6_7[var7_11]);
                ++var7_11;
            }
        }
        return var4_5;
    }

    public RequiredBundle[] getRequiredBundles(String string) {
        AbstractBundle[] abstractBundleArray = string == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null || abstractBundleArray.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> arrayList = new ArrayList<BundleLoaderProxy>(abstractBundleArray.length);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (!abstractBundleArray[n].isFragment() && abstractBundleArray[n].isResolved() && abstractBundleArray[n].getSymbolicName() != null) {
                arrayList.add(((BundleHost)abstractBundleArray[n]).getLoaderProxy());
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new RequiredBundle[arrayList.size()]);
    }

    public Bundle[] getBundles(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] abstractBundleArray = this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null) {
            return null;
        }
        if (string2 == null) {
            Bundle[] bundleArray = new AbstractBundle[abstractBundleArray.length];
            System.arraycopy(abstractBundleArray, 0, bundleArray, 0, bundleArray.length);
            return bundleArray;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length);
        VersionRange versionRange = new VersionRange(string2);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (versionRange.isIncluded(abstractBundleArray[n].getVersion())) {
                arrayList.add(abstractBundleArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] bundleLoaderProxyArray = ((AbstractBundle)bundle).getHosts();
        if (bundleLoaderProxyArray == null) {
            return null;
        }
        Bundle[] bundleArray = new Bundle[bundleLoaderProxyArray.length];
        int n = 0;
        while (n < bundleLoaderProxyArray.length) {
            bundleArray[n] = bundleLoaderProxyArray[n].getBundleHost();
            ++n;
        }
        return bundleArray;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)classLoader)).getDelegate()).bundle;
        }
        if (classLoader == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new GetBundleAction(this, clazz));
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        this.checkSystemBundle(systemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].getBundleId() == 0L) {
                this.setFrameworkVersion(bundleDescriptionArray[n]);
            } else {
                this.setResolved(bundleDescriptionArray[n]);
            }
            ++n;
        }
    }

    private void checkSystemBundle(SystemBundle systemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription bundleDescription = state.getBundle(0L);
            boolean bl = false;
            if (bundleDescription == null || !systemBundle.getBundleData().getVersion().equals(bundleDescription.getVersion())) {
                bl = true;
            }
            if (!bl && FrameworkProperties.getProperty("osgi.dev") == null) {
                return;
            }
            BundleDescription bundleDescription2 = state.getFactory().createBundleDescription(state, systemBundle.getHeaders(""), systemBundle.getLocation(), 0L);
            if (bundleDescription2 == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            if (!bl) {
                ExportPackageDescription[] exportPackageDescriptionArray;
                ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
                if (exportPackageDescriptionArray2.length >= (exportPackageDescriptionArray = bundleDescription2.getExportPackages()).length) {
                    int n = 0;
                    while (n < exportPackageDescriptionArray.length && !bl) {
                        if (exportPackageDescriptionArray2[n].getName().equals(exportPackageDescriptionArray[n].getName())) {
                            Version version = exportPackageDescriptionArray2[n].getVersion();
                            Version version2 = exportPackageDescriptionArray[n].getVersion();
                            bl = version == null ? version2 != null : !((Object)version).equals(version2);
                        } else {
                            bl = true;
                        }
                        ++n;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                state.removeBundle(0L);
                state.addBundle(bundleDescription2);
                state.resolve(false);
            }
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()));
        }
    }

    private void setFrameworkVersion(BundleDescription bundleDescription) {
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (exportPackageDescriptionArray[n].getName().equals("org.osgi.framework")) {
                FrameworkProperties.setProperty("org.osgi.framework.version", exportPackageDescriptionArray[n].getVersion().toString());
                break;
            }
            ++n;
        }
        FrameworkProperties.setProperty("osgi.framework.version", bundleDescription.getVersion().toString());
    }

    static class GetBundleAction
    implements PrivilegedAction {
        private Class clazz;
        private PackageAdminImpl impl;

        public GetBundleAction(PackageAdminImpl packageAdminImpl, Class clazz) {
            this.impl = packageAdminImpl;
            this.clazz = clazz;
        }

        public Object run() {
            return this.impl.getBundlePriv(this.clazz);
        }
    }
}

