/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExpressionInfo {
    private boolean fHasDefaultVariableAccess;
    private boolean fHasSystemPropertyAccess;
    private List fAccessedVariableNames;
    private List fMisbehavingExpressionTypes;

    public boolean hasDefaultVariableAccess() {
        return this.fHasDefaultVariableAccess;
    }

    public void markDefaultVariableAccessed() {
        this.fHasDefaultVariableAccess = true;
    }

    public boolean hasSystemPropertyAccess() {
        return this.fHasSystemPropertyAccess;
    }

    public void markSystemPropertyAccessed() {
        this.fHasSystemPropertyAccess = true;
    }

    public String[] getAccessedVariableNames() {
        if (this.fAccessedVariableNames == null) {
            return new String[0];
        }
        return this.fAccessedVariableNames.toArray(new String[this.fAccessedVariableNames.size()]);
    }

    public void addVariableNameAccess(String string) {
        if (this.fAccessedVariableNames == null) {
            this.fAccessedVariableNames = new ArrayList(5);
            this.fAccessedVariableNames.add(string);
        } else if (!this.fAccessedVariableNames.contains(string)) {
            this.fAccessedVariableNames.add(string);
        }
    }

    public Class[] getMisbehavingExpressionTypes() {
        if (this.fMisbehavingExpressionTypes == null) {
            return null;
        }
        return this.fMisbehavingExpressionTypes.toArray(new Class[this.fMisbehavingExpressionTypes.size()]);
    }

    public void addMisBehavingExpressionType(Class clazz) {
        if (this.fMisbehavingExpressionTypes == null) {
            this.fMisbehavingExpressionTypes = new ArrayList();
            this.fMisbehavingExpressionTypes.add(clazz);
        } else if (!this.fMisbehavingExpressionTypes.contains(clazz)) {
            this.fMisbehavingExpressionTypes.add(clazz);
        }
    }

    public void merge(ExpressionInfo expressionInfo) {
        this.mergeDefaultVariableAccess(expressionInfo);
        this.mergeSystemPropertyAccess(expressionInfo);
        this.mergeAccessedVariableNames(expressionInfo);
        this.mergeMisbehavingExpressionTypes(expressionInfo);
    }

    public void mergeExceptDefaultVariable(ExpressionInfo expressionInfo) {
        this.mergeSystemPropertyAccess(expressionInfo);
        this.mergeAccessedVariableNames(expressionInfo);
        this.mergeMisbehavingExpressionTypes(expressionInfo);
    }

    private void mergeDefaultVariableAccess(ExpressionInfo expressionInfo) {
        this.fHasDefaultVariableAccess = this.fHasDefaultVariableAccess || expressionInfo.fHasDefaultVariableAccess;
    }

    private void mergeSystemPropertyAccess(ExpressionInfo expressionInfo) {
        this.fHasSystemPropertyAccess = this.fHasSystemPropertyAccess || expressionInfo.fHasSystemPropertyAccess;
    }

    private void mergeAccessedVariableNames(ExpressionInfo expressionInfo) {
        if (this.fAccessedVariableNames == null) {
            this.fAccessedVariableNames = expressionInfo.fAccessedVariableNames;
        } else if (expressionInfo.fAccessedVariableNames != null) {
            Iterator iterator = expressionInfo.fAccessedVariableNames.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.fAccessedVariableNames.contains(e)) continue;
                this.fAccessedVariableNames.add(e);
            }
        }
    }

    private void mergeMisbehavingExpressionTypes(ExpressionInfo expressionInfo) {
        if (this.fMisbehavingExpressionTypes == null) {
            this.fMisbehavingExpressionTypes = expressionInfo.fMisbehavingExpressionTypes;
        } else if (expressionInfo.fMisbehavingExpressionTypes != null) {
            Iterator iterator = expressionInfo.fMisbehavingExpressionTypes.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.fMisbehavingExpressionTypes.contains(e)) continue;
                this.fMisbehavingExpressionTypes.add(e);
            }
        }
    }
}

