/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PropertyTesterDescriptor
implements IPropertyTester {
    private IConfigurationElement fConfigElement;
    private String fNamespace;
    private String fProperties;
    private static final String PROPERTIES = "properties";
    private static final String NAMESPACE = "namespace";
    private static final String CLASS = "class";

    public PropertyTesterDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fConfigElement = iConfigurationElement;
        this.fNamespace = this.fConfigElement.getAttribute(NAMESPACE);
        if (this.fNamespace == null) {
            throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, ExpressionMessages.PropertyTesterDescriptor_no_namespace, null));
        }
        StringBuffer stringBuffer = new StringBuffer(",");
        String string = iConfigurationElement.getAttribute(PROPERTIES);
        if (string == null) {
            throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, ExpressionMessages.PropertyTesterDescritpri_no_properties, null));
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append(',');
        this.fProperties = stringBuffer.toString();
    }

    public PropertyTesterDescriptor(IConfigurationElement iConfigurationElement, String string, String string2) {
        this.fConfigElement = iConfigurationElement;
        this.fNamespace = string;
        this.fProperties = string2;
    }

    public String getProperties() {
        return this.fProperties;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigElement;
    }

    public boolean handles(String string, String string2) {
        return this.fNamespace.equals(string) && this.fProperties.indexOf("," + string2 + ",") != -1;
    }

    public boolean isInstantiated() {
        return false;
    }

    public boolean isDeclaringPluginActive() {
        Bundle bundle = Platform.getBundle((String)this.fConfigElement.getContributor().getName());
        return bundle.getState() == 32;
    }

    public IPropertyTester instantiate() throws CoreException {
        return (IPropertyTester)this.fConfigElement.createExecutableExtension(CLASS);
    }

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        Assert.isTrue((boolean)false, (String)"Method should never be called");
        return false;
    }
}

