/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;

public class AppCommands
implements CommandProvider {
    private static final String LAUNCHABLE_APP_FILTER = "(&(application.locked=false)(application.launchable=true)(application.visible=true))";
    private static final String ACTIVE_APP_FILTER = "(!(application.state=STOPPING))";
    private static final String LOCKED_APP_FILTER = "(application.locked=true)";
    private static AppCommands instance;
    private BundleContext context;
    private ServiceTracker applicationDescriptors;
    private ServiceTracker applicationHandles;
    private ServiceTracker scheduledApplications;
    private Filter launchableApp;
    private Filter activeApp;
    private Filter lockedApp;
    private ServiceRegistration providerRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static synchronized void create(BundleContext bundleContext) {
        if (instance != null) {
            return;
        }
        instance = new AppCommands();
        instance.start(bundleContext);
    }

    static synchronized void destroy(BundleContext bundleContext) {
        if (instance == null) {
            return;
        }
        instance.stop(bundleContext);
        instance = null;
    }

    protected AppCommands() {
    }

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.application.ApplicationDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.applicationDescriptors = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.applicationDescriptors.open();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.osgi.service.application.ApplicationHandle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.applicationHandles = new ServiceTracker(bundleContext, clazz2.getName(), null);
            this.applicationHandles.open();
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.osgi.service.application.ScheduledApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.scheduledApplications = new ServiceTracker(bundleContext, clazz3.getName(), null);
            this.scheduledApplications.open();
            this.launchableApp = bundleContext.createFilter(LAUNCHABLE_APP_FILTER);
            this.activeApp = bundleContext.createFilter(ACTIVE_APP_FILTER);
            this.lockedApp = bundleContext.createFilter(LOCKED_APP_FILTER);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.providerRegistration = bundleContext.registerService(clazz4.getName(), (Object)this, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public void stop(BundleContext bundleContext) {
        this.providerRegistration.unregister();
        if (this.applicationDescriptors != null) {
            this.applicationDescriptors.close();
        }
        if (this.applicationHandles != null) {
            this.applicationHandles.close();
        }
        if (this.scheduledApplications != null) {
            this.scheduledApplications.close();
        }
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n---Application Admin Commands---\n");
        stringBuffer.append("\tactiveApps - lists all running application IDs\n");
        stringBuffer.append("\tapps - lists all installed application IDs\n");
        stringBuffer.append("\tlockApp <application id> - locks the specified application ID\n");
        stringBuffer.append("\tschedApp <application id> <time filter> [true|false] - schedules the specified application id to launch at the specified time filter.  Can optionally make the schedule recurring.\n");
        stringBuffer.append("\tstartApp <application id> - starts the specified application ID\n");
        stringBuffer.append("\tstopApp <application id> - stops the specified running application ID\n");
        stringBuffer.append("\tunlockApp <application id> - unlocks the specified application ID\n");
        stringBuffer.append("\tunschedApp <application id> - unschedules all scheduled applications with the specified application ID\n");
        return stringBuffer.toString();
    }

    private Dictionary getServiceProps(ServiceReference serviceReference) {
        String[] stringArray = serviceReference.getPropertyKeys();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], serviceReference.getProperty(stringArray[n]));
            ++n;
        }
        return hashtable;
    }

    public void _apps(CommandInterpreter commandInterpreter) {
        ServiceReference[] serviceReferenceArray = this.applicationDescriptors.getServiceReferences();
        if (serviceReferenceArray == null) {
            commandInterpreter.println((Object)"No applications found.");
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            String string = (String)serviceReferenceArray[n].getProperty("service.pid");
            commandInterpreter.print((Object)string);
            if (this.getApplication(this.applicationHandles.getServiceReferences(), string, "application.descriptor", true) != null) {
                commandInterpreter.print((Object)" [running]");
            }
            if (this.getApplication(this.scheduledApplications.getServiceReferences(), string, "service.pid", true) != null) {
                commandInterpreter.print((Object)" [scheduled]");
            }
            if (!this.launchableApp.match(this.getServiceProps(serviceReferenceArray[n]))) {
                commandInterpreter.print((Object)" [not launchable]");
            } else {
                commandInterpreter.print((Object)" [launchable]");
            }
            if (this.lockedApp.match(this.getServiceProps(serviceReferenceArray[n]))) {
                commandInterpreter.print((Object)" [locked]");
            }
            commandInterpreter.println();
            ++n;
        }
    }

    public void _activeApps(CommandInterpreter commandInterpreter) {
        ServiceReference[] serviceReferenceArray = this.applicationHandles.getServiceReferences();
        if (serviceReferenceArray == null) {
            commandInterpreter.println((Object)"No active applications found");
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            commandInterpreter.print(serviceReferenceArray[n].getProperty("service.pid"));
            commandInterpreter.print((Object)" [");
            commandInterpreter.print((Object)(this.activeApp.match(this.getServiceProps(serviceReferenceArray[n])) ? "running" : "stopping"));
            commandInterpreter.println((Object)"]");
            ++n;
        }
    }

    private ServiceReference getApplication(ServiceReference[] serviceReferenceArray, String string, String string2, boolean bl) {
        ServiceReference serviceReference = null;
        if (serviceReferenceArray != null && string != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                String string3 = (String)serviceReferenceArray[n].getProperty(string2);
                if (bl) {
                    if (string.equals(string3)) {
                        return serviceReferenceArray[n];
                    }
                } else if (string3.indexOf(string) >= 0) {
                    if (serviceReference != null) {
                        if (!string3.equals(serviceReference.getProperty(string2))) {
                            return null;
                        }
                    } else {
                        serviceReference = serviceReferenceArray[n];
                    }
                }
                ++n;
            }
        }
        return serviceReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _startApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        while (true) {
            block6: {
                if ((string2 = commandInterpreter.nextArgument()) != null) break block6;
            }
            arrayList.add(string2);
        }
        String[] stringArray = arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
        try {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>(1);
            if (stringArray != null) {
                hashMap.put("application.args", stringArray);
            }
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
            ApplicationHandle applicationHandle = applicationDescriptor.launch(hashMap);
            commandInterpreter.println((Object)("Launched application instance: " + applicationHandle.getInstanceId()));
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _stopApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationHandles.getServiceReferences(), string, "application.descriptor", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist, is not running or is ambigous."));
            return;
        }
        if (!this.activeApp.match(this.getServiceProps(serviceReference))) {
            commandInterpreter.println((Object)("Application instance is already stopping: " + serviceReference.getProperty("service.pid")));
            return;
        }
        try {
            ApplicationHandle applicationHandle = (ApplicationHandle)this.context.getService(serviceReference);
            applicationHandle.destroy();
            commandInterpreter.println((Object)("Stopped application instance: " + applicationHandle.getInstanceId()));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _lockApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
            return;
        }
        try {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
            applicationDescriptor.lock();
            commandInterpreter.println((Object)("Locked application: " + applicationDescriptor.getApplicationId()));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _unlockApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
            return;
        }
        try {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
            applicationDescriptor.unlock();
            commandInterpreter.println((Object)("Unlocked application: " + applicationDescriptor.getApplicationId()));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _schedApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.applicationDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
            return;
        }
        try {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
            String string2 = commandInterpreter.nextArgument();
            boolean bl = Boolean.valueOf(commandInterpreter.nextArgument());
            applicationDescriptor.schedule(null, null, "org/osgi/application/timer", string2, bl);
            commandInterpreter.println((Object)("Scheduled application: " + applicationDescriptor.getApplicationId()));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _unschedApp(CommandInterpreter commandInterpreter) throws Exception {
        String string = commandInterpreter.nextArgument();
        ServiceReference serviceReference = this.getApplication(this.scheduledApplications.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            commandInterpreter.println((Object)("\"" + string + "\" does not exist or is ambigous."));
            return;
        }
        try {
            ScheduledApplication scheduledApplication = (ScheduledApplication)this.context.getService(serviceReference);
            scheduledApplication.remove();
            commandInterpreter.println((Object)("Unscheduled application: " + serviceReference.getProperty("service.pid")));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.context.ungetService(serviceReference);
    }
}

