/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.CommandListener;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class CommandHandle
implements Listener {
    private static final int COMMAND_MENU_EXPAND_LEVEL = -1;
    private static final String COMMAND_MENU_NAME_KEY = "Command_Menu_Name";
    private static final String MOBILE_PROPERTY_NAME = "mobile";
    private static String cmdMenuName;
    private ControlNode root;
    private GC gc;
    private int displayWidth;
    private Vector commandList = new Vector(4, 4);
    private static final int osVer;
    private boolean skipSeparateMenuItem = false;
    private Vector separateMenuItems = new Vector();

    public CommandHandle() {
        this.root = new ControlNode();
        ResourceBundle rb = ResourceBundle.getBundle(MOBILE_PROPERTY_NAME, Locale.getDefault());
        cmdMenuName = rb.getString(COMMAND_MENU_NAME_KEY);
        rb = null;
    }

    public ControlNode add(Command parent, Command command) {
        if (parent == null || command == null) {
            return null;
        }
        ControlNode ctrlode = this.findControlNode(parent);
        if (ctrlode == null) {
            return null;
        }
        CommandNode cmdNode = ctrlode.commandNode.findCommandNode(parent);
        cmdNode.addChild(new CommandNode(command));
        this.commandList.add(command);
        return ctrlode;
    }

    public ControlNode add(Control control, Command command) {
        if (control == null || command == null) {
            return null;
        }
        ControlNode node = this.add(control);
        if (node != null) {
            node.addCommand(command);
        }
        if (control.isFocusControl() || control instanceof Shell && control.getDisplay().getActiveShell() == control) {
            Control child = null;
            if (control instanceof Composite) {
                child = this.getFocusChild((Composite)control);
            }
            if (child != null) {
                this.makeMenu(child);
            } else {
                this.makeMenu(control);
            }
        }
        this.commandList.add(command);
        return node;
    }

    public void removeCommand(Command command) {
        if (command == null) {
            return;
        }
        ControlNode node = this.root.findControlNode(command);
        if (node == null) {
            return;
        }
        node.commandNode.removeCommand(command);
        Shell shell = node.control.getShell();
        ControlNode shellNode = this.root.findControlNode(shell);
        Control focusControl = this.getFocusChild(shell);
        ControlNode focusNode = this.root.findControlNode(focusControl);
        if (focusControl == null || focusNode == null || !focusNode.hasCommand()) {
            if (shellNode.commandMenuItem != null && !shellNode.commandMenuItem.isDisposed()) {
                shellNode.commandMenuItem.dispose();
            }
            shellNode.commandMenuItem = null;
        } else {
            this.makeMenu(focusControl);
        }
    }

    public boolean isEnabled(Command command) {
        ControlNode ctrlNode = this.root.findControlNode(command);
        CommandNode cmdNode = ctrlNode.commandNode.findCommandNode(command);
        return cmdNode.isEnabled();
    }

    public Control findControl(Command command) {
        if (command == null) {
            return null;
        }
        ControlNode node = this.root.findControlNode(command);
        if (node == null || node.control == null) {
            return null;
        }
        return node.control;
    }

    public CommandNode findCommandNode(Command command) {
        ControlNode ctrlNode = this.root.findControlNode(command);
        if (ctrlNode == null) {
            return null;
        }
        return ctrlNode.commandNode.findCommandNode(command);
    }

    public void handleEvent(Event event) {
        if (event.type != 15 && event.type != 16) {
            return;
        }
        if (!(event.widget instanceof Control)) {
            return;
        }
        Control control = (Control)event.widget;
        Shell shell = control.getShell();
        Rectangle oldClientArea = new Rectangle(0, 0, 0, 0);
        if (shell != null) {
            oldClientArea = shell.getClientArea();
        }
        if (event.type == 16) {
            if (osVer == 3) {
                Iterator iterator = this.separateMenuItems.iterator();
                while (iterator.hasNext()) {
                    MenuItem item = (MenuItem)iterator.next();
                    if (item == null || item.isDisposed()) continue;
                    item.dispose();
                }
                this.separateMenuItems.clear();
            } else {
                ControlNode shellNode = this.root.findControlNode(shell);
                if (shellNode == null) {
                    return;
                }
                if (shellNode.commandMenuItem != null && !shellNode.commandMenuItem.isDisposed()) {
                    shellNode.commandMenuItem.dispose();
                }
                shellNode.commandMenuItem = null;
                shellNode.trigger = null;
            }
            if (osVer == 0 && shell != null && !oldClientArea.equals(shell.getClientArea())) {
                shell.layout(true);
            }
        } else {
            if (!control.isVisible()) {
                return;
            }
            ControlNode node = this.root.findControlNode(control);
            if (node == null) {
                node = this.findParentControlNode(control);
                if (node == null) {
                    return;
                }
                node = this.add(control);
            } else if (node.parent.control != control.getParent()) {
                this.processParentChanged(control);
            }
            if (node.hasCommand()) {
                this.makeMenu(node.control);
                if (osVer == 0 && shell != null && !oldClientArea.equals(shell.getClientArea())) {
                    shell.layout(true);
                }
            }
        }
    }

    private ControlNode add(Control control) {
        ControlNode node;
        Control c;
        if (control == null) {
            return null;
        }
        Vector<Control> controls = new Vector<Control>();
        for (c = control; c != null; c = c.getParent()) {
            controls.add(c);
        }
        Vector<Control> unhandles = new Vector<Control>();
        Iterator iterator = controls.iterator();
        while (iterator.hasNext()) {
            c = (Control)iterator.next();
            node = this.root.findControlNode(c);
            if (node != null) continue;
            unhandles.add(c);
        }
        node = this.root;
        for (int i = controls.size() - 1; i >= 0; --i) {
            c = (Control)controls.elementAt(i);
            node = this.add(node, c);
        }
        iterator = unhandles.iterator();
        while (iterator.hasNext()) {
            this.addDisposeListener((Control)iterator.next());
        }
        return node;
    }

    private ControlNode add(ControlNode parent, Control control) {
        if (parent == null || control == null) {
            return null;
        }
        ControlNode node = this.root.findControlNode(control);
        if (node == null) {
            node = new ControlNode(control);
            parent.addChild(node);
        }
        return node;
    }

    private void addDisposeListener(Control control) {
        if (control == null) {
            return;
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ControlNode node = CommandHandle.this.root.findControlNode((Control)e.widget);
                if (node != null && !node.isDispose()) {
                    node.dispose();
                }
                node = null;
            }
        });
    }

    private ControlNode processParentChanged(Control control) {
        ControlNode node;
        if (control == null || control.getParent() == null) {
            return null;
        }
        ControlNode current = this.root.findControlNode(control);
        if (current.parent != null) {
            node = current;
            node.parent.removeChild(node);
            node = node.parent;
            while (node.control != null) {
                if (!node.hasCommand() && !node.hasChild()) {
                    node.dispose();
                }
                node = node.parent;
            }
        }
        node = this.add(control.getParent());
        node.addChild(current);
        return current;
    }

    private ControlNode findControlNode(Command command) {
        if (command == null) {
            return null;
        }
        return this.root.findControlNode(command);
    }

    private ControlNode findParentControlNode(Control control) {
        if (control == null) {
            return null;
        }
        ControlNode node = null;
        for (Control c = control; c != null && (node = this.root.findControlNode(c)) == null; c = c.getParent()) {
        }
        return node;
    }

    public void makeMenu(Command command) {
        if (command == null) {
            return;
        }
        Control control = this.findControl(command);
        if (control == null) {
            return;
        }
        Control child = null;
        if (control instanceof Composite) {
            child = this.getFocusChild((Composite)control);
        }
        if (child != null) {
            this.makeMenu(child);
        } else {
            this.makeMenu(control);
        }
    }

    private void makeMenu(Control control) {
        Shell shell;
        Menu mainMenu;
        if (control == null) {
            return;
        }
        ControlNode node = this.root.findControlNode(control);
        if (node == null) {
            return;
        }
        if (this.gc == null) {
            this.gc = new GC(control.getDisplay());
            this.displayWidth = control.getDisplay().getBounds().width;
        }
        if ((mainMenu = (shell = control.getShell()).getMenuBar()) == null) {
            mainMenu = new Menu(shell, 2);
            shell.setMenuBar(mainMenu);
        }
        if (osVer == 3) {
            this.makeSoftkeyMenu(node, mainMenu);
        } else {
            this.makeMenu(control, node, mainMenu);
        }
    }

    private void makeMenu(Control control, ControlNode controlNode, Menu mainMenu) {
        ControlNode shellNode = this.root.findControlNode(control.getShell());
        if (shellNode.commandMenuItem != null && shellNode.commandMenuItem.isDisposed()) {
            return;
        }
        if (shellNode.trigger == control) {
            Menu m;
            if (shellNode.commandMenuItem != null && !shellNode.commandMenuItem.isDisposed() && (m = shellNode.commandMenuItem.getMenu()) != null && !m.isDisposed()) {
                m.dispose();
            }
        } else {
            if (shellNode.commandMenuItem != null && !shellNode.commandMenuItem.isDisposed()) {
                shellNode.commandMenuItem.dispose();
            }
            shellNode.commandMenuItem = null;
            shellNode.trigger = control;
        }
        if (shellNode.commandMenuItem == null) {
            shellNode.commandMenuItem = new MenuItem(mainMenu, 64);
            shellNode.commandMenuItem.setText(cmdMenuName);
        }
        Menu commandMenu = new Menu(shellNode.commandMenuItem);
        shellNode.commandMenuItem.setMenu(commandMenu);
        controlNode.makeMenu(commandMenu);
    }

    private void makeSoftkeyMenu(ControlNode controlNode, Menu mainMenu) {
        Iterator iterator = this.separateMenuItems.iterator();
        while (iterator.hasNext()) {
            MenuItem item = (MenuItem)iterator.next();
            if (item == null || item.isDisposed()) continue;
            item.dispose();
        }
        this.separateMenuItems.clear();
        if (controlNode.hasCommand()) {
            controlNode.makeMenu(mainMenu);
        }
        ControlNode tmp = controlNode;
        while (tmp != null) {
            Iterator iterator2 = tmp.commandNode.childs.iterator();
            while (iterator2.hasNext()) {
                CommandNode commandNode = (CommandNode)iterator2.next();
                this.separateMenuItems.add(commandNode.item);
            }
            if (tmp.separateMenuItem != null) {
                this.separateMenuItems.add(tmp.separateMenuItem);
            }
            tmp = tmp.parent;
        }
    }

    private Control getFocusChild(Composite c) {
        if (c == null) {
            return null;
        }
        Control[] children = c.getChildren();
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            Control child;
            if (children[i] == null) continue;
            if (children[i].isFocusControl()) {
                return children[i];
            }
            if (!(children[i] instanceof Canvas) && !(children[i] instanceof CaptionedControl) && !(children[i] instanceof Composite) || (child = this.getFocusChild((Composite)children[i])) == null) continue;
            return child;
        }
        return null;
    }

    public void setDefaultCommand(Command c) {
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command tempCommand = (Command)this.commandList.elementAt(i);
            if (!tempCommand.defaultCommand || tempCommand.equals(c)) continue;
            tempCommand.defaultCommand = false;
        }
    }

    static {
        osVer = OS.RotDetectDisplay_CheckOS();
    }

    class CommandNode {
        CommandNode parent = null;
        Command command;
        Vector childs;
        MenuItem item;
        boolean dispose = false;

        public CommandNode() {
            this.command = null;
            this.childs = new Vector();
        }

        public CommandNode(Command command) {
            this.command = command;
            this.childs = new Vector();
        }

        public CommandNode addChild(CommandNode child) {
            int insert = this.childs.size();
            for (int i = 0; i < this.childs.size(); ++i) {
                CommandNode node = (CommandNode)this.childs.elementAt(i);
                if (node.isDispose() || child.command.priority <= node.command.priority) continue;
                insert = i;
                break;
            }
            this.childs.insertElementAt(child, insert);
            child.parent = this;
            return child;
        }

        public boolean hasChild() {
            return this.childs.size() > 0;
        }

        public boolean contains(Command command) {
            return this.contains(command, true);
        }

        private boolean contains(Command command, boolean recursion) {
            if (this.command == command) {
                return true;
            }
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                CommandNode node = (CommandNode)iterator.next();
                if (node.isDispose() || !recursion || !node.contains(command, recursion)) continue;
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            return this.isEnabled(true);
        }

        private boolean isEnabled(boolean recursion) {
            if (this.command != null && !this.command.getEnabled()) {
                return false;
            }
            return !recursion || this.parent == null || this.parent.isEnabled(recursion);
        }

        public boolean hasCommand() {
            return this.hasCommand(true);
        }

        private boolean hasCommand(boolean recursion) {
            if (this.command != null) {
                return true;
            }
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                CommandNode node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.command != null) {
                    return true;
                }
                if (!node.hasCommand(recursion)) continue;
                return true;
            }
            return false;
        }

        public CommandNode findCommandNode(Command child) {
            return this.findCommandNode(child, true);
        }

        private CommandNode findCommandNode(Command child, boolean recursion) {
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                CommandNode node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.command == child) {
                    return node;
                }
                if (!recursion || (node = node.findCommandNode(child, recursion)) == null || node.command != child) continue;
                return node;
            }
            return null;
        }

        public void makeMenu(Menu menu) {
            this.makeMenu(menu, true, -1);
        }

        public void makeMenu(Menu menu, int level) {
            this.makeMenu(menu, true, level);
        }

        private void makeMenu(Menu menu, boolean recursion, int level) {
            CommandNode node;
            if (!this.hasChild()) {
                return;
            }
            Vector<CommandNode> hasChild = new Vector<CommandNode>();
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                MenuItem item;
                node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.hasChild()) {
                    item = new MenuItem(menu, 64);
                    this.setMenuItem(item, node.command);
                    this.implementListener(item, node.command);
                    node.item = item;
                    if (!node.command.enabled || !recursion) continue;
                    if (level != 0) {
                        Menu subMenu = new Menu(item);
                        item.setMenu(subMenu);
                        node.makeMenu(subMenu, recursion, level - 1);
                        continue;
                    }
                    hasChild.add(node);
                    continue;
                }
                item = new MenuItem(menu, 8);
                this.setMenuItem(item, node.command);
                this.implementListener(item, node.command);
                node.item = item;
                this.itemAddSelectionListener(item, node.command);
            }
            iterator = hasChild.iterator();
            while (iterator.hasNext()) {
                node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                MenuItem barItem = new MenuItem(menu, 2);
                node.makeMenu(menu, recursion, 0);
            }
        }

        private void implementListener(MenuItem item, Command command) {
            if (command.listeners == null) {
                return;
            }
            MenuItem item_tmp = item;
            for (int i = 0; i < command.listeners.size(); ++i) {
                CommandListener cmdListener = (CommandListener)command.listeners.elementAt(i);
                item.addListener(cmdListener.getEventType(), cmdListener);
                item.addDisposeListener(new DisposeListener(this, item_tmp, cmdListener){
                    private final /* synthetic */ MenuItem val$item_tmp;
                    private final /* synthetic */ CommandListener val$cmdListener;
                    private final /* synthetic */ CommandNode this$1;
                    {
                        this.this$1 = this$1;
                        this.val$item_tmp = val$item_tmp;
                        this.val$cmdListener = val$cmdListener;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        this.val$item_tmp.removeListener(this.val$cmdListener.getEventType(), this.val$cmdListener);
                    }
                });
            }
        }

        private void itemAddSelectionListener(MenuItem item, Command command) {
            if (item == null || item.isDisposed() || command == null || command.isDisposed()) {
                return;
            }
            Command nodeCommand = command;
            item.addSelectionListener(new SelectionListener(this, nodeCommand){
                private final /* synthetic */ Command val$nodeCommand;
                private final /* synthetic */ CommandNode this$1;
                {
                    this.this$1 = this$1;
                    this.val$nodeCommand = val$nodeCommand;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.val$nodeCommand.selectionListenerCount > 0) {
                        this.val$nodeCommand.Command_SendEvent(13);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (this.val$nodeCommand.selectionListenerCount > 0) {
                        this.val$nodeCommand.Command_SendEvent(14);
                    }
                }
            });
        }

        private void setMenuItem(MenuItem item, Command command) {
            if (item == null || command == null) {
                return;
            }
            String longLabel = command.getLongLabel();
            if (longLabel != null && (this.gwtStringWidth(longLabel) < CommandHandle.this.displayWidth || command.getText().equals(""))) {
                item.setText(longLabel);
            } else {
                item.setText(command.getText());
            }
            item.setAccelerator(command.accelerator);
            if (command.getImage() != null) {
                item.setImage(command.getImage());
            }
            item.setEnabled(command.enabled);
            item.setSelection(command.defaultCommand);
        }

        private int gwtStringWidth(String str) {
            if (str == null) {
                return 0;
            }
            int width = 0;
            for (int i = 0; i < str.length(); ++i) {
                width += CommandHandle.this.gc.getCharWidth(str.charAt(i));
            }
            return width;
        }

        public boolean removeCommand(Command command) {
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                CommandNode node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.command == command) {
                    this.childs.remove(node);
                    node.dispose();
                    node = null;
                    return true;
                }
                if (!node.removeCommand(command)) continue;
                return true;
            }
            return false;
        }

        public void dispose() {
            if (this.dispose) {
                return;
            }
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                CommandNode node = (CommandNode)iterator.next();
                if (node.isDispose()) continue;
                node.dispose();
                Object var2_2 = null;
            }
            if (this.item != null && !this.item.isDisposed()) {
                this.item.dispose();
            }
            this.childs.clear();
            this.childs = null;
            this.dispose = true;
        }

        public boolean isDispose() {
            return this.dispose;
        }
    }

    class ControlNode {
        ControlNode parent;
        Vector childs;
        Control control;
        CommandNode commandNode;
        boolean dispose = false;
        MenuItem commandMenuItem = null;
        MenuItem separateMenuItem = null;
        Control trigger = null;

        public ControlNode() {
            this.parent = null;
            this.control = null;
            this.childs = new Vector();
            this.commandNode = new CommandNode();
        }

        public ControlNode(Control control) {
            this.control = control;
            this.childs = new Vector();
            this.commandNode = new CommandNode();
        }

        public ControlNode addChild(ControlNode node) {
            node.parent = this;
            this.childs.add(node);
            return node;
        }

        public ControlNode removeChild(ControlNode child) {
            this.childs.remove(child);
            return child;
        }

        public boolean contains(Command command) {
            return this.commandNode.contains(command);
        }

        public void addCommand(Command command) {
            this.commandNode.addChild(new CommandNode(command));
        }

        public ControlNode findControlNode(Command command) {
            if (this.commandNode.contains(command)) {
                return this;
            }
            return this.findControlNode(command, true);
        }

        private ControlNode findControlNode(Command command, boolean recursion) {
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                ControlNode node = (ControlNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.commandNode.contains(command)) {
                    return node;
                }
                if (!recursion || (node = node.findControlNode(command, recursion)) == null) continue;
                return node;
            }
            return null;
        }

        public ControlNode findControlNode(Control control) {
            if (control == null) {
                return null;
            }
            return this.findControlNode(control, control.getShell());
        }

        private ControlNode findControlNode(Control control, Shell shell) {
            return this.findControlNode(control, shell, true);
        }

        private ControlNode findControlNode(Control control, Shell shell, boolean recursion) {
            if (control == null) {
                return null;
            }
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                ControlNode node = (ControlNode)iterator.next();
                if (node.isDispose()) continue;
                if (node.control == control) {
                    return node;
                }
                if (!recursion || (node = node.findControlNode(control, shell, recursion)) == null || node.control != control) continue;
                return node;
            }
            return null;
        }

        public boolean hasChild() {
            return this.childs.size() > 0;
        }

        public boolean hasCommand() {
            return this.hasCommand(true);
        }

        private boolean hasCommand(boolean recursion) {
            if (this.commandNode.hasCommand()) {
                return true;
            }
            return recursion && this.parent != null && !this.isLast() && this.parent.hasCommand(recursion);
        }

        public void makeMenu(Menu menu) {
            CommandHandle.this.skipSeparateMenuItem = false;
            this.makeMenu(menu, -1);
        }

        private void makeMenu(Menu menu, int level) {
            if (this.control == null || this.parent == null) {
                return;
            }
            if (this.commandNode.childs.size() > 0) {
                this.commandNode.makeMenu(menu, level);
                if (this.insertSeparateMenuItem()) {
                    this.separateMenuItem = new MenuItem(menu, 2);
                }
            }
            if (this.parent.hasCommand() && !this.isLast()) {
                this.parent.makeMenu(menu, level);
            }
        }

        private boolean insertSeparateMenuItem() {
            if (!this.parent.hasCommand()) {
                return false;
            }
            if (this.isLast()) {
                return false;
            }
            if (osVer == 3) {
                if (CommandHandle.this.skipSeparateMenuItem) {
                    return true;
                }
                boolean hasChild = false;
                Iterator iterator = this.commandNode.childs.iterator();
                while (iterator.hasNext()) {
                    CommandNode node = (CommandNode)iterator.next();
                    if (node.childs.size() <= 0) continue;
                    hasChild = true;
                    break;
                }
                if (hasChild) {
                    return true;
                }
                if (this.commandNode.childs.size() == 1) {
                    CommandHandle.this.skipSeparateMenuItem = true;
                    return false;
                }
            }
            return true;
        }

        private boolean isLast() {
            if (this.parent == null) {
                return true;
            }
            if (this.control == null) {
                return true;
            }
            if (this.control instanceof MultiPageDialog.MultiPageShell) {
                return false;
            }
            if (!(this.control instanceof Shell)) {
                return false;
            }
            Shell s = (Shell)this.control;
            if (s == s.getDisplay().getActiveShell()) {
                return true;
            }
            return this.control instanceof Shell && this.parent.control instanceof Shell;
        }

        public void dispose() {
            if (this.dispose) {
                return;
            }
            this.commandNode.dispose();
            this.commandNode = null;
            if (this.commandMenuItem != null && !this.commandMenuItem.isDisposed()) {
                this.commandMenuItem.dispose();
            }
            this.commandMenuItem = null;
            Iterator iterator = this.childs.iterator();
            while (iterator.hasNext()) {
                ControlNode node = (ControlNode)iterator.next();
                if (node.isDispose()) continue;
                node.dispose();
                Object var2_2 = null;
            }
            this.childs.clear();
            this.childs = null;
            this.dispose = true;
        }

        public boolean isDispose() {
            return this.dispose;
        }
    }
}

