/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class MultiPageDialog
extends Dialog {
    private int DIALOG_STYLE = 0;
    private static int TITLE_HEIGHT = 26;
    private static int MENU_HEIGHT = 26;
    private Shell shell;
    private MultiPageShell mpShell;
    private MultiPageComposite mpc;
    private Display display;
    private FormLayout layout;
    private Rectangle bound;
    private MultiPageListener mpl;
    private static boolean isInitCallBack = false;

    public MultiPageDialog(Shell parent) {
        this(parent, 0);
    }

    public MultiPageDialog(Shell parent, int style) {
        super(parent, style);
        this.checkDialogStyle(style);
        this.display = parent.getDisplay();
        this.shell = new Shell(this.display, this.DIALOG_STYLE);
        this.mpc = new MultiPageComposite(parent, this.shell, 0);
        this.layout = new FormLayout();
        this.shell.setLayout(this.layout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.mpc.setLayoutData(fd);
        int x = 0;
        int y = 0;
        int w = this.display.getBounds().width;
        int h = this.display.getBounds().height;
        if (SWT.getPlatform().equals("win32")) {
            x = (w /= 2) / 2;
            y = (h /= 2) / 2;
        } else if (SWT.getPlatform().equals("wm2003")) {
            y = TITLE_HEIGHT;
            h -= TITLE_HEIGHT + MENU_HEIGHT;
        }
        this.bound = new Rectangle(x, y, w, h);
        this.shell.setBounds(this.bound);
        this.mpl = new MultiPageListener();
        this.mpc.addSelectionListener(this.mpl);
        MultiPageDialog.initCallBack(this.display);
        final MultiPageDialog mpd = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (mpd != null) {
                    mpd.dispose();
                }
            }
        });
    }

    private void checkDialogStyle(int style) {
        if ((style & 0x20000) == 131072 && (style | 0x20000) != 131072) {
            SWT.error(5);
        }
        if ((style & 0x10000) == 65536 && (style | 0x10000) != 65536) {
            SWT.error(5);
        }
        if ((style & 0x8000) == 32768 && (style | 0x8000) != 32768) {
            SWT.error(5);
        }
        this.DIALOG_STYLE = (style & 0x20000) != 0 || (style & 0x10000) != 0 ? 67696 : 133232;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.shell == null || this.shell.isDisposed()) {
            SWT.error(24);
        }
        if (this.shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpl.addSelectionListener(listener);
    }

    public void close() {
        if (this.shell == null || this.shell.isDisposed()) {
            SWT.error(24);
        }
        if (this.shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        if (this.mpShell != null && !this.mpShell.isDisposed()) {
            this.mpShell.dispose();
        }
    }

    public Composite createPage(String title, Image icon) {
        return this.mpc.createPage(title, icon);
    }

    public void deletePage(int index) {
        this.mpc.deletePage(index);
    }

    public void dispose() {
        if (this.mpc != null && !this.mpc.isDisposed()) {
            this.mpc.dispose();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
        this.layout = null;
        this.bound = null;
    }

    public Composite getPage(int index) {
        return this.mpc.getPage(index);
    }

    public int getPageCount() {
        return this.mpc.getPageCount();
    }

    public String getTitle(int index) {
        return this.mpc.getTitle(index);
    }

    public int getSelectionIndex() {
        return this.mpc.getSelectionIndex();
    }

    public void open() {
        if (this.shell == null || this.shell.isDisposed()) {
            SWT.error(24);
        }
        if (this.shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpShell = new MultiPageShell(this.shell, this.DIALOG_STYLE);
        this.mpc.setParent(this.mpShell);
        this.mpShell.setLayout(this.layout);
        this.mpShell.setText(this.getText());
        this.mpShell.setBounds(this.bound);
        final Rectangle tmpBound = this.bound;
        this.mpShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Rectangle r = ((Shell)e.widget).getBounds();
                tmpBound.x = r.x;
                tmpBound.y = r.y;
                tmpBound.width = r.width;
                tmpBound.height = r.height;
            }
        });
        this.mpShell.open();
        if (this.mpc.getPageCount() > 0) {
            this.mpc.setSelection(this.mpc.getSelectionIndex());
        }
        while (!this.mpShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.mpShell = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.shell == null || this.shell.isDisposed()) {
            SWT.error(24);
        }
        if (this.shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpl.removeSelectionListener(listener);
    }

    public void setSelection(int index) {
        this.mpc.setSelection(index);
    }

    public void setImage(int index, Image icon) {
        this.mpc.setImage(index, icon);
    }

    public void setTitle(int index, String title) {
        this.mpc.setTitle(index, title);
    }

    private static synchronized void initCallBack(Display display) {
        if (!isInitCallBack) {
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(display.internal_handle, 32, "org/eclipse/ercp/swt/mobile/MultiPageDialog$MultiPageComposite", "Callback");
            isInitCallBack = true;
        }
    }

    private class MultiPageListener
    implements SelectionListener {
        private Vector listeners = new Vector();

        private MultiPageListener() {
        }

        public void addSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }

        public void widgetSelected(SelectionEvent se) {
            if (!(se.widget instanceof MultiPageComposite)) {
                return;
            }
            MultiPageComposite mpc = (MultiPageComposite)se.widget;
            if (mpc == null) {
                return;
            }
            Composite composite = mpc.getPage(mpc.getSelectionIndex());
            if (composite == null) {
                return;
            }
            Event e = new Event();
            e.display = composite.getDisplay();
            e.x = composite.getLocation().x;
            e.y = composite.getLocation().y;
            e.width = composite.getSize().x;
            e.height = composite.getSize().y;
            e.type = 13;
            e.widget = composite;
            e.time = se.time;
            SelectionEvent nse = new SelectionEvent(e);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                SelectionListener listener = (SelectionListener)enumeration.nextElement();
                if (listener == null) continue;
                listener.widgetSelected(nse);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CompositePage {
        public Composite composite;
        public String title;
        public int imageHandle;

        public CompositePage(Composite composite, String title) {
            this(composite, title, null);
        }

        public CompositePage(Composite composite, String title, Image icon) {
            this.composite = composite;
            this.title = title;
            this.setImage(icon);
        }

        public void setImage(Image icon) {
            this.imageHandle = icon == null ? 0 : icon.internal_handle;
        }
    }

    private class MultiPageComposite
    extends Composite
    implements Listener {
        private Shell parent;
        private Vector pages = new Vector();
        private int selected = 0;

        public MultiPageComposite(Shell realparent, Composite parent, int style) {
            super(parent, 0);
            this.parent = realparent;
            parent.getDisplay().addFilter(15, this);
        }

        protected void internal_createHandle(int index) {
            this.internal_handle = OS.MultiPageComposite_New(this.internal_parent.internal_handle, 0);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            TypedListener typedListener = new TypedListener(listener);
            this.addListener(13, typedListener);
            this.addListener(14, typedListener);
        }

        public synchronized Composite createPage(String title, Image icon) {
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            int imageHandle = 0;
            if (icon != null) {
                imageHandle = icon.internal_handle;
            }
            Composite composite = new Composite(this, 0);
            boolean success = OS.MultiPageComposite_AddPage(this.internal_handle, composite.internal_handle, title, imageHandle);
            if (success) {
                this.pages.add(new CompositePage(composite, title, icon));
            } else {
                composite.dispose();
                composite = null;
                SWT.error(14);
            }
            return composite;
        }

        public synchronized void deletePage(int index) {
            boolean success;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_DeletePage(this.internal_handle, index)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                this.pages.removeElementAt(index);
                if (this.selected >= index && this.selected > 0) {
                    --this.selected;
                    this.setSelection(this.selected);
                } else if (index == 0 && this.pages.size() > 0) {
                    this.setSelection(this.selected);
                }
            }
        }

        public void dispose() {
            this.checkWidget();
            int size = this.pages.size();
            for (int i = 0; i < size; ++i) {
                CompositePage page = (CompositePage)this.pages.elementAt(i);
                if (page == null) continue;
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                Object var3_3 = null;
            }
            this.pages.removeAllElements();
            this.pages = null;
            this.parent.getDisplay().removeFilter(15, this);
            super.dispose();
        }

        public Composite getPage(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.elementAt((int)index)).composite;
        }

        public int getPageCount() {
            this.checkWidget();
            return this.pages.size();
        }

        public String getTitle(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.elementAt((int)index)).title;
        }

        public int getSelectionIndex() {
            this.checkWidget();
            return this.selected;
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            this.removeListener(13, listener);
            this.removeListener(14, listener);
        }

        public void setSelection(int index) {
            CompositePage page;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if ((page = (CompositePage)this.pages.elementAt(index)) == null) {
                return;
            }
            boolean success = OS.MultiPageComposite_SetSelection(this.internal_handle, index);
            if (success) {
                if (MultiPageDialog.this.mpShell != null) {
                    page.composite.setFocus();
                }
                this.selected = index;
            }
        }

        public void setImage(int index, Image icon) {
            boolean success;
            this.checkWidget();
            if (icon == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetImage(this.internal_handle, index, icon.internal_handle)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                page.setImage(icon);
            }
        }

        public void setTitle(int index, String title) {
            boolean success;
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetTitle(this.internal_handle, index, title)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                page.title = title;
            }
        }

        private void Callback(int index) {
            int size = this.pages.size();
            if (index < 0 || index >= size) {
                return;
            }
            CompositePage page = (CompositePage)this.pages.elementAt(index);
            if (page == null || page.composite == null || page.composite.isDisposed()) {
                return;
            }
            page.composite.setFocus();
            this.selected = index;
            this.internal_sendEvent(13);
        }

        public void handleEvent(Event e) {
            if (this.getParent() != null && !this.getParent().isDisposed() && ((Control)e.widget).getShell() == this.parent) {
                ((Shell)this.getParent()).setActive();
            }
        }
    }

    public class MultiPageShell
    extends Shell {
        private Shell parent;

        public MultiPageShell(Shell parent, int style) {
            super(parent, style);
            this.parent = parent;
        }

        public void dispose() {
            Control[] controls = this.getChildren();
            for (int i = 0; i < controls.length; ++i) {
                controls[i].setParent(this.parent);
            }
            super.dispose();
        }
    }
}

