/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.Platform;

public class Library {
    public static final int JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
    public static final int SWT_VERSION = 1;

    static int parseVersion(String version) {
        int index;
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int start = 0;
        for (index = 0; index < length && Character.isDigit(version.charAt(index)); ++index) {
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int getVersion() {
        return 1;
    }

    public static String getPlatform() {
        return Platform.PLATFORM;
    }

    public static int getRevision() {
        return 0;
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }
}

