/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbsScreen
implements SelectionListener,
ControlListener {
    protected final int NONE = 0;
    protected final int BACK = 1;
    protected final int CANCEL = 2;
    protected final int NEXT = 3;
    protected final int FINISHED = 4;
    NormalView view;
    Composite screen;
    Composite screenPane;
    WrappedLabel titleLabel;
    Button backButton;
    Button cancelButton;
    Button nextButton;
    Composite buttonPane;

    public AbsScreen() {
    }

    public AbsScreen(NormalView normalView) {
        this.view = normalView;
    }

    public void show(boolean bl) {
        if (this.screen == null) {
            this.createScreen();
        }
        if (bl) {
            this.refresh();
            this.setVisible(true);
            this.action();
        } else {
            this.setVisible(true);
        }
    }

    public void setVisible(boolean bl) {
        this.screen.setVisible(bl);
        if (bl) {
            this.screen.setFocus();
        }
    }

    protected abstract void createScreen();

    protected abstract void refresh();

    protected abstract void action();

    protected void init(String string) {
        this.init(string, false);
    }

    protected Composite init(String string, boolean bl) {
        if (bl) {
            this.screen = new Composite(this.view.parent, 512);
            this.screen.getVerticalBar().setVisible(false);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = new Composite(this.screen, 0);
            this.screenPane.setLayout((Layout)new GridLayout(1, false));
            this.screenPane.setLayoutData((Object)new GridData(1808));
        } else {
            this.screen = new Composite(this.view.parent, 0);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = this.screen;
        }
        if (string != null) {
            this.titleLabel = new WrappedLabel(this.screenPane, 0, 0);
            this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 10, 1));
            this.titleLabel.setText(string);
        }
        return this.screenPane;
    }

    protected void fillSpace() {
        new Composite(this.screenPane, 0).setLayoutData((Object)new GridData(1040));
    }

    protected void separator() {
        new Label(this.screenPane, 258).setLayoutData((Object)new GridData(768));
    }

    protected void setButtons(int n, int n2, int n3) {
        this.buttonPane = new Composite(this.screenPane, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 27;
        this.buttonPane.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.justify = true;
        rowLayout.wrap = false;
        this.buttonPane.setLayout((Layout)rowLayout);
        if (n == 1) {
            this.backButton = new Button(this.buttonPane, 8);
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener((SelectionListener)this);
        }
        if (n2 == 2) {
            this.cancelButton = new Button(this.buttonPane, 8);
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener((SelectionListener)this);
        }
        if (n3 != 0) {
            this.nextButton = new Button(this.buttonPane, 8);
            if (n3 == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener((SelectionListener)this);
        }
        this.buttonPane.layout();
        if (this.nextButton != null && this.nextButton.getLocation().x > this.screenPane.getSize().x) {
            rowLayout.wrap = true;
            this.buttonPane.setLayoutData((Object)new GridData(768));
            this.screen.layout();
        }
    }

    public abstract void widgetSelected(SelectionEvent var1);

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
    }
}

