/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.scheduler.ScheduledPluginUninstall;
import org.eclipse.update.internal.scheduler.ScheduledSiteInitialize;

public class RootScreen
extends AbsScreen {
    private Button installButton;
    private Button updateButton;
    private Button manageButton;

    public RootScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.SelectOption);
        ((GridLayout)this.screen.getLayout()).verticalSpacing = "unknown".equals(Platform.getOS()) ? 10 : 20;
        this.installButton = new Button(this.screen, 8);
        this.installButton.setText(UIMessages.InstallFeatures);
        this.installButton.addSelectionListener((SelectionListener)this);
        this.updateButton = new Button(this.screen, 8);
        this.updateButton.setText(UIMessages.UpdateAllFeatures);
        this.updateButton.addSelectionListener((SelectionListener)this);
        this.manageButton = new Button(this.screen, 8);
        this.manageButton.setText(UIMessages.ManageFeatures);
        this.manageButton.addSelectionListener((SelectionListener)this);
        this.screen.layout();
        ScheduledPluginUninstall.uninstallFeatures();
        this.view.targetSite = ScheduledSiteInitialize.createTargetSite();
        if (ScheduledSiteInitialize.isRestartNeeded()) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(UIMessages.ConfirmRestart);
            messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestartForMigration, (Object[])this.view.RuntimeName));
            if (messageBox.open() == 64) {
                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                PlatformUI.getWorkbench().close();
            }
        }
        if (System.getProperty("sun.net.client.defaultConnectTimeout") == null) {
            System.setProperty("sun.net.client.defaultConnectTimeout", "6000");
        }
    }

    public void refresh() {
        Font font = null;
        FontData fontData = null;
        Button button = this.installButton.getBounds().width > this.updateButton.getBounds().width ? this.installButton : this.updateButton;
        if (button.getBounds().width < this.manageButton.getBounds().width) {
            button = this.manageButton;
        }
        int n = this.screen.getShell().getClientArea().width - button.getBounds().x - 5;
        if (button.getFont().getFontData().length > 0) {
            fontData = button.getFont().getFontData()[0];
            while (button.computeSize((int)-1, (int)-1).x > n) {
                fontData.setHeight(fontData.getHeight() - 1);
                if (fontData.getHeight() < 6) break;
                font = new Font((Device)Display.getCurrent(), fontData);
                button.setFont(font);
            }
        }
        if (font != null) {
            this.installButton.setFont(font);
            this.updateButton.setFont(font);
            this.manageButton.setFont(font);
            this.screen.layout();
        }
        try {
            IConfiguredSite[] iConfiguredSiteArray = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
            this.view.installedFeatures.clear();
            int n2 = 0;
            while (n2 < iConfiguredSiteArray.length) {
                if (iConfiguredSiteArray[n2].isEnabled()) {
                    IFeatureReference[] iFeatureReferenceArray = iConfiguredSiteArray[n2].getFeatureReferences();
                    int n3 = 0;
                    while (n3 < iFeatureReferenceArray.length) {
                        this.view.installedFeatures.add(iFeatureReferenceArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected void action() {
        this.installButton.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.installButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (selectionEvent.widget == this.updateButton) {
            this.view.availableFeatures.removeAllElements();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(9, true);
        } else if (selectionEvent.widget == this.manageButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(10, true);
        }
    }
}

