/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Locale;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class HyperLink
extends Control {
    public static final int URL = 1;
    public static final int EMAIL = 2;
    public static final int PHONE = 4;
    private Label label;
    private static Composite hackComposite;
    private static int hackStyle;
    private Color normalForeground;
    private Color activeForeground;
    private String argument;
    private int Global_Format;
    boolean isDispose = false;
    private Locale locale = Locale.getDefault();
    int i = 0;

    public HyperLink(Composite parent, int style, int format) {
        super(HyperLink.SaveStyle(parent, HyperLink.checkStyle(style)), HyperLink.checkStyle(style));
        this.normalForeground = this.getDisplay().getSystemColor(9);
        this.activeForeground = this.getDisplay().getSystemColor(12);
        this.setForeground(this.normalForeground);
        this.checkFormat(format);
    }

    private static Composite SaveStyle(Composite parent, int style) {
        hackStyle = style;
        hackComposite = parent;
        return parent;
    }

    private static int checkStyle(int style) {
        if ((style & 0x36E) != 0) {
            style &= 0xFFFFFC91;
        }
        return style;
    }

    private void checkFormat(int format) {
        this.Global_Format = format;
        if ((format & 0xFFFFFFF8) != 0) {
            SWT.error(5);
        }
        if ((format & 1) == 1 && (format | 1) != 1) {
            SWT.error(5);
        }
        if ((format & 2) == 2 && (format | 2) != 2) {
            SWT.error(5);
        }
        if ((format & 4) == 4 && (format | 4) != 4) {
            SWT.error(5);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        OS.HyperLink_SetUnderLine(this.internal_handle);
    }

    public String getText() {
        this.checkWidget();
        String return_argument = this.argument;
        if (this.argument == null) {
            return_argument = "";
        }
        if (this.Global_Format == 2 && return_argument.length() >= 7) {
            return_argument = return_argument.substring(7, return_argument.length());
        }
        return return_argument;
    }

    public void setText(String string) {
        this.checkWidget();
        String show_string = null;
        if (string == null) {
            SWT.error(4);
        }
        if (this.Global_Format == 1) {
            this.argument = string;
            show_string = string;
        } else if (this.Global_Format == 2) {
            this.argument = new String("mailto:");
            this.argument = this.argument.concat(string);
            show_string = string;
        } else if (this.Global_Format == 4) {
            this.argument = string;
            show_string = Locale.JAPAN.toString().equals(this.locale.toString()) ? this.JPPhoneLocale(string) : (Locale.FRANCE.toString().equals(this.locale.toString()) ? this.FrancePhoneLocale(string) : (Locale.CHINA.toString().equals(this.locale.toString()) ? this.ChinaPhoneLocale(string) : (new String("pl_PL").equals(this.locale.toString()) ? this.PolandPhoneLocale(string) : this.DefaultPhoneLocale(string))));
        }
        OS.HyperLink_SetUnderLine(this.internal_handle);
        OS.HyperLink_SetText(this.internal_handle, show_string);
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                HyperLink.this.label.setForeground(HyperLink.this.activeForeground);
                OS.HyperLink_Launch(((HyperLink)HyperLink.this).label.internal_handle, HyperLink.this.Global_Format, HyperLink.this.argument);
            }
        });
    }

    private String JPPhoneLocale(String string) {
        String TempString = null;
        if (string.length() < 5) {
            return string;
        }
        if (string.length() < 7) {
            TempString = new String();
            TempString = TempString.concat(string.substring(0, 4));
            TempString = TempString.concat("-");
            TempString = TempString.concat(string.substring(4, string.length()));
            return TempString;
        }
        TempString = new String();
        TempString = TempString.concat(string.substring(0, 4));
        TempString = TempString.concat("-");
        TempString = TempString.concat(string.substring(4, 6));
        TempString = TempString.concat("-");
        TempString = TempString.concat(string.substring(6, string.length()));
        return TempString;
    }

    private String ChinaPhoneLocale(String string) {
        String TempString = null;
        if (string.length() < 2) {
            TempString = new String("+");
            TempString = TempString.concat(string);
            return TempString;
        }
        if (string.length() < 5) {
            TempString = new String("+");
            TempString = TempString.concat(string.substring(0, 1));
            TempString = TempString.concat("-");
            TempString = TempString.concat(string.substring(1, string.length()));
            return TempString;
        }
        TempString = new String("+");
        TempString = TempString.concat(string.substring(0, 1));
        TempString = TempString.concat("-");
        TempString = TempString.concat(string.substring(1, 4));
        TempString = TempString.concat("-");
        TempString = TempString.concat(string.substring(4, string.length()));
        return TempString;
    }

    private String FrancePhoneLocale(String string) {
        String TempString = null;
        if (string.length() < 3) {
            return string;
        }
        if (string.length() < 5) {
            TempString = new String();
            TempString = TempString.concat(string.substring(0, 2));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(2, string.length()));
            return TempString;
        }
        if (string.length() < 7) {
            TempString = new String();
            TempString = TempString.concat(string.substring(0, 2));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(2, 4));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(4, string.length()));
            return TempString;
        }
        if (string.length() < 9) {
            TempString = new String();
            TempString = TempString.concat(string.substring(0, 2));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(2, 4));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(4, 6));
            TempString = TempString.concat(" ");
            TempString = TempString.concat(string.substring(6, string.length()));
            return TempString;
        }
        TempString = new String();
        TempString = TempString.concat(string.substring(0, 2));
        TempString = TempString.concat(" ");
        TempString = TempString.concat(string.substring(2, 4));
        TempString = TempString.concat(" ");
        TempString = TempString.concat(string.substring(4, 6));
        TempString = TempString.concat(" ");
        TempString = TempString.concat(string.substring(6, 8));
        TempString = TempString.concat(" ");
        TempString = TempString.concat(string.substring(8, string.length()));
        return TempString;
    }

    private String PolandPhoneLocale(String string) {
        String TempString = null;
        if (string.length() < 9) {
            return string;
        }
        TempString = new String("(");
        TempString = TempString.concat(string.substring(0, 2));
        TempString = TempString.concat(") ");
        TempString = TempString.concat(string.substring(2, 5));
        TempString = TempString.concat(".");
        TempString = TempString.concat(string.substring(5, 7));
        TempString = TempString.concat(".");
        TempString = TempString.concat(string.substring(7, string.length()));
        return TempString;
    }

    private String DefaultPhoneLocale(String string) {
        String TempString = null;
        if (string.length() < 3) {
            return string;
        }
        if (string.length() < 7) {
            TempString = new String("(");
            TempString = TempString.concat(string.substring(0, 3));
            TempString = TempString.concat(")");
            TempString = TempString.concat(string.substring(3, string.length()));
            return TempString;
        }
        TempString = new String("(");
        TempString = TempString.concat(string.substring(0, 3));
        TempString = TempString.concat(")");
        TempString = TempString.concat(string.substring(3, 6));
        TempString = TempString.concat("-");
        TempString = TempString.concat(string.substring(6, string.length()));
        return TempString;
    }

    public void internal_createHandle(int index) {
        this.label = new Label(hackComposite, HyperLink.checkStyle(hackStyle));
        this.internal_handle = this.label.internal_handle;
        hackComposite.internal_removeChild(this.label);
    }
}

