/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    Decorations parent;
    MenuItem cascade;
    boolean hasLocation = false;
    MenuItem defaultItem;
    boolean enabled = true;
    int x;
    int y;
    Vector items;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        parent.add(this);
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    void insertItem(MenuItem item, int index) {
        if (this.items == null) {
            this.items = new Vector();
        }
        if (index < 0 || index > this.items.size()) {
            SWT.error(14);
        }
        this.items.insertElementAt(item, index);
    }

    void removeItem(MenuItem item) {
        if (this.items == null || this.items.size() == 0) {
            SWT.error(15);
        }
        this.items.removeElement(item);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            Menu.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            Menu.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            Menu.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    protected void internal_createHandle(int index) {
        int parentHandle = this.parent.internal_handle;
        this.internal_handle = (this.internal_style & 2) == 2 ? OS.MenuBar_New(parentHandle) : ((this.internal_style & 4) == 4 ? OS.DropDownMenu_New(parentHandle) : OS.PopupMenu_New(parentHandle));
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                result = result + items[i].getNameText() + ", ";
            }
            result = result + items[length - 1].getNameText();
        }
        return result;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            Menu.error(6);
        }
        return (MenuItem)this.items.elementAt(index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new MenuItem[0];
        }
        Object[] copy = new MenuItem[this.items.size()];
        this.items.copyInto(copy);
        return copy;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            Menu.error(4);
        }
        if (item.isDisposed()) {
            Menu.error(5);
        }
        if (item.parent != this) {
            return -1;
        }
        return this._findItem(item);
    }

    int _findItem(MenuItem item) {
        if (this.items == null || this.items.size() == 0) {
            return -1;
        }
        return this.items.indexOf(item);
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void menuCallback(int type) {
        Event event = new Event();
        switch (type) {
            case 2: {
                this.sendEvent(23, event);
                break;
            }
            case 1: {
                this.sendEvent(22, event);
            }
        }
    }

    void releaseWidget() {
        MenuItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            MenuItem item = items[i];
            if (item.isDisposed()) continue;
            item.releaseResources();
        }
        if (this.getParentMenu() == null) {
            this.parent.remove(this);
        }
        super.releaseWidget();
        this.parent = null;
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            Menu.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.items != null) {
            int itemCount = this.items.size();
            for (int i = 0; i < itemCount; ++i) {
                ((MenuItem)this.items.elementAt(i)).updateEnabledStatus(enabled);
            }
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.internal_style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.internal_style & 6) != 0) {
            return;
        }
        if (!this.hasLocation) {
            this.centerMenu(this.x, this.y);
        }
        Point adjustedCoords = this.parent.toControl(this.x, this.y);
        OS.PopupMenu_Show(this.internal_handle, adjustedCoords.x, adjustedCoords.y);
    }

    void centerMenu(int xPos, int yPos) {
        Rectangle parentBounds = this.getParent().getBounds();
        int parentWidth = parentBounds.width;
        int parentHeight = parentBounds.height;
        this.x = parentBounds.x + parentWidth / 2;
        this.y = parentBounds.y + parentHeight / 2;
    }

    void fixMenus(Decorations newParent) {
        MenuItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].fixMenus(newParent);
        }
        this.parent.remove(this);
        newParent.add(this);
        this.parent = newParent;
    }
}

