/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;

public class FrameworkDebugOptions
implements DebugOptions {
    private Properties options = null;
    private static FrameworkDebugOptions singleton = null;
    private static boolean debugEnabled = true;
    private static final String OPTIONS = ".options";

    public static FrameworkDebugOptions getDefault() {
        FrameworkDebugOptions frameworkDebugOptions;
        if (singleton == null && debugEnabled && (debugEnabled = (frameworkDebugOptions = new FrameworkDebugOptions()).isDebugEnabled())) {
            singleton = frameworkDebugOptions;
        }
        return singleton;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith("file:");
        try {
            if (bl2) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string.substring(5)).toURL(), bl);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string).toURL(), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? String.valueOf(string) + "/" : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    private FrameworkDebugOptions() {
        this.loadOptions();
    }

    public boolean getBooleanOption(String string, boolean bl) {
        String string2 = this.getOption(string);
        return string2 != null && string2.equalsIgnoreCase("true") || bl;
    }

    public String getOption(String string) {
        return this.options != null ? this.options.getProperty(string) : null;
    }

    public String getOption(String string, String string2) {
        return this.options != null ? this.options.getProperty(string, string2) : string2;
    }

    public int getIntegerOption(String string, int n) {
        String string2 = this.getOption(string);
        try {
            return string2 == null ? n : Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void setOption(String string, String string2) {
        if (this.options != null) {
            this.options.put(string, string2.trim());
        }
    }

    private boolean isDebugEnabled() {
        return this.options != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        Object object;
        URL uRL;
        Object object2;
        String string = FrameworkProperties.getProperty("osgi.debug");
        if (string == null) {
            return;
        }
        this.options = new Properties();
        if (string.length() == 0) {
            object2 = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!((String)object2).endsWith("/")) {
                object2 = String.valueOf(object2) + "/";
            }
            string = ((Object)new File((String)object2, OPTIONS)).toString();
        }
        if ((uRL = FrameworkDebugOptions.buildURL(string, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + string);
            return;
        }
        System.out.print("Debug options:\n    " + uRL.toExternalForm());
        try {
            object2 = uRL.openStream();
            try {
                this.options.load((InputStream)object2);
                System.out.println(" loaded");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((InputStream)object2).close();
                throw throwable;
            }
            {
                object = null;
                ((InputStream)object2).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException iOException) {
            System.out.println(" did not parse");
            iOException.printStackTrace(System.out);
        }
        object2 = this.options.keySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                if (this.options.size() == 0) {
                    this.options = null;
                }
                return;
            }
            object = object2.next();
            this.options.put(object, ((String)this.options.get(object)).trim());
        }
    }
}

