/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;

public class HostSpecificationImpl
extends VersionConstraintImpl
implements HostSpecification {
    private BundleDescription[] hosts;
    private boolean multihost = false;

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof BundleDescription)) {
            return false;
        }
        BundleDescription bundleDescription = (BundleDescription)baseDescription;
        if (bundleDescription.getHost() != null) {
            return false;
        }
        return this.getName() != null && this.getName().equals(bundleDescription.getSymbolicName()) && (this.getVersionRange() == null || this.getVersionRange().isIncluded(bundleDescription.getVersion()));
    }

    public BundleDescription[] getHosts() {
        return this.hosts;
    }

    public boolean isResolved() {
        return this.hosts != null && this.hosts.length > 0;
    }

    void setHosts(BundleDescription[] bundleDescriptionArray) {
        this.hosts = bundleDescriptionArray;
    }

    public String toString() {
        return "Fragment-Host: " + this.getName() + "; bundle-version=\"" + this.getVersionRange() + "\"";
    }

    public BaseDescription getSupplier() {
        if (this.hosts == null || this.hosts.length == 0) {
            return null;
        }
        return this.hosts[0];
    }

    public boolean isMultiHost() {
        return this.multihost;
    }

    void setIsMultiHost(boolean bl) {
        this.multihost = bl;
    }
}

