/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public abstract class NLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    private static FrameworkLog frameworkLog;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final Object ASSIGNED;

    static {
        ASSIGNED = new Object();
    }

    protected NLS() {
    }

    public static String bind(String string, Object object) {
        return NLS.internalBind(string, null, String.valueOf(object), null);
    }

    public static String bind(String string, Object object, Object object2) {
        return NLS.internalBind(string, null, String.valueOf(object), String.valueOf(object2));
    }

    public static String bind(String string, Object[] objectArray) {
        return NLS.internalBind(string, objectArray, null, null);
    }

    public static void initializeMessages(final String string, final Class clazz) {
        if (System.getSecurityManager() == null) {
            NLS.load(string, clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NLS.load(string, clazz);
                return null;
            }
        });
    }

    private static String internalBind(String string, Object[] objectArray, String string2, String string3) {
        if (string == null) {
            return "No message available.";
        }
        if (objectArray == null || objectArray.length == 0) {
            objectArray = EMPTY_ARGS;
        }
        int n = string.length();
        int n2 = n + objectArray.length * 5;
        if (string2 != null) {
            n2 += string2.length() - 3;
        }
        if (string3 != null) {
            n2 += string3.length() - 3;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (c) {
                case '{': {
                    int n4 = string.indexOf(125, n3);
                    if (n4 == -1) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (++n3 >= n) {
                        stringBuffer.append(c);
                        break;
                    }
                    int n5 = -1;
                    try {
                        n5 = Integer.parseInt(string.substring(n3, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    if (n5 == 0 && string2 != null) {
                        stringBuffer.append(string2);
                    } else if (n5 == 1 && string3 != null) {
                        stringBuffer.append(string3);
                    } else {
                        if (n5 >= objectArray.length || n5 < 0) {
                            stringBuffer.append("<missing argument>");
                            n3 = n4;
                            break;
                        }
                        stringBuffer.append(objectArray[n5]);
                    }
                    n3 = n4;
                    break;
                }
                case '\'': {
                    int n6 = n3 + 1;
                    if (n6 >= n) {
                        stringBuffer.append(c);
                        break;
                    }
                    char c2 = string.charAt(n6);
                    if (c2 == '\'') {
                        ++n3;
                        stringBuffer.append(c);
                        break;
                    }
                    int n4 = string.indexOf(39, n6);
                    if (n4 == -1) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(string.substring(n6, n4));
                    n3 = n4;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        return ((Object)stringBuffer).toString();
    }

    private static String[] buildVariants(String string) {
        Object object;
        if (nlSuffixes == null) {
            object = Locale.getDefault().toString();
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (true) {
                arrayList.add(String.valueOf('_') + (String)object + EXTENSION);
                int n = object.lastIndexOf(95);
                if (n == -1) break;
                object = object.substring(0, n);
            }
            arrayList.add(EXTENSION);
            nlSuffixes = arrayList.toArray(new String[arrayList.size()]);
        }
        string = string.replace('.', '/');
        object = new String[nlSuffixes.length];
        int n = 0;
        while (n < ((String[])object).length) {
            object[n] = String.valueOf(string) + nlSuffixes[n];
            ++n;
        }
        return object;
    }

    private static void computeMissingMessages(String string, Class clazz, Map map, Field[] fieldArray, boolean bl) {
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 0x19) == 9 && map.get(field.getName()) != ASSIGNED) {
                try {
                    String string2 = "NLS missing message: " + field.getName() + " in: " + string;
                    if (Debug.DEBUG_MESSAGE_BUNDLES) {
                        System.out.println(string2);
                    }
                    NLS.log(2, string2, null);
                    if (!bl) {
                        field.setAccessible(true);
                    }
                    field.set(null, string2);
                }
                catch (Exception exception) {
                    NLS.log(4, "Error setting the missing message value for: " + field.getName(), exception);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void load(String string, Class clazz) {
        long l = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader classLoader = clazz.getClassLoader();
        boolean bl = (clazz.getModifiers() & 1) != 0;
        int n = fieldArray.length;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(n * 2);
        int n2 = 0;
        while (true) {
            if (n2 >= n) break;
            hashMap.put(fieldArray[n2].getName(), fieldArray[n2]);
            ++n2;
        }
        String[] stringArray = NLS.buildVariants(string);
        int n3 = 0;
        while (true) {
            block12: {
                InputStream inputStream;
                if (n3 >= stringArray.length) {
                    NLS.computeMissingMessages(string, clazz, hashMap, fieldArray, bl);
                    if (!Debug.DEBUG_MESSAGE_BUNDLES) return;
                    System.out.println("Time to load message bundle: " + string + " was " + (System.currentTimeMillis() - l) + "ms.");
                    return;
                }
                InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(stringArray[n3]) : classLoader.getResourceAsStream(stringArray[n3]);
                if (inputStream != null) {
                    Object var13_14;
                    try {
                        try {
                            MessagesProperties messagesProperties = new MessagesProperties(hashMap, string, bl);
                            messagesProperties.load(inputStream);
                        }
                        catch (IOException iOException) {
                            NLS.log(4, "Error loading " + stringArray[n3], iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var13_14 = null;
                        if (inputStream == null) break block12;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
            }
            ++n3;
        }
    }

    static void log(int n, String string, Exception exception) {
        String string2;
        if (frameworkLog != null) {
            frameworkLog.log(new FrameworkLogEntry("org.eclipse.osgi", n, 1, string, 0, exception, null));
            return;
        }
        switch (n) {
            case 4: {
                string2 = "Error: ";
                break;
            }
            default: {
                string2 = "Warning: ";
            }
        }
        if (string != null) {
            string2 = String.valueOf(string2) + string;
        }
        if (exception != null) {
            string2 = String.valueOf(string2) + ": " + exception.getMessage();
        }
        System.err.println(string2);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final boolean isAccessible;

        public MessagesProperties(Map map, String string, boolean bl) {
            this.fields = map;
            this.bundleName = string;
            this.isAccessible = bl;
        }

        public synchronized Object put(Object object, Object object2) {
            Object object3 = this.fields.put(object, ASSIGNED);
            if (object3 == ASSIGNED) {
                return null;
            }
            if (object3 == null) {
                String string = "NLS unused message: " + object + " in: " + this.bundleName;
                if (Debug.DEBUG_MESSAGE_BUNDLES) {
                    System.out.println(string);
                }
                NLS.log(2, string, null);
                return null;
            }
            Field field = (Field)object3;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, object2);
            }
            catch (Exception exception) {
                NLS.log(4, "Exception setting field value.", exception);
            }
            return null;
        }
    }
}

