/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ercp.xml.dom.AttrImpl;
import org.eclipse.ercp.xml.dom.AttributeMap;
import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.NodeImpl;
import org.eclipse.ercp.xml.dom.NodeListImpl;
import org.eclipse.ercp.xml.dom.TreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementImpl
extends TreeNode
implements Element {
    AttributeMap attributes = new AttributeMap(this);

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string);
    }

    public ElementImpl(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2);
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String string) {
        Attr attr = this.getAttributeNode(string);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.attributes.setNamedItem(string, string2);
    }

    public void removeAttribute(String string) throws DOMException {
        this.attributes.removeNamedItem(string);
    }

    public Attr getAttributeNode(String string) {
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return (Attr)this.attributes.removeItem(attr);
    }

    protected void getElementByTagName(String string, NodeListImpl nodeListImpl) {
        if ("*".equals(string) || this.getTagName().equals(string)) {
            nodeListImpl.addNode(this);
        }
        super.getElementByTagName(string, nodeListImpl);
    }

    public String getAttributeNS(String string, String string2) {
        Attr attr = this.getAttributeNodeNS(string, string2);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.attributes.setNamedItemNS(string, string2, string3);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.attributes.removeNamedItemNS(string, string2);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.setAttributeNode(attr);
    }

    void getElementsByTagNameNS(String string, String string2, NodeListImpl nodeListImpl) {
        if (("*".equals(string) || this.getNamespaceURI().equals(string)) && ("*".equals(string2) || this.getLocalName().equals(string2))) {
            nodeListImpl.addNode(this);
        }
        super.getElementsByTagNameNS(string, string2, nodeListImpl);
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public short getNodeType() {
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() != 0;
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = new ElementImpl(this.ownerDocument, this.namespaceURI, this.qualifiedName);
        Hashtable hashtable = this.attributes.attributes;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AttrImpl attrImpl = (AttrImpl)hashtable.get(k);
            AttrImpl attrImpl2 = (AttrImpl)attrImpl.cloneNode(bl);
            attrImpl2.ownerElement = elementImpl;
            elementImpl.setAttributeNode(attrImpl2);
        }
        if (bl) {
            int n = this.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = this.item(n2);
                Node node2 = node.cloneNode(bl);
                elementImpl.appendChild(node2);
                ++n2;
            }
        }
        return elementImpl;
    }

    protected void spreadOwnerDocument(DocumentImpl documentImpl) {
        if (this.ownerDocument.ownerDocument == documentImpl) {
            return;
        }
        super.spreadOwnerDocument(documentImpl);
        Hashtable hashtable = this.attributes.attributes;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AttrImpl attrImpl = (AttrImpl)hashtable.get(k);
            attrImpl.spreadOwnerDocument(documentImpl);
        }
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            ((NodeImpl)this.item(n2)).spreadOwnerDocument(documentImpl);
            ++n2;
        }
    }
}

