/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.util.Util;

public class OverlayIcon
extends CompositeImageDescriptor {
    private Point fSize = null;
    private ImageDescriptor fBase = null;
    private ImageDescriptor fOverlay = null;

    public OverlayIcon(ImageDescriptor imageDescriptor, ImageDescriptor imageDescriptor2, Point point) {
        this.fBase = imageDescriptor;
        this.fOverlay = imageDescriptor2;
        this.fSize = point;
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData;
        if (this.fBase == null || (imageData = this.fBase.getImageData()) == null) {
            imageData = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(imageData, 0, 0);
        if (this.fOverlay != null) {
            this.drawTopRight(this.fOverlay);
        }
    }

    protected void drawTopRight(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return;
        }
        int n = this.getSize().x;
        ImageData imageData = imageDescriptor.getImageData();
        this.drawImage(imageData, n -= imageData.width, 0);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public int hashCode() {
        return Util.hashCode(this.fBase) * 17 + Util.hashCode(this.fOverlay);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OverlayIcon)) {
            return false;
        }
        OverlayIcon overlayIcon = (OverlayIcon)((Object)object);
        return Util.equals(this.fBase, overlayIcon.fBase) && Util.equals(this.fOverlay, overlayIcon.fOverlay) && Util.equals(this.fSize, overlayIcon.fSize);
    }
}

