/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.layout.SizeCache;

public class LayoutCache {
    private SizeCache[] caches = new SizeCache[0];

    public LayoutCache() {
    }

    public LayoutCache(Control[] controlArray) {
        this.rebuildCache(controlArray);
    }

    public SizeCache getCache(int n) {
        return this.caches[n];
    }

    public void setControls(Control[] controlArray) {
        if (controlArray.length != this.caches.length) {
            this.rebuildCache(controlArray);
            return;
        }
        int n = 0;
        while (n < controlArray.length) {
            this.caches[n].setControl(controlArray[n]);
            ++n;
        }
    }

    private void rebuildCache(Control[] controlArray) {
        SizeCache[] sizeCacheArray = new SizeCache[controlArray.length];
        int n = 0;
        while (n < controlArray.length) {
            if (n < this.caches.length) {
                sizeCacheArray[n] = this.caches[n];
                sizeCacheArray[n].setControl(controlArray[n]);
            } else {
                sizeCacheArray[n] = new SizeCache(controlArray[n]);
            }
            ++n;
        }
        this.caches = sizeCacheArray;
    }

    public Point computeSize(int n, int n2, int n3) {
        return this.caches[n].computeSize(n2, n3);
    }

    public void flush(int n) {
        this.caches[n].flush();
    }

    public void flush() {
        int n = 0;
        while (n < this.caches.length) {
            this.caches[n].flush();
            ++n;
        }
    }
}

