/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.layout.ICachingLayout;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.layout.TrimLayoutData;

public class TrimLayout
extends Layout
implements ICachingLayout {
    private static final TrimLayoutData defaultData = new TrimLayoutData();
    private SizeCache centerArea = new SizeCache();
    private List[] controls;
    private int[] trimSizes;
    private int marginWidth;
    private int marginHeight;
    private int topSpacing;
    private int bottomSpacing;
    private int leftSpacing;
    private int rightSpacing;
    private Map mapPartOntoTrimData = new HashMap();
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int NONTRIM = 4;

    public TrimLayout() {
        this.controls = new List[4];
        this.trimSizes = new int[this.controls.length];
        int n = 0;
        while (n < this.controls.length) {
            this.controls[n] = new LinkedList();
            this.trimSizes[n] = -1;
            ++n;
        }
    }

    public void setSpacing(int n, int n2, int n3, int n4) {
        this.leftSpacing = n;
        this.rightSpacing = n2;
        this.topSpacing = n3;
        this.bottomSpacing = n4;
    }

    public void setMargins(int n, int n2) {
        this.marginWidth = n;
        this.marginHeight = n2;
    }

    private int convertSwtConstantToIndex(int n) {
        switch (n) {
            case 128: {
                return 0;
            }
            case 1024: {
                return 1;
            }
            case 16384: {
                return 2;
            }
            case 131072: {
                return 3;
            }
        }
        return 0;
    }

    private int convertIndexToSwtConstant(int n) {
        switch (n) {
            case 0: {
                return 128;
            }
            case 1: {
                return 1024;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 131072;
            }
            case 4: {
                return -1;
            }
        }
        return 0;
    }

    private static void filterResizable(List list, List list2, List list3, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SizeCache sizeCache = (SizeCache)iterator.next();
            if (TrimLayout.isResizable(sizeCache.getControl(), bl)) {
                list2.add(sizeCache);
                continue;
            }
            list3.add(sizeCache);
        }
    }

    private static boolean isResizable(Control control, boolean bl) {
        TrimLayoutData trimLayoutData = TrimLayout.getData(control);
        if (!trimLayoutData.resizable) {
            return false;
        }
        if (bl) {
            return trimLayoutData.widthHint == -1;
        }
        return trimLayoutData.heightHint == -1;
    }

    private static TrimLayoutData getData(Control control) {
        TrimLayoutData trimLayoutData = (TrimLayoutData)control.getLayoutData();
        if (trimLayoutData == null) {
            trimLayoutData = defaultData;
        }
        return trimLayoutData;
    }

    private static Point computeSize(SizeCache sizeCache, int n, int n2) {
        TrimLayoutData trimLayoutData = TrimLayout.getData(sizeCache.getControl());
        if (n == -1) {
            n = trimLayoutData.widthHint;
        }
        if (n2 == -1) {
            n2 = trimLayoutData.heightHint;
        }
        if (n == -1 || n2 == -1) {
            return sizeCache.computeSize(n, n2);
        }
        return new Point(n, n2);
    }

    private static int getSize(SizeCache sizeCache, int n, boolean bl) {
        if (bl) {
            return TrimLayout.computeSize((SizeCache)sizeCache, (int)-1, (int)n).x;
        }
        return TrimLayout.computeSize((SizeCache)sizeCache, (int)n, (int)-1).y;
    }

    private static int maxDimension(List list, int n, boolean bl) {
        Object object;
        if (n == -1) {
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SizeCache sizeCache = (SizeCache)iterator.next();
                n2 = Math.max(TrimLayout.getSize(sizeCache, -1, bl), n2);
            }
            return n2;
        }
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList(list.size());
        TrimLayout.filterResizable(list, arrayList, arrayList2, bl);
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SizeCache sizeCache = (SizeCache)iterator.next();
            object = TrimLayout.computeSize(sizeCache, -1, -1);
            if (bl) {
                n3 = Math.max(n3, object.x);
                n4 += object.y;
                continue;
            }
            n3 = Math.max(n3, object.y);
            n4 += object.x;
        }
        if (arrayList.size() > 0) {
            int n5 = (n - n4) / arrayList.size();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (SizeCache)iterator.next();
                n3 = Math.max(n3, TrimLayout.getSize((SizeCache)object, n5, bl));
            }
        }
        return n3;
    }

    public void setTrimSize(int n, int n2) {
        int n3 = this.convertSwtConstantToIndex(n);
        this.trimSizes[n3] = n2;
    }

    public int getTrimLocation(Control control) {
        return this.convertIndexToSwtConstant(this.getIndex(control));
    }

    public void addTrim(Control control, int n) {
        this.addTrim(control, n, null);
    }

    public void addTrim(Control control, int n, Control control2) {
        this.removeTrim(control);
        int n2 = this.convertSwtConstantToIndex(n);
        List list = this.controls[n2];
        SizeCache sizeCache = new SizeCache(control);
        TrimLayout.insertBefore(list, sizeCache, control2);
        this.mapPartOntoTrimData.put(control, new TrimData(n2, sizeCache));
    }

    private static void insertBefore(List list, SizeCache sizeCache, Control control) {
        if (control != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SizeCache sizeCache2 = (SizeCache)iterator.next();
                if (sizeCache2.getControl() == control) break;
                ++n;
            }
            list.add(n, sizeCache);
        } else {
            list.add(sizeCache);
        }
    }

    private static void remove(List list, Control control) {
        SizeCache sizeCache = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SizeCache sizeCache2 = (SizeCache)iterator.next();
            if (sizeCache2.getControl() != control) continue;
            sizeCache = sizeCache2;
            break;
        }
        list.remove(sizeCache);
    }

    public void removeTrim(Control control) {
        int n = this.getIndex(control);
        if (n == 4) {
            return;
        }
        TrimLayout.remove(this.controls[n], control);
        this.mapPartOntoTrimData.remove(control);
    }

    private int getIndex(Control control) {
        TrimData trimData = (TrimData)this.mapPartOntoTrimData.get(control);
        if (trimData == null) {
            return 4;
        }
        return trimData.controlsIndex;
    }

    private void removeDisposed() {
        int n = 0;
        while (n < this.controls.length) {
            List list = this.controls[n];
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SizeCache sizeCache = (SizeCache)iterator.next();
                    Control control = sizeCache.getControl();
                    if (!control.isDisposed() && this.getIndex(control) == n) continue;
                    iterator.remove();
                }
            }
            ++n;
        }
    }

    private int[] getTrimSizes(int n, int n2) {
        int[] nArray = new int[this.controls.length];
        int n3 = 0;
        while (n3 < this.trimSizes.length) {
            nArray[n3] = this.controls[n3].isEmpty() ? 0 : this.trimSizes[n3];
            ++n3;
        }
        if (nArray[0] == -1) {
            nArray[0] = TrimLayout.maxDimension(this.controls[0], n, false);
        }
        if (nArray[1] == -1) {
            nArray[1] = TrimLayout.maxDimension(this.controls[1], n, false);
        }
        if (nArray[2] == -1) {
            nArray[2] = TrimLayout.maxDimension(this.controls[2], n2, true);
        }
        if (nArray[3] == -1) {
            nArray[3] = TrimLayout.maxDimension(this.controls[3], n2, true);
        }
        return nArray;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = new Point(n, n2);
        int[] nArray = this.getTrimSizes(n, n2);
        int n3 = nArray[2] + nArray[3] + 2 * this.marginWidth + this.leftSpacing + this.rightSpacing;
        int n4 = nArray[0] + nArray[1] + 2 * this.marginHeight + this.topSpacing + this.bottomSpacing;
        Point point2 = this.centerArea.computeSize(n == -1 ? n : n - n3, n2 == -1 ? n2 : n2 - n4);
        if (n == -1) {
            point.x = point2.x + n3;
        } else if (n2 == -1) {
            point.y = point2.y + n4;
        }
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean bl) {
        this.removeDisposed();
        Rectangle rectangle = composite.getClientArea();
        rectangle.x += this.marginWidth;
        rectangle.width -= 2 * this.marginWidth;
        rectangle.y += this.marginHeight;
        rectangle.height -= 2 * this.marginHeight;
        int[] nArray = this.getTrimSizes(rectangle.width, rectangle.height);
        int n = rectangle.x;
        int n2 = n + nArray[2] + this.leftSpacing;
        int n3 = rectangle.width - nArray[2] - nArray[3] - this.leftSpacing - this.rightSpacing;
        int n4 = rectangle.x + rectangle.width - nArray[3];
        int n5 = rectangle.y;
        int n6 = n5 + nArray[0] + this.topSpacing;
        int n7 = rectangle.height - nArray[0] - nArray[1] - this.topSpacing - this.bottomSpacing;
        int n8 = rectangle.y + rectangle.height - nArray[1];
        TrimLayout.arrange(new Rectangle(n, n5, rectangle.width, nArray[0]), this.controls[0], true);
        TrimLayout.arrange(new Rectangle(n2, n8, n3, nArray[1]), this.controls[1], true);
        TrimLayout.arrange(new Rectangle(n, n6, nArray[2], rectangle.height - nArray[0]), this.controls[2], false);
        TrimLayout.arrange(new Rectangle(n4, n6, nArray[3], rectangle.height - nArray[0]), this.controls[3], false);
        if (this.centerArea.getControl() != null) {
            this.centerArea.getControl().setBounds(n2, n6, n3, n7);
        }
    }

    private void flushCaches() {
        int n = 0;
        while (n < this.controls.length) {
            List list = this.controls[n];
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SizeCache sizeCache = (SizeCache)iterator.next();
                    sizeCache.flush();
                }
            }
            ++n;
        }
        this.centerArea.flush();
    }

    private static void arrange(Rectangle rectangle, List list, boolean bl) {
        Point point = new Point(rectangle.x, rectangle.y);
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList(list.size());
        TrimLayout.filterResizable(list, arrayList, arrayList2, bl);
        int[] nArray = new int[arrayList2.size()];
        int n = 0;
        int n2 = 0;
        int n3 = Geometry.getDimension((Rectangle)rectangle, (!bl ? 1 : 0) != 0);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SizeCache sizeCache = (SizeCache)iterator.next();
            nArray[n] = TrimLayout.getSize(sizeCache, n3, bl);
            n2 += nArray[n];
            ++n;
        }
        int n4 = Geometry.getDimension((Rectangle)rectangle, (boolean)bl) - n2;
        n = 0;
        int n5 = arrayList.size();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            int n6;
            SizeCache sizeCache = (SizeCache)iterator.next();
            if (TrimLayout.isResizable(sizeCache.getControl(), bl)) {
                n6 = n4 / n5;
                n4 -= n6;
                --n5;
            } else {
                n6 = nArray[n];
                ++n;
            }
            if (bl) {
                sizeCache.getControl().setBounds(point.x, point.y, n6, n3);
                point.x += n6;
                continue;
            }
            sizeCache.getControl().setBounds(point.x, point.y, n3, n6);
            point.y += n6;
        }
    }

    public void setCenterControl(Control control) {
        this.centerArea.setControl(control);
    }

    public Control getCenterControl() {
        return this.centerArea.getControl();
    }

    public void flush(Control control) {
        TrimData trimData = (TrimData)this.mapPartOntoTrimData.get(control);
        if (trimData == null) {
            if (control == this.centerArea.getControl()) {
                this.centerArea.flush();
            }
        } else {
            trimData.cache.flush();
        }
    }

    private class TrimData {
        int controlsIndex;
        SizeCache cache;

        TrimData(int n, SizeCache sizeCache) {
            this.cache = sizeCache;
            this.controlsIndex = n;
        }
    }
}

