/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.part.components.services.IStatusFactory;
import org.osgi.framework.Bundle;

public class StatusFactory
implements IStatusFactory {
    private Bundle pluginBundle;

    public StatusFactory(Bundle bundle) {
        this.pluginBundle = bundle;
    }

    public IStatus newError(Throwable throwable) {
        String string = StatusUtil.getLocalizedMessage(throwable);
        return this.newError(string, throwable);
    }

    public IStatus newError(String string, Throwable throwable) {
        String string2 = this.pluginBundle.getSymbolicName();
        int n = 0;
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            string2 = coreException.getStatus().getPlugin();
            n = coreException.getStatus().getCode();
        }
        return new Status(4, string2, n, string, StatusUtil.getCause(throwable));
    }

    public IStatus newStatus(int n, String string) {
        return new Status(n, this.pluginBundle.getSymbolicName(), 0, string, null);
    }

    public IStatus newMessage(String string) {
        return this.newStatus(1, string);
    }
}

