/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.core.FileFragment;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public abstract class FeatureContentProvider
implements IFeatureContentProvider {
    private static final boolean SWITCH_COPY_LOCAL = true;
    private URL base;
    private IFeature feature;
    private File tmpDir;
    public static final String JAR_EXTENSION = ".jar";
    private static final String DOT_PERMISSIONS = "permissions.properties";
    private static final String EXECUTABLES = "permissions.executable";
    private static final Object lock = new Object();
    private static Hashtable locks = new Hashtable();

    public FeatureContentProvider(URL uRL) {
        this.base = uRL;
        this.feature = null;
    }

    public URL getURL() {
        return this.base;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature iFeature) {
        this.feature = iFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentReference asLocalReference(ContentReference contentReference, InstallMonitor installMonitor) throws IOException, CoreException {
        if (contentReference.isLocalReference()) {
            return contentReference;
        }
        String string = contentReference.toString();
        File file = null;
        FileFragment fileFragment = null;
        Object var6_6 = null;
        Object object = lock;
        synchronized (object) {
            if (locks.get(string) == null) {
                locks.put(string, string);
            }
            var6_6 = locks.get(string);
        }
        object = var6_6;
        synchronized (object) {
            boolean bl;
            long l;
            OutputStream outputStream;
            block46: {
                file = Utilities.lookupLocalFile(string);
                if (file != null && UpdateManagerUtils.isSameTimestamp(contentReference.asURL(), file.lastModified())) {
                    return contentReference.createContentReference(contentReference.getIdentifier(), file);
                }
                if (file == null) {
                    fileFragment = UpdateManagerUtils.lookupLocalFileFragment(string);
                }
                InputStream inputStream = null;
                outputStream = null;
                l = 0L;
                long l2 = 0L;
                bl = false;
                if (installMonitor != null) {
                    installMonitor.saveState();
                    installMonitor.setTaskName(Messages.FeatureContentProvider_Downloading);
                    installMonitor.subTask(String.valueOf(contentReference.getIdentifier()) + " ");
                    installMonitor.setTotalCount(contentReference.getInputSize());
                    installMonitor.showCopyDetails(true);
                }
                try {
                    try {
                        long l3;
                        if (fileFragment != null && "http".equals(contentReference.asURL().getProtocol())) {
                            file = fileFragment.getFile();
                            try {
                                inputStream = contentReference.getPartialInputStream(fileFragment.getSize());
                                l2 = contentReference.getInputSize() - fileFragment.getSize();
                                outputStream = new BufferedOutputStream(new FileOutputStream(file.getPath(), true));
                            }
                            catch (IOException iOException) {
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException iOException2) {}
                                inputStream = null;
                                outputStream = null;
                                fileFragment = null;
                            }
                        }
                        if (inputStream == null) {
                            file = Utilities.createLocalFile(this.getWorkingDirectory(), null);
                            try {
                                inputStream = contentReference.getInputStream();
                                l2 = contentReference.getInputSize();
                            }
                            catch (IOException iOException) {
                                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureContentProvider_UnableToRetrieve, (Object[])new Object[]{contentReference}), iOException);
                            }
                            try {
                                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureContentProvider_UnableToCreate, (Object[])new Object[]{file}), fileNotFoundException);
                            }
                        }
                        Date date = new Date();
                        if (fileFragment != null) {
                            l = fileFragment.getSize();
                            if (installMonitor != null) {
                                installMonitor.setCopyCount(l);
                            }
                        }
                        if ((l3 = UpdateManagerUtils.copy(inputStream, outputStream, installMonitor, l2)) != -1L) {
                            if ((l += l3) > 0L) {
                                UpdateManagerUtils.mapLocalFileFragment(string, new FileFragment(file, l));
                            }
                            if (!installMonitor.isCanceled()) throw new FeatureDownloadException(NLS.bind((String)Messages.FeatureContentProvider_ExceptionDownloading, (Object[])new Object[]{this.getURL().toExternalForm()}), new IOException());
                            String string2 = Messages.Feature_InstallationCancelled;
                            throw new InstallAbortedException(string2, null);
                        }
                        UpdateManagerUtils.unMapLocalFileFragment(string);
                        Date date2 = new Date();
                        long l4 = (date2.getTime() - date.getTime()) / 1000L;
                        InternalSiteManager.downloaded(contentReference.getInputSize(), l4, contentReference.asURL());
                        bl = true;
                        Utilities.mapLocalFile(string, file);
                    }
                    catch (ClassCastException classCastException) {
                        throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureContentProvider_UnableToCreate, (Object[])new Object[]{file}), classCastException);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_22 = null;
                    if (bl && inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (bl || l > 0L) {
                        file.setLastModified(contentReference.getLastModified());
                    }
                    if (installMonitor == null) throw throwable;
                    installMonitor.restoreState();
                    throw throwable;
                }
                {
                    Object var21_23 = null;
                    if (!bl || inputStream == null) break block46;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
            if (outputStream != null) {
                try {}
                catch (IOException iOException) {}
                outputStream.close();
            }
            if (bl || l > 0L) {
                file.setLastModified(contentReference.getLastModified());
            }
            if (installMonitor != null) {
                installMonitor.restoreState();
            }
            locks.remove(string);
            return contentReference.createContentReference(contentReference.getIdentifier(), file);
        }
    }

    public File asLocalFile(ContentReference contentReference, InstallMonitor installMonitor) throws IOException, CoreException {
        File file = contentReference.asFile();
        ContentReference contentReference2 = this.asLocalReference(contentReference, installMonitor);
        file = contentReference2.asFile();
        return file;
    }

    protected File getWorkingDirectory() throws IOException {
        if (this.tmpDir == null) {
            this.tmpDir = Utilities.createWorkingDirectory();
        }
        return this.tmpDir;
    }

    public long getDownloadSizeFor(IPluginEntry[] iPluginEntryArray, INonPluginEntry[] iNonPluginEntryArray) {
        int n;
        long l = 0L;
        if (!(iPluginEntryArray != null && iPluginEntryArray.length != 0 || iNonPluginEntryArray != null && iNonPluginEntryArray.length != 0)) {
            return -1L;
        }
        long l2 = 0L;
        if (iPluginEntryArray != null) {
            n = 0;
            while (n < iPluginEntryArray.length) {
                l2 = ((PluginEntryModel)((Object)iPluginEntryArray[n])).getDownloadSize();
                if (l2 == -1L) {
                    return -1L;
                }
                l += l2;
                ++n;
            }
        }
        if (iNonPluginEntryArray != null) {
            n = 0;
            while (n < iNonPluginEntryArray.length) {
                l2 = ((NonPluginEntryModel)((Object)iNonPluginEntryArray[n])).getDownloadSize();
                if (l2 == -1L) {
                    return -1L;
                }
                l += l2;
                ++n;
            }
        }
        return l;
    }

    public long getInstallSizeFor(IPluginEntry[] iPluginEntryArray, INonPluginEntry[] iNonPluginEntryArray) {
        int n;
        long l = 0L;
        if (!(iPluginEntryArray != null && iPluginEntryArray.length != 0 || iNonPluginEntryArray != null && iNonPluginEntryArray.length != 0)) {
            return -1L;
        }
        long l2 = 0L;
        if (iPluginEntryArray != null) {
            n = 0;
            while (n < iPluginEntryArray.length) {
                l2 = ((PluginEntryModel)((Object)iPluginEntryArray[n])).getInstallSize();
                if (l2 == -1L) {
                    return -1L;
                }
                l += l2;
                ++n;
            }
        }
        if (iNonPluginEntryArray != null) {
            n = 0;
            while (n < iNonPluginEntryArray.length) {
                l2 = ((NonPluginEntryModel)((Object)iNonPluginEntryArray[n])).getInstallSize();
                if (l2 == -1L) {
                    return -1L;
                }
                l += l2;
                ++n;
            }
        }
        return l;
    }

    protected String getPathID(IPluginEntry iPluginEntry) {
        return "plugins/" + iPluginEntry.getVersionedIdentifier().toString() + JAR_EXTENSION;
    }

    protected String getPathID(INonPluginEntry iNonPluginEntry) {
        String string = "features/" + this.feature.getVersionedIdentifier().toString() + "/";
        return String.valueOf(string) + iNonPluginEntry.getIdentifier();
    }

    protected void validatePermissions(ContentReference[] contentReferenceArray) {
        if (contentReferenceArray == null || contentReferenceArray.length == 0) {
            return;
        }
        Map map = this.getPermissions(contentReferenceArray);
        if (map.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < contentReferenceArray.length) {
            ContentReference contentReference = contentReferenceArray[n];
            String string = contentReference.getIdentifier();
            Object object = null;
            object = this.matchesOneRule(string, map);
            if (object != null) {
                Integer n2 = (Integer)object;
                contentReference.setPermission(n2);
            }
            ++n;
        }
    }

    private Object matchesOneRule(String string, Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileFilter fileFilter = (FileFilter)iterator.next();
            if (!fileFilter.accept(string)) continue;
            return map.get(fileFilter);
        }
        return null;
    }

    private Map getPermissions(ContentReference[] contentReferenceArray) {
        Object object;
        HashMap<FileFilter, Integer> hashMap = new HashMap<FileFilter, Integer>();
        boolean bl = true;
        ContentReference contentReference = null;
        int n = 0;
        while (n < contentReferenceArray.length && bl) {
            object = contentReferenceArray[n];
            if (DOT_PERMISSIONS.equals(((ContentReference)object).getIdentifier())) {
                bl = false;
                contentReference = object;
            }
            ++n;
        }
        if (bl) {
            return hashMap;
        }
        Properties properties = new Properties();
        try {
            properties.load(contentReference.getInputStream());
        }
        catch (IOException iOException) {
            UpdateCore.warn("", iOException);
        }
        object = properties.getProperty(EXECUTABLES);
        if (object == null) {
            return hashMap;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
        Integer n2 = new Integer(-1);
        while (stringTokenizer.hasMoreTokens()) {
            FileFilter fileFilter = new FileFilter(stringTokenizer.nextToken());
            hashMap.put(fileFilter, n2);
        }
        return hashMap;
    }

    public class FileFilter {
        private IPath filterPath = null;

        public FileFilter(String string) {
            this.filterPath = new Path(string);
        }

        public boolean accept(String string) {
            IPath iPath;
            String string2;
            if (string == null) {
                return false;
            }
            Path path = new Path(string);
            if (this.filterPath.lastSegment().indexOf(42) == -1) {
                return this.filterPath.equals((Object)path);
            }
            String string3 = this.filterPath.getFileExtension();
            if (!string3.equals("*") ? !string3.equalsIgnoreCase(path.getFileExtension()) : !(string2 = (iPath = this.filterPath.removeFileExtension()).lastSegment()).equals("*") && !path.lastSegment().startsWith(string2)) {
                return false;
            }
            iPath = path.removeLastSegments(1);
            string2 = this.filterPath.removeLastSegments(1);
            return iPath.equals((Object)string2);
        }
    }
}

