/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.Locale;

public class TextProcessor {
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String FILE_SEP_FSLASH = "/";
    private static final String FILE_SEP_BSLASH = "\\";
    private static final String delimiterString = ".:/\\";
    private static final char LRM = '\u200e';
    private static final char LRE = '\u202a';
    private static final char PDF = '\u202c';
    private static boolean isBidi;
    private static boolean isSupportedPlatform;
    private static final int INDEX_NOT_SET = 999999999;

    static {
        String string;
        isBidi = false;
        isSupportedPlatform = false;
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        if ("iw".equals(string2) || "he".equals(string2) || "ar".equals(string2) || "fa".equals(string2) || "ur".equals(string2)) {
            isBidi = true;
        }
        if ((string = System.getProperty("os.name").toLowerCase()).startsWith("windows") || string.startsWith("linux")) {
            isSupportedPlatform = true;
        }
    }

    public static String process(String string) {
        return TextProcessor.process(string, TextProcessor.getDefaultDelimiters());
    }

    public static String process(String string, String string2) {
        if (string == null || string.length() <= 1 || !isSupportedPlatform || !isBidi) {
            return string;
        }
        if (string.charAt(0) == '\u202a' && string.charAt(string.length() - 1) == '\u202c') {
            return string;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 999999999;
        string2 = string2 == null ? TextProcessor.getDefaultDelimiters() : string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\u202a');
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) != -1) {
                if (bl2) {
                    n = stringBuffer.length();
                }
            } else if (Character.isDigit(c)) {
                if (n != 999999999) {
                    stringBuffer.insert(n, '\u200e');
                    n = 999999999;
                    bl2 = false;
                }
            } else if (Character.isLetter(c)) {
                if (TextProcessor.isRTL(c)) {
                    bl = true;
                    if (n != 999999999) {
                        stringBuffer.insert(n, '\u200e');
                        n = 999999999;
                    }
                    bl2 = true;
                } else {
                    n = 999999999;
                    bl2 = false;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        if (bl || !Character.isLetter(string.charAt(0)) || TextProcessor.isNeutral(string.charAt(string.length() - 1))) {
            stringBuffer.append('\u202c');
            return ((Object)stringBuffer).toString();
        }
        return string;
    }

    public static String deprocess(String string) {
        if (string == null || string.length() <= 1 || !isSupportedPlatform || !isBidi) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\u202a': {
                    break;
                }
                case '\u202c': {
                    break;
                }
                case '\u200e': {
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return ((Object)stringBuffer).toString();
    }

    public static String getDefaultDelimiters() {
        return delimiterString;
    }

    private static boolean isRTL(char c) {
        return c >= '\u05d0' && c <= '\u07b1' || c >= '\ufb1d' && c <= '\ufefc';
    }

    private static boolean isNeutral(char c) {
        return !Character.isDigit(c) && !Character.isLetter(c);
    }

    private TextProcessor() {
    }
}

